/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.maven.model.impl;

import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.FileFilter;
import java.util.Collection;
import org.codehaus.plexus.util.SelectorUtils;
import org.codehaus.plexus.util.StringUtils;
import org.jetbrains.jps.maven.model.impl.FilePattern;

public class MavenResourceFileFilter
implements FileFilter {
    private String[] myNormalizedIncludes;
    private String[] myNormalizedExcludes;
    private FilePattern myFilePattern;
    private File myRoot;

    public MavenResourceFileFilter(File rootFile, FilePattern filePattern) {
        this.myFilePattern = filePattern;
        this.myRoot = rootFile;
    }

    @Override
    public boolean accept(File file) {
        String relPath = FileUtil.getRelativePath((File)this.myRoot, (File)file);
        return relPath != null && this.isIncluded(relPath);
    }

    private boolean isIncluded(String relativePath) {
        if (this.myNormalizedIncludes == null) {
            this.myNormalizedIncludes = this.myFilePattern.includes.isEmpty() ? new String[]{"**" + File.separatorChar + '*'} : MavenResourceFileFilter.normalizePatterns(this.myFilePattern.includes);
        }
        if (this.myNormalizedExcludes == null) {
            this.myNormalizedExcludes = MavenResourceFileFilter.normalizePatterns(this.myFilePattern.excludes);
        }
        return MavenResourceFileFilter.isIncluded(relativePath, this.myNormalizedIncludes, this.myNormalizedExcludes);
    }

    private static boolean isIncluded(String relativeName, String[] includes, String[] excludes) {
        boolean isIncluded = false;
        for (String each : includes) {
            if (!SelectorUtils.matchPath((String)each, (String)relativeName)) continue;
            isIncluded = true;
            break;
        }
        if (!isIncluded) {
            return false;
        }
        for (String each : excludes) {
            if (!SelectorUtils.matchPath((String)each, (String)relativeName)) continue;
            return false;
        }
        return true;
    }

    private static String[] normalizePatterns(Collection<String> patterns) {
        String[] res = new String[patterns.size()];
        int i = 0;
        for (String pattern : patterns) {
            res[i++] = MavenResourceFileFilter.normalizePattern(pattern);
        }
        return res;
    }

    private static String normalizePattern(String pattern) {
        if ((pattern = pattern.trim()).startsWith("%regex[")) {
            pattern = File.separatorChar == '\\' ? StringUtils.replace((String)pattern, (String)"/", (String)"\\\\") : StringUtils.replace((String)pattern, (String)"\\\\", (String)"/");
        } else if ((pattern = pattern.replace(File.separatorChar == '/' ? (char)'\\' : '/', File.separatorChar)).endsWith(File.separator)) {
            pattern = pattern + "**";
        }
        return pattern;
    }
}

