/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.tasks;

import com.android.annotations.NonNull;
import com.android.builder.tasks.Job;
import com.android.builder.tasks.QueueThreadContext;
import com.android.utils.ILogger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WorkQueue<T>
implements Runnable {
    private final ILogger mLogger;
    private final String mName;
    private final LinkedBlockingQueue<QueueTask<T>> mPendingJobs = new LinkedBlockingQueue();
    private final List<Thread> mWorkThreads = new ArrayList<Thread>();
    private final float mGrowthTriggerRation;
    private final int mMWorkforceIncrement;
    private final AtomicInteger mThreadId = new AtomicInteger(0);
    private final QueueThreadContext<T> mQueueThreadContext;
    private static final int MAX_WORKFORCE_SIZE = 20;

    public WorkQueue(@NonNull ILogger logger, @NonNull QueueThreadContext<T> queueThreadContext, @NonNull String queueName, int workforce, int growthTriggerRatio) {
        this.mLogger = logger;
        this.mName = queueName;
        this.mGrowthTriggerRation = growthTriggerRatio;
        this.mMWorkforceIncrement = workforce;
        this.mQueueThreadContext = queueThreadContext;
    }

    public void push(Job<T> job) throws InterruptedException {
        this._push(new QueueTask(QueueTask.ActionType.Normal, job));
        this.checkWorkforce();
    }

    private void _push(QueueTask<T> task) throws InterruptedException {
        this.mPendingJobs.put(task);
    }

    private synchronized void checkWorkforce() {
        if (this.mWorkThreads.isEmpty() || (float)(this.mPendingJobs.size() / this.mWorkThreads.size()) > this.mGrowthTriggerRation) {
            this.mLogger.verbose("Request to incrementing workforce from %1$d", new Object[]{this.mWorkThreads.size()});
            if (this.mWorkThreads.size() >= 20) {
                this.mLogger.verbose("Already at max workforce %1$d, denied.", new Object[]{20});
                return;
            }
            for (int i = 0; i < this.mMWorkforceIncrement; ++i) {
                Thread t = new Thread((Runnable)this, this.mName + "_" + this.mThreadId.incrementAndGet());
                t.setDaemon(true);
                this.mWorkThreads.add(t);
                t.start();
            }
            this.mLogger.verbose("thread-pool size=%1$d", new Object[]{this.mWorkThreads.size()});
        }
    }

    private synchronized void reduceWorkforce() throws InterruptedException {
        this.mLogger.verbose("Decrementing workforce from " + this.mWorkThreads.size(), new Object[0]);
        for (int i = 0; i < this.mMWorkforceIncrement; ++i) {
            this._push(new QueueTask(QueueTask.ActionType.Death, null));
        }
    }

    public synchronized void shutdown() throws InterruptedException {
        for (Thread t : this.mWorkThreads) {
            this._push(new QueueTask(QueueTask.ActionType.Death, null));
        }
        for (Thread t : this.mWorkThreads) {
            t.join();
        }
        this.mWorkThreads.clear();
        this.mQueueThreadContext.shutdown();
    }

    public String getName() {
        return this.mName;
    }

    public int size() {
        return this.mPendingJobs.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        threadName = Thread.currentThread().getName();
        try {
            try {
                this.mLogger.verbose("Creating a new working thread %1$s", new Object[]{threadName});
                this.mQueueThreadContext.creation(Thread.currentThread());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
lbl9:
            // 3 sources

            while (true) {
                queueTask = this.mPendingJobs.take();
                if (queueTask.actionType == QueueTask.ActionType.Death) {
                    this.mLogger.verbose("Thread(%1$s): Death requested", new Object[]{threadName});
                }
                ** GOTO lbl-1000
                break;
            }
        }
        catch (InterruptedException e) {
            this.mLogger.error((Throwable)e, "Thread(%1$s): Interrupted", new Object[]{threadName});
            try {
                this.mLogger.verbose("Thread(%1$s): destruction", new Object[]{threadName});
                this.mQueueThreadContext.destruction(Thread.currentThread());
                return;
            }
            catch (IOException e) {
                this.mLogger.error((Throwable)e, "Thread(%1$s): %2$s", new Object[]{threadName, e.getMessage()});
                return;
            }
            catch (InterruptedException e) {
                this.mLogger.error((Throwable)e, "Thread(%1$s): %2$s", new Object[]{threadName, e.getMessage()});
                return;
            }
        }
        catch (Throwable var6_15) {
            try {
                this.mLogger.verbose("Thread(%1$s): destruction", new Object[]{threadName});
                this.mQueueThreadContext.destruction(Thread.currentThread());
                throw var6_15;
            }
            catch (IOException e) {
                this.mLogger.error((Throwable)e, "Thread(%1$s): %2$s", new Object[]{threadName, e.getMessage()});
                throw var6_15;
            }
            catch (InterruptedException e) {
                this.mLogger.error((Throwable)e, "Thread(%1$s): %2$s", new Object[]{threadName, e.getMessage()});
            }
            throw var6_15;
        }
        try {
            this.mLogger.verbose("Thread(%1$s): destruction", new Object[]{threadName});
            this.mQueueThreadContext.destruction(Thread.currentThread());
            return;
        }
        catch (IOException e) {
            this.mLogger.error((Throwable)e, "Thread(%1$s): %2$s", new Object[]{threadName, e.getMessage()});
            return;
        }
        catch (InterruptedException e) {
            this.mLogger.error((Throwable)e, "Thread(%1$s): %2$s", new Object[]{threadName, e.getMessage()});
        }
        return;
lbl-1000:
        // 1 sources

        {
            job = queueTask.job;
            if (job != null) ** GOTO lbl-1000
            Logger.getAnonymousLogger().severe("I got a null pending job out of the priority queue");
        }
        try {
            this.mLogger.verbose("Thread(%1$s): destruction", new Object[]{threadName});
            this.mQueueThreadContext.destruction(Thread.currentThread());
            return;
        }
        catch (IOException e) {
            this.mLogger.error((Throwable)e, "Thread(%1$s): %2$s", new Object[]{threadName, e.getMessage()});
            return;
        }
        catch (InterruptedException e) {
            this.mLogger.error((Throwable)e, "Thread(%1$s): %2$s", new Object[]{threadName, e.getMessage()});
        }
        return;
lbl-1000:
        // 1 sources

        {
            this.mLogger.verbose("Thread(%1$s): scheduling %2$s", new Object[]{threadName, job.getJobTitle()});
            try {
                this.mQueueThreadContext.runTask(job);
            }
            catch (Exception e) {
                Logger.getAnonymousLogger().log(Level.WARNING, "Exception while processing task ", e);
                job.error();
                try {
                    this.mLogger.verbose("Thread(%1$s): destruction", new Object[]{threadName});
                    this.mQueueThreadContext.destruction(Thread.currentThread());
                    return;
                }
                catch (IOException e) {
                    this.mLogger.error((Throwable)e, "Thread(%1$s): %2$s", new Object[]{threadName, e.getMessage()});
                    return;
                }
                catch (InterruptedException e) {
                    this.mLogger.error((Throwable)e, "Thread(%1$s): %2$s", new Object[]{threadName, e.getMessage()});
                }
                return;
            }
        }
        {
            job.await();
            this.mLogger.verbose("Thread(%1$s): job %2$s finished", new Object[]{threadName, job.getJobTitle()});
            this.mLogger.verbose("Thread(%1$s): queue size %2$d", new Object[]{threadName, this.mPendingJobs.size()});
            ** continue;
        }
    }

    private static class QueueTask<T> {
        final ActionType actionType;
        final Job<T> job;

        private QueueTask(ActionType actionType, Job<T> job) {
            this.actionType = actionType;
            this.job = job;
        }

        static enum ActionType {
            Death,
            Normal;

        }
    }
}

