/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.testing;

import com.android.annotations.NonNull;
import com.android.builder.internal.InstallUtils;
import com.android.builder.internal.testing.CustomTestRunListener;
import com.android.builder.internal.testing.SimpleTestCallable;
import com.android.builder.testing.TestData;
import com.android.builder.testing.TestRunner;
import com.android.builder.testing.api.DeviceConnector;
import com.android.builder.testing.api.TestException;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.testrunner.TestIdentifier;
import com.android.ide.common.internal.WaitableExecutor;
import com.android.utils.ILogger;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;

public class SimpleTestRunner
implements TestRunner {
    File mAdbExec;

    public SimpleTestRunner(File adbExec) {
        this.mAdbExec = adbExec;
    }

    @Override
    public boolean runTests(@NonNull String projectName, @NonNull String variantName, @NonNull File testApk, @NonNull TestData testData, @NonNull List<? extends DeviceConnector> deviceList, int maxThreads, int timeout, @NonNull File resultsDir, @NonNull File coverageDir, @NonNull ILogger logger) throws TestException, TestRunner.NoAuthorizedDeviceFoundException, InterruptedException {
        int n;
        TestIdentifier fakeTest;
        CustomTestRunListener fakeRunListener;
        WaitableExecutor executor = new WaitableExecutor(maxThreads);
        int totalDevices = deviceList.size();
        int unAuthorizedDevices = 0;
        int compatibleDevices = 0;
        for (DeviceConnector deviceConnector : deviceList) {
            if (deviceConnector.getState() != IDevice.DeviceState.UNAUTHORIZED) {
                if (!InstallUtils.checkDeviceApiLevel(deviceConnector, testData.getMinSdkVersion(), logger, projectName, variantName)) continue;
                ImmutableList<File> testedApks = ImmutableList.of();
                if (!testData.isLibrary() && (testedApks = testData.getTestedApks(deviceConnector.getDensity(), deviceConnector.getLanguage(), deviceConnector.getRegion(), deviceConnector.getAbis())).isEmpty()) {
                    logger.info("Skipping device '%1$s' for '%2$s:%3$s': No matching output file", new Object[]{deviceConnector.getName(), projectName, variantName});
                    continue;
                }
                ++compatibleDevices;
                executor.execute((Callable)new SimpleTestCallable(deviceConnector, projectName, variantName, testApk, (List<File>)testedApks, this.mAdbExec, testData, resultsDir, coverageDir, timeout, logger));
                continue;
            }
            ++unAuthorizedDevices;
        }
        if (totalDevices == 0 || compatibleDevices == 0) {
            fakeRunListener = new CustomTestRunListener("TestRunner", projectName, variantName, logger);
            fakeRunListener.setReportDir(resultsDir);
            Map<String, String> map = Collections.emptyMap();
            fakeTest = new TestIdentifier(variantName, totalDevices == 0 ? "_FoundConnectedDevices" : "_FoundCompatibleDevices");
            fakeRunListener.testStarted(fakeTest);
            fakeRunListener.testFailed(fakeTest, "No tests found.");
            fakeRunListener.testEnded(fakeTest, map);
            fakeRunListener.testRunEnded(0L, map);
            return false;
        }
        if (unAuthorizedDevices > 0) {
            fakeRunListener = new CustomTestRunListener("TestRunner", projectName, variantName, logger);
            fakeRunListener.setReportDir(resultsDir);
            Map<String, String> map = Collections.emptyMap();
            fakeTest = new TestIdentifier(variantName, "_FoundUnauthorizedDevices");
            fakeRunListener.testStarted(fakeTest);
            fakeRunListener.testFailed(fakeTest, "No tests found.");
            fakeRunListener.testEnded(fakeTest, map);
            fakeRunListener.testRunEnded(0L, map);
        }
        List results = executor.waitForAllTasks();
        boolean bl = unAuthorizedDevices == 0;
        for (WaitableExecutor.TaskResult result : results) {
            if (result.value != null) {
                n &= ((Boolean)result.value).booleanValue();
                continue;
            }
            n = 0;
            logger.error(result.exception, null, new Object[0]);
        }
        return n != 0;
    }
}

