/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testing;

import com.android.builder.model.AndroidArtifact;
import com.android.builder.model.AndroidArtifactOutput;
import com.android.builder.model.BaseArtifact;
import com.android.ddmlib.IDevice;
import com.android.tools.idea.gradle.AndroidGradleModel;
import com.android.tools.idea.run.CloudConfiguration;
import com.android.tools.idea.run.CloudConfigurationProvider;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.idea.stats.UsageTracker;
import com.google.api.client.util.Maps;
import com.google.api.client.util.Sets;
import com.google.api.services.storage.Storage;
import com.google.api.services.storage.model.Buckets;
import com.google.api.services.storage.model.Objects;
import com.google.api.services.storage.model.StorageObject;
import com.google.api.services.testing.model.AndroidDevice;
import com.google.api.services.testing.model.Device;
import com.google.api.services.testing.model.TestMatrix;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.gct.testing.CloudConfigurationChooserDialog;
import com.google.gct.testing.CloudConfigurationImpl;
import com.google.gct.testing.CloudCustomPersistentConfigurations;
import com.google.gct.testing.CloudMatrixExecutionCancellator;
import com.google.gct.testing.CloudPersistentConfiguration;
import com.google.gct.testing.CloudPersistentState;
import com.google.gct.testing.CloudProjectChooserDialog;
import com.google.gct.testing.CloudResultsAdapter;
import com.google.gct.testing.CloudTestingUtils;
import com.google.gct.testing.ConfigurationInstance;
import com.google.gct.testing.GhostCloudDevice;
import com.google.gct.testing.config.GoogleCloudTestingDeveloperConfigurable;
import com.google.gct.testing.config.GoogleCloudTestingDeveloperSettings;
import com.google.gct.testing.dimension.ApiDimension;
import com.google.gct.testing.dimension.CloudTestingType;
import com.google.gct.testing.dimension.DeviceDimension;
import com.google.gct.testing.dimension.LanguageDimension;
import com.google.gct.testing.dimension.OrientationDimension;
import com.google.gct.testing.launcher.CloudAuthenticator;
import com.google.gct.testing.launcher.CloudTestsLauncher;
import com.google.gct.testing.results.GoogleCloudTestListener;
import com.google.gct.testing.results.GoogleCloudTestResultsConnectionUtil;
import com.google.gct.testing.results.GoogleCloudTestingResultParser;
import com.google.gct.testing.util.CloudTestingTracking;
import com.google.gct.testing.vnc.BlankVncViewer;
import com.google.gct.testing.vnc.BlankVncViewerCallback;
import com.google.gct.testing.vnc.VncKeepAliveThreadImpl;
import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.ui.BaseTestsOutputConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.KeyPair;
import com.jcraft.jsch.Session;
import icons.AndroidIcons;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.run.AndroidRunningState;
import org.jetbrains.android.run.testing.AndroidTestConsoleProperties;
import org.jetbrains.android.run.testing.AndroidTestRunConfiguration;

public class CloudConfigurationProviderImpl
extends CloudConfigurationProvider {
    private static final String TEST_RUN_ID_PREFIX = "GoogleCloudTest:";
    private static final Map<String, CloudConfigurationImpl> testRunIdToCloudConfiguration = new HashMap<String, CloudConfigurationImpl>();
    private static final Map<String, CloudResultsAdapter> testRunIdToCloudResultsAdapter = new HashMap<String, CloudResultsAdapter>();
    private static final Map<String, String> serialNumberToConfigurationInstance = Maps.newHashMap();
    public static final Icon DEFAULT_ICON = AndroidIcons.AndroidFile;
    public static final Function<CloudConfiguration, CloudConfigurationImpl> CLONE_CONFIGURATIONS = new Function<CloudConfiguration, CloudConfigurationImpl>(){

        public CloudConfigurationImpl apply(CloudConfiguration configuration) {
            return ((CloudConfigurationImpl)configuration).clone();
        }
    };
    public static final Function<CloudConfiguration, CloudConfigurationImpl> CAST_CONFIGURATIONS = new Function<CloudConfiguration, CloudConfigurationImpl>(){

        public CloudConfigurationImpl apply(CloudConfiguration configuration) {
            return (CloudConfigurationImpl)configuration;
        }
    };
    private static volatile String lastCloudProjectId;
    private static final Set<GhostCloudDevice> ghostCloudDevices;
    private static CloudConfigurationProviderImpl instance;

    public static Map<String, List<? extends CloudTestingType>> getAllDimensionTypes() {
        HashMap<String, List<? extends CloudTestingType>> dimensionTypes = new HashMap<String, List<? extends CloudTestingType>>();
        dimensionTypes.put("Device", DeviceDimension.getFullDomain());
        dimensionTypes.put("Platform", ApiDimension.getFullDomain());
        dimensionTypes.put("Locale", LanguageDimension.getFullDomain());
        dimensionTypes.put("Orientation", OrientationDimension.getFullDomain());
        return dimensionTypes;
    }

    public static CloudConfigurationProviderImpl getInstance() {
        if (instance == null) {
            instance = new CloudConfigurationProviderImpl();
        }
        return instance;
    }

    public List<? extends CloudConfiguration> getCloudConfigurations(AndroidFacet facet, final CloudConfiguration.Kind configurationKind) {
        try {
            CloudAuthenticator.prepareCredential();
        }
        catch (Exception e) {
            return Lists.newArrayList();
        }
        ArrayList cloudPersistentConfigurations = Lists.newArrayList((Iterable)Iterables.filter(CloudCustomPersistentConfigurations.getInstance((Module)facet.getModule()).getState().myCloudPersistentConfigurations, (Predicate)new Predicate<CloudPersistentConfiguration>(){

            public boolean apply(CloudPersistentConfiguration configuration) {
                return configuration != null && configuration.kind == configurationKind;
            }
        }));
        return Lists.newArrayList((Iterable)Iterables.concat(CloudConfigurationProviderImpl.deserializeConfigurations(cloudPersistentConfigurations, true, facet), this.getDefaultConfigurations(facet, configurationKind)));
    }

    private List<? extends CloudConfiguration> getDefaultConfigurations(AndroidFacet facet, CloudConfiguration.Kind kind) {
        if (kind == CloudConfiguration.Kind.SINGLE_DEVICE) {
            CloudConfigurationImpl defaultConfiguration = new CloudConfigurationImpl(0x7FFFFFFE, "", CloudConfiguration.Kind.SINGLE_DEVICE, AndroidIcons.Display, facet);
            defaultConfiguration.apiDimension.enableDefault();
            ImmutableList<CloudTestingType> enabledApis = defaultConfiguration.apiDimension.getEnabledTypes();
            if (enabledApis.isEmpty()) {
                return ImmutableList.of();
            }
            defaultConfiguration.deviceDimension.enableDefault(((CloudTestingType)enabledApis.get(0)).getId());
            defaultConfiguration.languageDimension.enableDefault();
            defaultConfiguration.orientationDimension.enableDefault();
            ImmutableList<CloudTestingType> enabledDevices = defaultConfiguration.deviceDimension.getEnabledTypes();
            if (enabledDevices.isEmpty() || defaultConfiguration.languageDimension.getEnabledTypes().isEmpty() || defaultConfiguration.orientationDimension.getEnabledTypes().isEmpty()) {
                return ImmutableList.of();
            }
            defaultConfiguration.setName(((CloudTestingType)enabledDevices.get(0)).getConfigurationDialogDisplayName() + " API " + ((CloudTestingType)enabledApis.get(0)).getId());
            defaultConfiguration.setNonEditable();
            return ImmutableList.of((Object)((Object)defaultConfiguration));
        }
        CloudConfigurationImpl defaultConfiguration = new CloudConfigurationImpl(Integer.MAX_VALUE, "Sample configuration", CloudConfiguration.Kind.MATRIX, AndroidIcons.Display, facet);
        defaultConfiguration.deviceDimension.enable(DeviceDimension.getFullDomain(), Arrays.asList("Nexus6", "hammerhead", "mako"));
        defaultConfiguration.apiDimension.enable(ApiDimension.getFullDomain(), Arrays.asList("19", "21", "22", "23"));
        ImmutableList<CloudTestingType> enabledApis = defaultConfiguration.apiDimension.getEnabledTypes();
        if (enabledApis.size() > 3) {
            for (CloudTestingType enabledApi : enabledApis) {
                if (!enabledApi.getId().equals("19")) continue;
                defaultConfiguration.apiDimension.disable(enabledApi);
                break;
            }
        }
        defaultConfiguration.languageDimension.enableDefault();
        defaultConfiguration.orientationDimension.enableAll();
        defaultConfiguration.setNonEditable();
        return ImmutableList.of((Object)((Object)defaultConfiguration));
    }

    public List<? extends CloudConfiguration> getAllCloudConfigurations(AndroidFacet facet) {
        try {
            CloudAuthenticator.prepareCredential();
        }
        catch (Exception e) {
            return Lists.newArrayList();
        }
        List<CloudPersistentConfiguration> cloudPersistentConfigurations = CloudCustomPersistentConfigurations.getInstance((Module)facet.getModule()).getState().myCloudPersistentConfigurations;
        return Lists.newArrayList((Iterable)Iterables.concat(CloudConfigurationProviderImpl.deserializeConfigurations(cloudPersistentConfigurations, true, facet), this.getDefaultConfigurations(facet, CloudConfiguration.Kind.MATRIX), this.getDefaultConfigurations(facet, CloudConfiguration.Kind.SINGLE_DEVICE)));
    }

    public CloudConfiguration openMatrixConfigurationDialog(AndroidFacet currentFacet, CloudConfiguration selectedConfiguration, CloudConfiguration.Kind configurationKind) {
        final CloudConfiguration.Kind selectedConfigurationKind = selectedConfiguration == null ? configurationKind : ((CloudConfigurationImpl)selectedConfiguration).getKind();
        Module currentModule = currentFacet.getModule();
        List<? extends CloudConfiguration> testingConfigurations = this.getCloudConfigurations(currentFacet, selectedConfigurationKind);
        ArrayList castDefaultConfigurations = Lists.newArrayList((Iterable)Iterables.transform((Iterable)Iterables.filter(testingConfigurations, (Predicate)new Predicate<CloudConfiguration>(){

            public boolean apply(CloudConfiguration testingConfiguration) {
                return !testingConfiguration.isEditable();
            }
        }), CAST_CONFIGURATIONS));
        ArrayList copyCustomConfigurations = Lists.newArrayList((Iterable)Iterables.transform((Iterable)Iterables.filter(testingConfigurations, (Predicate)new Predicate<CloudConfiguration>(){

            public boolean apply(CloudConfiguration testingConfiguration) {
                return testingConfiguration.isEditable();
            }
        }), CLONE_CONFIGURATIONS));
        CloudConfigurationChooserDialog dialog = new CloudConfigurationChooserDialog(currentModule, copyCustomConfigurations, castDefaultConfigurations, (CloudConfigurationImpl)selectedConfiguration, selectedConfigurationKind);
        dialog.show();
        if (dialog.isOK()) {
            CloudCustomPersistentConfigurations persistentConfigurations = CloudCustomPersistentConfigurations.getInstance(currentModule);
            CloudPersistentState customState = persistentConfigurations.getState();
            customState.myCloudPersistentConfigurations = Lists.newArrayList((Iterable)Iterables.filter(customState.myCloudPersistentConfigurations, (Predicate)new Predicate<CloudPersistentConfiguration>(){

                public boolean apply(CloudPersistentConfiguration configuration) {
                    return configuration != null && configuration.kind != selectedConfigurationKind;
                }
            }));
            customState.myCloudPersistentConfigurations.addAll(Lists.newArrayList((Iterable)Iterables.transform((Iterable)copyCustomConfigurations, (Function)new Function<CloudConfigurationImpl, CloudPersistentConfiguration>(){

                public CloudPersistentConfiguration apply(CloudConfigurationImpl configuration) {
                    return configuration.getPersistentConfiguration();
                }
            })));
            persistentConfigurations.loadState(customState);
            return dialog.getSelectedConfiguration();
        }
        return null;
    }

    public String openCloudProjectConfigurationDialog(Project project, String projectId) {
        CloudProjectChooserDialog dialog = new CloudProjectChooserDialog(project, projectId);
        dialog.show();
        if (dialog.isOK()) {
            return dialog.getSelectedProject();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean validateCloudProject(Project project, String cloudProjectId) {
        block9: {
            Buckets buckets = null;
            String message = null;
            try {
                buckets = (Buckets)CloudAuthenticator.getStorage().buckets().list(cloudProjectId).execute();
            }
            catch (Exception e) {
                message = e.getMessage();
                return (boolean)message;
            }
            finally {
                if (buckets != null) break block9;
                CloudTestingUtils.showErrorMessage(project, "Cloud test configuration is invalid", "Failed to authorize to Google Cloud project! Please select a project you are authorized to use.\nException while performing a pre-trigger sanity check\n\n" + message);
                return false;
            }
        }
        String checkBucketName = CloudConfigurationProviderImpl.generateUniqueBucketName("check-billing");
        try {
            CloudTestsLauncher.createBucket(cloudProjectId, checkBucketName);
        }
        catch (Exception e) {
            CloudTestingUtils.showErrorMessage(project, "Cloud test configuration is invalid", "Please enable billing in your Google Cloud project.\nException while performing a pre-trigger sanity check\n\n" + e.getMessage());
            return false;
        }
        try {
            CloudAuthenticator.getStorage().buckets().delete(checkBucketName).execute();
        }
        catch (Exception e) {
            // empty catch block
        }
        return true;
    }

    public void launchCloudDevice(int selectedConfigurationId, String cloudProjectId, AndroidFacet facet) {
        UsageTracker.getInstance().trackEvent("com.google.cloud.testing", "launch.cloud.device", CloudTestingTracking.SESSION_LABEL, null);
        CloudConfigurationImpl cloudConfiguration = CloudTestingUtils.getConfigurationById(selectedConfigurationId, facet);
        if (cloudConfiguration.getKind() != CloudConfiguration.Kind.SINGLE_DEVICE) {
            return;
        }
        lastCloudProjectId = cloudProjectId;
        String configurationInstance = cloudConfiguration.computeConfigurationInstances("-").get(0);
        this.launchCloudDevice(configurationInstance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void launchCloudDevice(String configurationInstance) {
        String publicKey;
        if (!CloudTestingUtils.checkJavaVersion()) {
            return;
        }
        JSch jsch = new JSch();
        try {
            publicKey = this.generateSshKeys(jsch);
        }
        catch (Exception e) {
            CloudTestingUtils.showErrorMessage(null, "Error launching a cloud device", "Failed to launch a cloud device!\nException while generating ssh keys\n\n" + e.getMessage());
            return;
        }
        final String cloudProjectId = lastCloudProjectId;
        String[] dimensionValues = configurationInstance.split("-");
        Device device = new Device().setAndroidDevice(new AndroidDevice().setAndroidModelId(dimensionValues[0]).setAndroidVersionId(dimensionValues[1]).setLocale(dimensionValues[2]).setOrientation(dimensionValues[3]));
        Device createdDevice = null;
        try {
            createdDevice = (Device)CloudAuthenticator.getTest().projects().devices().create(cloudProjectId, device).setSshPublicKey(publicKey).execute();
        }
        catch (Exception e) {
            CloudTestingUtils.showErrorMessage(null, "Error launching a cloud device", "Failed to launch a cloud device!\nException while launching a cloud device\n\n" + e.getMessage());
            return;
        }
        if (createdDevice == null) {
            CloudTestingUtils.showErrorMessage(null, "Error launching a cloud device", "Failed to launch a cloud device!\nCould not access cloud device\n\n");
        }
        final String deviceId = createdDevice.getId();
        final GhostCloudDevice ghostCloudDevice = new GhostCloudDevice(createdDevice);
        Set<GhostCloudDevice> set = ghostCloudDevices;
        synchronized (set) {
            ghostCloudDevices.add(ghostCloudDevice);
        }
        String configurationName = ConfigurationInstance.parseFromEncodedString(ghostCloudDevice.getEncodedConfigurationInstance()).getResultsViewerDisplayString();
        BlankVncViewer blankVncViewer = BlankVncViewer.showBlankVncViewer(configurationName, new BlankVncViewerCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void viewerClosed() {
                try {
                    CloudAuthenticator.getTest().projects().devices().delete(cloudProjectId, deviceId).execute();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                Set set = ghostCloudDevices;
                synchronized (set) {
                    ghostCloudDevices.remove(ghostCloudDevice);
                }
            }
        });
        long POLLING_INTERVAL = 10000L;
        long INITIAL_TIMEOUT = 600000L;
        long stopTime = System.currentTimeMillis() + 600000L;
        String sdkPath = IdeSdks.getAndroidSdkPath().getAbsolutePath() + "/platform-tools";
        File workingDir = new File(sdkPath);
        try {
            while (System.currentTimeMillis() < stopTime) {
                Set<GhostCloudDevice> set2 = ghostCloudDevices;
                synchronized (set2) {
                    if (!ghostCloudDevices.contains(ghostCloudDevice)) {
                        return;
                    }
                }
                createdDevice = (Device)CloudAuthenticator.getTest().projects().devices().get(cloudProjectId, deviceId).execute();
                System.out.println("Polling for device... (time: " + System.currentTimeMillis() + ", status: " + createdDevice.getState() + ")");
                if (createdDevice.getState().equals("DEVICE_ERROR")) {
                    CloudTestingUtils.showErrorMessage(null, "Error launching a cloud device", "Failed to launch a cloud device!\nThe polled cloud device has ERROR state\n\n");
                    return;
                }
                if (createdDevice.getState().equals("READY")) {
                    int vncLocalPort;
                    int adbLocalPort;
                    Session session;
                    String ipAddress = createdDevice.getDeviceDetails().getConnectionInfo().getIpAddress();
                    Integer adbPort = createdDevice.getDeviceDetails().getConnectionInfo().getAdbPort();
                    Integer vncPort = createdDevice.getDeviceDetails().getConnectionInfo().getVncPort();
                    Integer sshPort = createdDevice.getDeviceDetails().getConnectionInfo().getSshPort();
                    String vncPassword = createdDevice.getDeviceDetails().getConnectionInfo().getVncPassword();
                    try {
                        session = this.connectSession(jsch, ipAddress, sshPort);
                    }
                    catch (Exception e) {
                        CloudTestingUtils.showErrorMessage(null, "Error launching a cloud device", "Failed to launch a cloud device!\nException while connecting through SSH\n\n" + e.getMessage());
                        Set<GhostCloudDevice> set3 = ghostCloudDevices;
                        synchronized (set3) {
                            ghostCloudDevices.remove(ghostCloudDevice);
                            return;
                        }
                    }
                    try {
                        adbLocalPort = session.setPortForwardingL(0, "localhost", adbPort.intValue());
                    }
                    catch (Exception e) {
                        CloudTestingUtils.showErrorMessage(null, "Error launching a cloud device", "Failed to launch a cloud device!\nException while tunneling through SSH\n\n" + e.getMessage());
                        Set<GhostCloudDevice> set4 = ghostCloudDevices;
                        synchronized (set4) {
                            ghostCloudDevices.remove(ghostCloudDevice);
                            return;
                        }
                    }
                    try {
                        vncLocalPort = session.setPortForwardingL(0, "localhost", vncPort.intValue());
                    }
                    catch (Exception e) {
                        CloudTestingUtils.showErrorMessage(null, "Error launching a cloud device", "Failed to launch a cloud device!\nException while tunneling through SSH\n\n" + e.getMessage());
                        Set<GhostCloudDevice> set5 = ghostCloudDevices;
                        synchronized (set5) {
                            ghostCloudDevices.remove(ghostCloudDevice);
                            return;
                        }
                    }
                    String deviceAddress = "localhost:" + adbLocalPort;
                    System.out.println("Device ready with IP address:port " + deviceAddress);
                    Runtime rt = Runtime.getRuntime();
                    Process connect = rt.exec("./adb connect " + deviceAddress, null, workingDir);
                    connect.waitFor();
                    serialNumberToConfigurationInstance.put(deviceAddress, configurationInstance);
                    Set<GhostCloudDevice> set6 = ghostCloudDevices;
                    synchronized (set6) {
                        ghostCloudDevices.remove(ghostCloudDevice);
                    }
                    try {
                        blankVncViewer.closeWindow();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    Process unlock = rt.exec("./adb -s " + deviceAddress + " wait-for-device shell input keyevent 82", null, workingDir);
                    unlock.waitFor();
                    String[] viewerArgs = new String[]{"-port=" + vncLocalPort, "-host=localhost", "-password=" + vncPassword, "-fullScreen=false"};
                    VncKeepAliveThreadImpl.startVnc(viewerArgs, configurationName, cloudProjectId, deviceId, deviceAddress, workingDir);
                    return;
                }
                Thread.sleep(10000L);
            }
            CloudTestingUtils.showErrorMessage(null, "Timed out connecting to a cloud device", "Timed out connecting to a cloud device!\nTimed out connecting to a cloud device:\n\n" + deviceId);
            return;
        }
        catch (IOException e) {
            this.showCloudDevicePollingError(e, deviceId);
            return;
        }
        catch (InterruptedException e) {
            this.showCloudDevicePollingError(e, deviceId);
            return;
        }
        finally {
            Set<GhostCloudDevice> e = ghostCloudDevices;
            synchronized (e) {
                ghostCloudDevices.remove(ghostCloudDevice);
            }
        }
    }

    public static String getConfigurationInstanceForSerialNumber(String serialNumber) {
        return serialNumberToConfigurationInstance.get(serialNumber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<IDevice> getLaunchingCloudDevices() {
        Set<GhostCloudDevice> set = ghostCloudDevices;
        synchronized (set) {
            HashSet launchingCloudDevices = Sets.newHashSet();
            launchingCloudDevices.addAll(ghostCloudDevices);
            return launchingCloudDevices;
        }
    }

    public Icon getCloudDeviceIcon() {
        return CloudTestingUtils.CLOUD_DEVICE_ICON;
    }

    public String getCloudDeviceConfiguration(IDevice device) {
        String encodedConfigurationInstance;
        String string = encodedConfigurationInstance = device instanceof GhostCloudDevice ? ((GhostCloudDevice)device).getEncodedConfigurationInstance() : serialNumberToConfigurationInstance.get(device.getSerialNumber());
        if (encodedConfigurationInstance != null) {
            return ConfigurationInstance.parseFromEncodedString(encodedConfigurationInstance).getResultsViewerDisplayString();
        }
        return null;
    }

    private void showCloudDevicePollingError(Exception e, String deviceId) {
        CloudTestingUtils.showErrorMessage(null, "Error polling for a cloud device", "Failed to connect to a cloud device!\nException while polling for a cloud device\n\n" + deviceId + e.getMessage());
    }

    public ExecutionResult executeCloudMatrixTests(int selectedConfigurationId, String cloudProjectId, AndroidRunningState runningState, Executor executor) throws ExecutionException {
        UsageTracker.getInstance().trackEvent("com.google.cloud.testing", "run.test.matrix", CloudTestingTracking.SESSION_LABEL, null);
        Project project = runningState.getFacet().getModule().getProject();
        if (!CloudConfigurationProviderImpl.validateCloudProject(project, cloudProjectId)) {
            return null;
        }
        CloudConfigurationImpl cloudConfiguration = CloudTestingUtils.getConfigurationById(selectedConfigurationId, runningState.getFacet());
        if (cloudConfiguration.getKind() != CloudConfiguration.Kind.MATRIX) {
            return null;
        }
        lastCloudProjectId = cloudProjectId;
        AndroidTestRunConfiguration testRunConfiguration = (AndroidTestRunConfiguration)runningState.getConfiguration();
        AndroidTestConsoleProperties properties = new AndroidTestConsoleProperties(testRunConfiguration, executor);
        CloudMatrixExecutionCancellator matrixExecutionCancellator = new CloudMatrixExecutionCancellator();
        BaseTestsOutputConsoleView console = GoogleCloudTestResultsConnectionUtil.createAndAttachConsole("Cloud Testing", runningState.getProcessHandler(), (TestConsoleProperties)properties, runningState.getEnvironment(), matrixExecutionCancellator);
        Disposer.register((Disposable)project, (Disposable)console);
        GoogleCloudTestingResultParser cloudResultParser = new GoogleCloudTestingResultParser("Cloud Test Run", new GoogleCloudTestListener(runningState));
        List<String> expectedConfigurationInstances = cloudConfiguration.computeConfigurationInstances(" | ");
        for (String configurationInstance : expectedConfigurationInstances) {
            cloudResultParser.getTestRunListener().testConfigurationScheduled(configurationInstance);
        }
        GoogleCloudTestingDeveloperConfigurable.GoogleCloudTestingDeveloperState googleCloudTestingDeveloperState = GoogleCloudTestingDeveloperSettings.getInstance(project).getState();
        if (!googleCloudTestingDeveloperState.shouldUseFakeBucket) {
            this.performTestsInCloud(cloudConfiguration, cloudProjectId, runningState, cloudResultParser, matrixExecutionCancellator);
        } else {
            String testRunId = TEST_RUN_ID_PREFIX + googleCloudTestingDeveloperState.fakeBucketName + System.currentTimeMillis();
            CloudResultsAdapter cloudResultsAdapter = new CloudResultsAdapter(cloudProjectId, googleCloudTestingDeveloperState.fakeBucketName, runningState.getProcessHandler(), cloudResultParser, expectedConfigurationInstances, testRunId, null, null);
            CloudConfigurationProviderImpl.addCloudConfiguration(testRunId, cloudConfiguration);
            CloudConfigurationProviderImpl.addCloudResultsAdapter(testRunId, cloudResultsAdapter);
            cloudResultsAdapter.startPolling();
        }
        return new DefaultExecutionResult((ExecutionConsole)console, runningState.getProcessHandler());
    }

    protected boolean canBeEnabled() {
        String publicBucketName = "cloud-testing-plugin-enablement";
        String triggerFileName = "ENABLED";
        try {
            Storage.Objects.List objects = CloudAuthenticator.getPublicStorage().objects().list("cloud-testing-plugin-enablement");
            List storageObjects = ((Objects)objects.execute()).getItems();
            if (storageObjects != null) {
                for (StorageObject storageObject : storageObjects) {
                    if (!"ENABLED".equals(storageObject.getName())) continue;
                    return true;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private void performTestsInCloud(final CloudConfigurationImpl cloudTestingConfiguration, final String cloudProjectId, final AndroidRunningState runningState, final GoogleCloudTestingResultParser cloudResultParser, final CloudMatrixExecutionCancellator matrixExecutionCancellator) {
        if (cloudTestingConfiguration != null && cloudTestingConfiguration.getDeviceConfigurationCount() > 0) {
            final List<String> expectedConfigurationInstances = cloudTestingConfiguration.computeConfigurationInstances(" | ");
            new Thread(new Runnable(){

                @Override
                public void run() {
                    AndroidTestRunConfiguration testRunConfiguration = (AndroidTestRunConfiguration)runningState.getConfiguration();
                    String moduleName = runningState.getFacet().getModule().getName();
                    String bucketName = CloudConfigurationProviderImpl.generateUniqueBucketName(moduleName);
                    String appPackage = runningState.getFacet().getAndroidModuleInfo().getPackage();
                    String testPackage = appPackage + ".test";
                    if (matrixExecutionCancellator.isCancelled()) {
                        return;
                    }
                    runningState.getProcessHandler().notifyTextAvailable(this.prepareProgressString("Creating Cloud Storage Bucket " + bucketName + " ...", ""), ProcessOutputTypes.STDOUT);
                    CloudTestsLauncher.createBucket(cloudProjectId, bucketName);
                    if (matrixExecutionCancellator.isCancelled()) {
                        return;
                    }
                    AndroidGradleModel androidModel = AndroidGradleModel.get((AndroidFacet)runningState.getFacet());
                    if (androidModel == null) {
                        CloudTestingUtils.showErrorMessage(runningState.getFacet().getModule().getProject(), "Error uploading APKs", "Your project is not an idea android project!\n");
                        return;
                    }
                    AndroidArtifact mainArtifact = androidModel.getSelectedVariant().getMainArtifact();
                    ArrayList mainOutputs = Lists.newArrayList((Iterable)mainArtifact.getOutputs());
                    if (mainOutputs.isEmpty()) {
                        CloudTestingUtils.showErrorMessage(runningState.getFacet().getModule().getProject(), "Error finding app APK", "Could not find your app APK!\n");
                        return;
                    }
                    File appApk = ((AndroidArtifactOutput)mainOutputs.get(0)).getMainOutputFile().getOutputFile();
                    BaseArtifact testArtifactInfo = androidModel.findSelectedTestArtifactInSelectedVariant();
                    if (!(testArtifactInfo instanceof AndroidArtifact)) {
                        CloudTestingUtils.showErrorMessage(runningState.getFacet().getModule().getProject(), "Error uploading APKs", "Your test artifact is not an android artifact!\n");
                        return;
                    }
                    ArrayList testOutputs = Lists.newArrayList((Iterable)((AndroidArtifact)testArtifactInfo).getOutputs());
                    if (testOutputs.isEmpty()) {
                        CloudTestingUtils.showErrorMessage(runningState.getFacet().getModule().getProject(), "Error finding test APK", "Could not find your test APK!\n");
                        return;
                    }
                    File testApk = ((AndroidArtifactOutput)testOutputs.get(0)).getMainOutputFile().getOutputFile();
                    runningState.getProcessHandler().notifyTextAvailable(this.prepareProgressString("Uploading app APK ...", ""), ProcessOutputTypes.STDOUT);
                    String appApkName = CloudTestsLauncher.uploadFile(bucketName, appApk).getName();
                    if (matrixExecutionCancellator.isCancelled()) {
                        return;
                    }
                    runningState.getProcessHandler().notifyTextAvailable(this.prepareProgressString("Uploading test APK ...", ""), ProcessOutputTypes.STDOUT);
                    String testApkName = CloudTestsLauncher.uploadFile(bucketName, testApk).getName();
                    if (matrixExecutionCancellator.isCancelled()) {
                        return;
                    }
                    runningState.getProcessHandler().notifyTextAvailable(this.prepareProgressString("Submitting tests to Cloud Test Lab ...", ""), ProcessOutputTypes.STDOUT);
                    String testSpecification = CloudTestingUtils.prepareTestSpecification(testRunConfiguration);
                    TestMatrix testMatrix = CloudTestsLauncher.triggerTestApi(cloudProjectId, CloudConfigurationProviderImpl.this.getBucketGcsPath(bucketName), CloudConfigurationProviderImpl.this.getApkGcsPath(bucketName, appApkName), CloudConfigurationProviderImpl.this.getApkGcsPath(bucketName, testApkName), testSpecification, testRunConfiguration.INSTRUMENTATION_RUNNER_CLASS, cloudTestingConfiguration, appPackage, testPackage);
                    if (testMatrix != null) {
                        runningState.getProcessHandler().notifyTextAvailable(this.prepareProgressString("Validating APKs ...", "\n\n"), ProcessOutputTypes.STDOUT);
                        matrixExecutionCancellator.setCloudProjectId(cloudProjectId);
                        matrixExecutionCancellator.setTestMatrixId(testMatrix.getTestMatrixId());
                        String testRunId = CloudConfigurationProviderImpl.TEST_RUN_ID_PREFIX + bucketName;
                        CloudResultsAdapter cloudResultsAdapter = new CloudResultsAdapter(cloudProjectId, bucketName, runningState.getProcessHandler(), cloudResultParser, expectedConfigurationInstances, testRunId, testMatrix, matrixExecutionCancellator);
                        CloudConfigurationProviderImpl.addCloudConfiguration(testRunId, cloudTestingConfiguration);
                        CloudConfigurationProviderImpl.addCloudResultsAdapter(testRunId, cloudResultsAdapter);
                        cloudResultsAdapter.startPolling();
                    }
                }

                private String prepareProgressString(String progressMessage, String suffix) {
                    return CloudTestingUtils.shouldShowProgressTimestamps() ? progressMessage + "\t" + System.currentTimeMillis() + "\n" + suffix : progressMessage + "\n" + suffix;
                }
            }).start();
        }
    }

    private static String generateUniqueBucketName(String moduleName) {
        String characters = "abcdefghijklmnopqrstuvwxyz";
        int suffixLength = 4;
        Random randomGenerator = new Random();
        StringBuilder suffix = new StringBuilder(4);
        for (int i = 0; i < 4; ++i) {
            suffix.append("abcdefghijklmnopqrstuvwxyz".charAt(randomGenerator.nextInt("abcdefghijklmnopqrstuvwxyz".length())));
        }
        return "as-build_" + moduleName.toLowerCase() + "_" + System.currentTimeMillis() + "_" + suffix;
    }

    private void addPathIfExists(List<String> apkPaths, String apkPath) {
        if (new File(apkPath).exists()) {
            apkPaths.add(apkPath);
        }
    }

    private String getBucketGcsPath(String bucketName) {
        return "gs://" + bucketName;
    }

    private String getApkGcsPath(String bucketName, String apkName) {
        return "gs://" + bucketName + "/" + apkName;
    }

    private static void addCloudResultsAdapter(String testRunId, CloudResultsAdapter cloudResultsAdapter) {
        if (testRunIdToCloudResultsAdapter.get(testRunId) != null) {
            throw new IllegalStateException("Cannot add more than one cloud results adapter for test run id: " + testRunId);
        }
        testRunIdToCloudResultsAdapter.put(testRunId, cloudResultsAdapter);
    }

    private static void addCloudConfiguration(String testRunId, CloudConfigurationImpl cloudConfiguration) {
        if (testRunIdToCloudConfiguration.get(testRunId) != null) {
            throw new IllegalStateException("Cannot add more than one cloud configuration for test run id: " + testRunId);
        }
        testRunIdToCloudConfiguration.put(testRunId, cloudConfiguration);
    }

    public static CloudConfigurationImpl getSelectedCloudConfiguration(String testRunId) {
        return testRunIdToCloudConfiguration.get(testRunId);
    }

    public static CloudResultsAdapter getCloudResultsAdapter(String testRunId) {
        return testRunIdToCloudResultsAdapter.get(testRunId);
    }

    public static List<CloudConfigurationImpl> deserializeConfigurations(List<CloudPersistentConfiguration> persistentConfigurations, boolean isEditable, AndroidFacet facet) {
        LinkedList<CloudConfigurationImpl> googleCloudTestingConfigurations = new LinkedList<CloudConfigurationImpl>();
        for (CloudPersistentConfiguration persistentConfiguration : persistentConfigurations) {
            Icon icon = CloudConfigurationProviderImpl.getIcon(persistentConfiguration.name, isEditable);
            CloudConfigurationImpl configuration = new CloudConfigurationImpl(persistentConfiguration.id, persistentConfiguration.name, persistentConfiguration.kind, icon, facet);
            configuration.deviceDimension.enable(DeviceDimension.getFullDomain(), persistentConfiguration.devices);
            configuration.apiDimension.enable(ApiDimension.getFullDomain(), persistentConfiguration.apiLevels);
            configuration.languageDimension.enable(LanguageDimension.getFullDomain(), persistentConfiguration.languages);
            configuration.orientationDimension.enable(OrientationDimension.getFullDomain(), persistentConfiguration.orientations);
            if (!isEditable) {
                configuration.setNonEditable();
            }
            googleCloudTestingConfigurations.add(configuration);
        }
        return googleCloudTestingConfigurations;
    }

    private static Icon getIcon(String configurationName, boolean isEditable) {
        if (isEditable) {
            return AndroidIcons.AndroidFile;
        }
        if (configurationName.equals("All Available")) {
            return AndroidIcons.Display;
        }
        return AndroidIcons.Portrait;
    }

    private String generateSshKeys(JSch jsch) throws JSchException {
        KeyPair keyPair = KeyPair.genKeyPair((JSch)jsch, (int)2, (int)2048);
        String comment = System.getProperty("user.home");
        if (comment == null) {
            comment = "";
        } else {
            try {
                comment = comment + InetAddress.getLocalHost().getHostName();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        ByteArrayOutputStream privateKeyArray = new ByteArrayOutputStream();
        keyPair.writePrivateKey((OutputStream)privateKeyArray);
        ByteArrayOutputStream publicKeyArray = new ByteArrayOutputStream();
        keyPair.writePublicKey((OutputStream)publicKeyArray, comment);
        jsch.addIdentity("root", privateKeyArray.toByteArray(), publicKeyArray.toByteArray(), null);
        keyPair.dispose();
        return "root:" + new String(publicKeyArray.toByteArray());
    }

    private Session connectSession(JSch jsch, String rhost, int sshPort) throws Exception {
        Session session = jsch.getSession("root", rhost, sshPort);
        Properties config = new Properties();
        config.put("StrictHostKeyChecking", "no");
        session.setConfig(config);
        session.setTimeout(30000);
        try {
            session.connect();
        }
        catch (JSchException e) {
            throw new RuntimeException(String.format("%s@%s:%d: Error connecting to session.", "root", rhost, sshPort), e);
        }
        return session;
    }

    static {
        ghostCloudDevices = Sets.newHashSet();
        instance = null;
    }
}

