/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testing.config;

import com.google.gct.testing.config.GsutilConfigurable;
import com.google.gct.testing.config.GsutilSettings;
import com.intellij.execution.ExecutableValidator;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.CharsetToolkit;

public class GsutilExecutableValidator
extends ExecutableValidator {
    private final Project project;
    private final GsutilConfigurable gsutilConfigurable;

    public GsutilExecutableValidator(Project project, GsutilConfigurable gsutilConfigurable) {
        super(project, "Can't start GSUtil! ", "Looks like the path to gsutil executable is not valid.");
        this.project = project;
        this.gsutilConfigurable = gsutilConfigurable;
    }

    protected String getCurrentExecutable() {
        return GsutilSettings.getGsutilExecutable(this.project);
    }

    protected String getConfigurableDisplayName() {
        return this.gsutilConfigurable.getDisplayName();
    }

    public boolean isExecutableValid(String executable) {
        try {
            GeneralCommandLine commandLine = new GeneralCommandLine();
            commandLine.setExePath(executable);
            CapturingProcessHandler handler = new CapturingProcessHandler(commandLine.createProcess(), CharsetToolkit.getDefaultSystemCharset());
            ProcessOutput result = handler.runProcess(60000);
            return !result.isTimeout() && result.getExitCode() == 0;
        }
        catch (Throwable ignored) {
            return false;
        }
    }
}

