/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testing.dimension;

import com.google.api.services.testing.model.AndroidDeviceCatalog;
import com.google.api.services.testing.model.AndroidModel;
import com.google.common.collect.ImmutableList;
import com.google.gct.testing.CloudConfigurationImpl;
import com.google.gct.testing.CloudTestingUtils;
import com.google.gct.testing.dimension.CloudConfigurationDimension;
import com.google.gct.testing.dimension.CloudTestingType;
import com.google.gct.testing.launcher.CloudAuthenticator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;

public class DeviceDimension
extends CloudConfigurationDimension {
    public static final String DISPLAY_NAME = "Device";
    private static ImmutableList<Device> FULL_DOMAIN;
    private static Device defaultDevice;

    public DeviceDimension(CloudConfigurationImpl googleCloudTestingConfiguration) {
        super(googleCloudTestingConfiguration);
    }

    @Override
    public List<? extends CloudTestingType> getAppSupportedDomain() {
        return DeviceDimension.getFullDomain();
    }

    public static List<? extends CloudTestingType> getFullDomain() {
        if (DeviceDimension.isFullDomainMissing() || DeviceDimension.shouldPollDiscoveryTestApi(DISPLAY_NAME)) {
            ImmutableList.Builder fullDomainBuilder = new ImmutableList.Builder();
            AndroidDeviceCatalog androidDeviceCatalog = CloudAuthenticator.getAndroidDeviceCatalog();
            if (androidDeviceCatalog != null) {
                for (AndroidModel model : androidDeviceCatalog.getModels()) {
                    HashMap<String, String> details = new HashMap<String, String>();
                    details.put("Display", model.getScreenX() + "x" + model.getScreenY());
                    Device device = new Device(model.getId(), model.getName(), model.getManufacturer(), model.getForm(), details, model.getSupportedVersionIds());
                    fullDomainBuilder.add((Object)device);
                    List tags = model.getTags();
                    if (tags == null || !tags.contains("default")) continue;
                    defaultDevice = device;
                }
            }
            if (DeviceDimension.isFullDomainMissing() || !fullDomainBuilder.build().isEmpty()) {
                FULL_DOMAIN = fullDomainBuilder.build();
            }
            DeviceDimension.resetDiscoveryTestApiUpdateTimestamp(DISPLAY_NAME);
        }
        return FULL_DOMAIN;
    }

    private static boolean isFullDomainMissing() {
        return FULL_DOMAIN == null || FULL_DOMAIN.isEmpty();
    }

    private static Device getDefaultDevice() {
        if (defaultDevice == null) {
            DeviceDimension.getFullDomain();
        }
        return defaultDevice;
    }

    public void enableDefault(String minSupportedApiId) {
        if (DeviceDimension.getDefaultDevice() == null) {
            return;
        }
        if (defaultDevice.supportedVersionIds.contains(minSupportedApiId)) {
            this.enable(defaultDevice);
        } else {
            for (CloudTestingType cloudTestingType : this.getAppSupportedDomain()) {
                Device supportedDevice = (Device)cloudTestingType;
                if (!supportedDevice.isVirtual() || !supportedDevice.supportedVersionIds.contains(minSupportedApiId)) continue;
                this.enable(supportedDevice);
                return;
            }
        }
    }

    @Override
    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    @Override
    public String getId() {
        return "DEVICE";
    }

    @Override
    public Icon getIcon() {
        return CloudTestingUtils.CLOUD_DEVICE_ICON;
    }

    @Override
    public boolean shouldBeAlwaysGrouped() {
        return true;
    }

    public static class Device
    extends CloudTestingType {
        private final String id;
        private final String name;
        private final String manufacturer;
        private final String form;
        private final List<String> supportedVersionIds;

        public Device(String id, String name, String manufacturer, String form, Map<String, String> details, List<String> supportedVersionIds) {
            this.id = id;
            this.manufacturer = manufacturer;
            this.name = name;
            this.form = form;
            this.details = details;
            this.supportedVersionIds = supportedVersionIds;
        }

        @Override
        public String getGroupName() {
            return this.form;
        }

        @Override
        public String getGroupDescription() {
            return this.isVirtual() ? "Android OS running on Google Compute Engine." : "An actual physical device managed by Google.";
        }

        @Override
        public String getConfigurationDialogDisplayName() {
            return this.name + ", " + this.manufacturer;
        }

        @Override
        public String getResultsViewerDisplayName() {
            return this.getConfigurationDialogDisplayName() + (this.isVirtual() ? ", Virtual" : "");
        }

        public boolean isVirtual() {
            return this.form.equals("VIRTUAL");
        }

        @Override
        public String getId() {
            return this.id;
        }
    }
}

