/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testing.results;

import com.google.gct.testing.CloudTestingUtils;
import com.google.gct.testing.results.GoogleCloudTestIdentifier;
import com.google.gct.testing.results.IGoogleCloudTestRunListener;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.testframework.sm.ServiceMessageBuilder;
import java.util.Map;
import org.jetbrains.android.run.AndroidRunningState;

public class GoogleCloudTestListener
implements IGoogleCloudTestRunListener {
    private final AndroidRunningState myRunningState;
    private long myTestStartingTime;
    private long myTestSuiteStartingTime;
    private String myConfiguration = null;
    private String myTestClassName = null;
    private ProcessHandler myProcessHandler;

    public ProcessHandler getProcessHandler() {
        if (this.myProcessHandler == null) {
            this.myProcessHandler = this.myRunningState.getProcessHandler();
        }
        return this.myProcessHandler;
    }

    public GoogleCloudTestListener(AndroidRunningState runningState) {
        this.myRunningState = runningState;
    }

    @Override
    public void testRunStopped(long elapsedTime) {
        ProcessHandler handler = this.getProcessHandler();
        handler.notifyTextAvailable("Test running stopped\n", ProcessOutputTypes.STDOUT);
        handler.destroyProcess();
    }

    @Override
    public void testRunEnded(long elapsedTime, Map<String, String> runMetrics) {
        ProcessHandler handler = this.getProcessHandler();
        handler.destroyProcess();
    }

    @Override
    public void testRunStarted(String runName, int testCount) {
        ProcessHandler handler = this.getProcessHandler();
        ServiceMessageBuilder builder = new ServiceMessageBuilder("enteredTheMatrix");
        handler.notifyTextAvailable(builder.toString() + '\n', ProcessOutputTypes.STDOUT);
    }

    @Override
    public void testStarted(GoogleCloudTestIdentifier test) {
        ServiceMessageBuilder builder = new ServiceMessageBuilder("testStarted");
        builder.addAttribute("configuration", test.getConfiguration());
        builder.addAttribute("className", test.getClassName());
        builder.addAttribute("name", test.getTestName());
        builder.addAttribute("locationHint", "android://" + this.myRunningState.getModule().getName() + ':' + test.getClassName() + '.' + test.getTestName() + "()");
        this.getProcessHandler().notifyTextAvailable(builder.toString() + '\n', ProcessOutputTypes.STDOUT);
        this.myTestStartingTime = System.currentTimeMillis();
    }

    @Override
    public void setTestRunId(String testRunId) {
        ServiceMessageBuilder builder = new ServiceMessageBuilder("setTestRunId");
        builder.addAttribute("testRunId", testRunId);
        this.getProcessHandler().notifyTextAvailable(builder.toString() + '\n', ProcessOutputTypes.STDOUT);
    }

    @Override
    public void setActiveCloudMatrix() {
        ServiceMessageBuilder builder = new ServiceMessageBuilder("setActiveCloudMatrix");
        this.getProcessHandler().notifyTextAvailable(builder.toString() + '\n', ProcessOutputTypes.STDOUT);
    }

    @Override
    public void stopTestConfiguration(String configurationName, CloudTestingUtils.ConfigurationStopReason stopReason) {
        ServiceMessageBuilder builder = new ServiceMessageBuilder("testConfigurationStopped");
        builder.addAttribute("name", configurationName);
        builder.addAttribute("stopReason", stopReason.name());
        this.getProcessHandler().notifyTextAvailable(builder.toString() + '\n', ProcessOutputTypes.STDOUT);
    }

    @Override
    public void testConfigurationProgress(String configurationName, String progressMessage) {
        this.myConfiguration = configurationName;
        ServiceMessageBuilder builder = new ServiceMessageBuilder("testConfigurationProgress");
        builder.addAttribute("name", configurationName);
        builder.addAttribute("text", this.prepareProgressString(progressMessage));
        this.getProcessHandler().notifyTextAvailable(builder.toString() + '\n', ProcessOutputTypes.STDOUT);
    }

    private String prepareProgressString(String progressMessage) {
        return CloudTestingUtils.shouldShowProgressTimestamps() ? progressMessage + "\t" + System.currentTimeMillis() + "\n" : progressMessage + "\n";
    }

    @Override
    public void testConfigurationScheduled(String configurationName) {
        this.myConfiguration = configurationName;
        ServiceMessageBuilder builder = new ServiceMessageBuilder("testConfigurationScheduled");
        builder.addAttribute("name", configurationName);
        this.getProcessHandler().notifyTextAvailable(builder.toString() + '\n', ProcessOutputTypes.STDOUT);
    }

    @Override
    public void testConfigurationStarted(String configurationName) {
        this.myConfiguration = configurationName;
        ServiceMessageBuilder builder = new ServiceMessageBuilder("testConfigurationStarted");
        builder.addAttribute("name", configurationName);
        this.getProcessHandler().notifyTextAvailable(builder.toString() + '\n', ProcessOutputTypes.STDOUT);
    }

    public void testConfigurationFinished(String configurationName) {
        ServiceMessageBuilder builder = new ServiceMessageBuilder("testConfigurationFinished");
        builder.addAttribute("name", configurationName);
        this.getProcessHandler().notifyTextAvailable(builder.toString() + '\n', ProcessOutputTypes.STDOUT);
    }

    @Override
    public void testFailed(IGoogleCloudTestRunListener.TestFailure status, GoogleCloudTestIdentifier test, String stackTrace) {
        ServiceMessageBuilder builder = new ServiceMessageBuilder("testFailed");
        builder.addAttribute("configuration", test.getConfiguration());
        builder.addAttribute("className", test.getClassName());
        builder.addAttribute("name", test.getTestName());
        builder.addAttribute("message", "");
        builder.addAttribute("details", stackTrace);
        if (status == IGoogleCloudTestRunListener.TestFailure.ERROR) {
            builder.addAttribute("error", "true");
        }
        this.getProcessHandler().notifyTextAvailable(builder.toString() + '\n', ProcessOutputTypes.STDOUT);
    }

    @Override
    public void testEnded(GoogleCloudTestIdentifier test, Map<String, String> testMetrics) {
        ServiceMessageBuilder builder = new ServiceMessageBuilder("testFinished");
        builder.addAttribute("configuration", test.getConfiguration());
        builder.addAttribute("className", test.getClassName());
        builder.addAttribute("name", test.getTestName());
        builder.addAttribute("duration", Long.toString(System.currentTimeMillis() - this.myTestStartingTime));
        this.getProcessHandler().notifyTextAvailable(builder.toString() + '\n', ProcessOutputTypes.STDOUT);
    }

    @Override
    public void testRunFailed(String errorMessage) {
        ProcessHandler handler = this.getProcessHandler();
        handler.notifyTextAvailable("Test running failed: " + errorMessage + "\n", ProcessOutputTypes.STDERR);
        handler.destroyProcess();
    }
}

