/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testing.results;

import com.google.gct.testing.results.GoogleCloudTestProxy;
import com.google.gct.testing.results.GoogleCloudTestResultsConnectionUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import java.util.EmptyStackException;
import java.util.Stack;
import org.jetbrains.annotations.NonNls;

public class GoogleCloudTestSuiteStack {
    private static final Logger LOG = Logger.getInstance((String)GoogleCloudTestSuiteStack.class.getName());
    @NonNls
    private static final String EMPTY = "empty";
    private final Stack<GoogleCloudTestProxy> myStack = new Stack();

    public void pushSuite(GoogleCloudTestProxy suite) {
        this.myStack.push(suite);
    }

    public GoogleCloudTestProxy getCurrentSuite() {
        if (this.getStackSize() != 0) {
            return this.myStack.peek();
        }
        return null;
    }

    public GoogleCloudTestProxy popSuite(String suiteName) throws EmptyStackException {
        if (this.myStack.isEmpty()) {
            if (GoogleCloudTestResultsConnectionUtil.isInDebugMode()) {
                LOG.error("Pop error: Tests/suites stack is empty. Test runner tried to close test suite which has been already closed or wasn't started at all. Unexpected suite name [" + suiteName + "]");
            }
            return null;
        }
        GoogleCloudTestProxy topSuite = this.myStack.peek();
        if (!suiteName.equals(topSuite.getName())) {
            if (!GoogleCloudTestResultsConnectionUtil.isInDebugMode()) {
                GoogleCloudTestProxy expectedProxy = null;
                for (GoogleCloudTestProxy candidateProxy : this.myStack) {
                    if (!suiteName.equals(candidateProxy.getName())) continue;
                    expectedProxy = candidateProxy;
                    break;
                }
                if (expectedProxy != null) {
                    GoogleCloudTestProxy proxy = topSuite;
                    while (proxy != expectedProxy) {
                        proxy = this.myStack.pop();
                    }
                    return expectedProxy;
                }
                return null;
            }
            LOG.error("Pop error: Unexpected closing suite. Expected [" + suiteName + "] but [" + topSuite.getName() + "] was found. Rest of stack: " + this.getSuitePathPresentation());
            return null;
        }
        this.myStack.pop();
        return topSuite;
    }

    public final boolean isEmpty() {
        return this.getStackSize() == 0;
    }

    protected int getStackSize() {
        return this.myStack.size();
    }

    protected String[] getSuitePath() {
        int stackSize = this.getStackSize();
        String[] names = new String[stackSize];
        for (int i = 0; i < stackSize; ++i) {
            names[i] = ((GoogleCloudTestProxy)((Object)this.myStack.get(i))).getName();
        }
        return names;
    }

    protected String getSuitePathPresentation() {
        Object[] names = this.getSuitePath();
        if (names.length == 0) {
            return EMPTY;
        }
        return StringUtil.join((Object[])names, (Function)new Function<String, String>(){

            public String fun(String s) {
                return "[" + s + "]";
            }
        }, (String)"->");
    }

    public void clear() {
        this.myStack.clear();
    }
}

