/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testing.results;

import com.google.gct.testing.results.GoogleCloudTestNodeDescriptor;
import com.google.gct.testing.results.GoogleCloudTestProxy;
import com.google.gct.testing.results.GoogleCloudTestingRootTestProxyFormatter;
import com.google.gct.testing.results.GoogleCloudTestsPresentationUtil;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.NonNls;

public class GoogleCloudTestTreeRenderer
extends ColoredTreeCellRenderer {
    @NonNls
    private static final String SPACE_STRING = " ";
    private final TestConsoleProperties myConsoleProperties;
    private GoogleCloudTestingRootTestProxyFormatter myAdditionalRootFormatter;

    public GoogleCloudTestTreeRenderer(TestConsoleProperties consoleProperties) {
        this.myConsoleProperties = consoleProperties;
    }

    public void customizeCellRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
        Object userObj = node.getUserObject();
        if (userObj instanceof GoogleCloudTestNodeDescriptor) {
            GoogleCloudTestNodeDescriptor desc = (GoogleCloudTestNodeDescriptor)((Object)userObj);
            GoogleCloudTestProxy testProxy = (GoogleCloudTestProxy)desc.getElement();
            if (testProxy instanceof GoogleCloudTestProxy.GoogleCloudRootTestProxy) {
                GoogleCloudTestProxy.GoogleCloudRootTestProxy rootTestProxy = (GoogleCloudTestProxy.GoogleCloudRootTestProxy)testProxy;
                if (rootTestProxy.isLeaf()) {
                    GoogleCloudTestsPresentationUtil.formatRootNodeWithoutChildren(rootTestProxy, this);
                } else {
                    GoogleCloudTestsPresentationUtil.formatRootNodeWithChildren(rootTestProxy, this);
                }
                if (this.myAdditionalRootFormatter != null) {
                    this.myAdditionalRootFormatter.format(rootTestProxy, this);
                }
            } else {
                GoogleCloudTestsPresentationUtil.formatTestProxy(testProxy, this);
            }
            return;
        }
        String text = node.toString();
        this.append(text != null ? text : SPACE_STRING, SimpleTextAttributes.GRAYED_ATTRIBUTES);
    }

    public TestConsoleProperties getConsoleProperties() {
        return this.myConsoleProperties;
    }

    public void setAdditionalRootFormatter(GoogleCloudTestingRootTestProxyFormatter formatter) {
        this.myAdditionalRootFormatter = formatter;
    }

    public void removeAdditionalRootFormatter() {
        this.myAdditionalRootFormatter = null;
    }
}

