/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testing.results;

import com.google.gct.testing.results.GoogleCloudTestEventsAdapter;
import com.google.gct.testing.results.GoogleCloudTestProxy;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.TestsUIUtil;
import com.intellij.execution.testframework.sm.SMTestsRunnerBundle;
import com.intellij.execution.testframework.sm.runner.states.TestStateInfo;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.SystemNotifications;
import javax.swing.SwingUtilities;

public class GoogleCloudTestingNotificationsHandler
extends GoogleCloudTestEventsAdapter {
    private final TestConsoleProperties myConsoleProperties;

    public GoogleCloudTestingNotificationsHandler(TestConsoleProperties consoleProperties) {
        this.myConsoleProperties = consoleProperties;
    }

    @Override
    public void onTestingStarted(GoogleCloudTestProxy.GoogleCloudRootTestProxy testsRoot, boolean printTestingStartedTime) {
    }

    @Override
    public void onTestingFinished(GoogleCloudTestProxy.GoogleCloudRootTestProxy testsRoot) {
        MessageType type;
        String msg;
        TestStateInfo.Magnitude magnitude = testsRoot.getMagnitudeInfo();
        switch (magnitude) {
            case SKIPPED_INDEX: 
            case IGNORED_INDEX: {
                msg = testsRoot.hasErrors() ? SMTestsRunnerBundle.message((String)"sm.test.runner.notifications.tests.skipped.with.errors", (Object[])new Object[0]) : SMTestsRunnerBundle.message((String)"sm.test.runner.notifications.tests.skipped", (Object[])new Object[0]);
                type = MessageType.WARNING;
                break;
            }
            case NOT_RUN_INDEX: {
                msg = testsRoot.hasErrors() ? SMTestsRunnerBundle.message((String)"sm.test.runner.notifications.tests.not.run.with.errors", (Object[])new Object[0]) : SMTestsRunnerBundle.message((String)"sm.test.runner.notifications.tests.not.run", (Object[])new Object[0]);
                type = MessageType.WARNING;
                break;
            }
            case FAILED_INDEX: 
            case ERROR_INDEX: {
                msg = testsRoot.hasErrors() ? SMTestsRunnerBundle.message((String)"sm.test.runner.notifications.tests.failed.with.errors", (Object[])new Object[0]) : SMTestsRunnerBundle.message((String)"sm.test.runner.notifications.tests.failed", (Object[])new Object[0]);
                type = MessageType.ERROR;
                break;
            }
            case COMPLETE_INDEX: {
                if (testsRoot.getChildren().size() == 0 && !testsRoot.isLeaf()) {
                    msg = testsRoot.hasErrors() ? SMTestsRunnerBundle.message((String)"sm.test.runner.ui.tests.tree.presentation.labels.no.tests.were.found.with.errors", (Object[])new Object[0]) : (testsRoot.isTestsReporterAttached() ? SMTestsRunnerBundle.message((String)"sm.test.runner.ui.tests.tree.presentation.labels.no.tests.were.found", (Object[])new Object[0]) : SMTestsRunnerBundle.message((String)"sm.test.runner.ui.tests.tree.presentation.labels.test.reporter.not.attached", (Object[])new Object[0]));
                    type = MessageType.ERROR;
                    break;
                }
                if (testsRoot.isEmptySuite()) {
                    msg = SMTestsRunnerBundle.message((String)"sm.test.runner.ui.tests.tree.presentation.labels.empty.test.suite", (Object[])new Object[0]);
                    type = MessageType.WARNING;
                    break;
                }
            }
            case PASSED_INDEX: {
                msg = testsRoot.hasErrors() ? SMTestsRunnerBundle.message((String)"sm.test.runner.notifications.tests.passed.with.errors", (Object[])new Object[0]) : SMTestsRunnerBundle.message((String)"sm.test.runner.notifications.tests.passed", (Object[])new Object[0]);
                type = MessageType.INFO;
                break;
            }
            default: {
                msg = null;
                type = null;
            }
        }
        if (msg != null) {
            this.notify(msg, type, testsRoot);
        }
    }

    @Override
    public void onTestFailed(GoogleCloudTestProxy test) {
    }

    private void notify(final String msg, final MessageType type, final GoogleCloudTestProxy.GoogleCloudRootTestProxy testsRoot) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Project project = GoogleCloudTestingNotificationsHandler.this.myConsoleProperties.getProject();
                if (project.isDisposed()) {
                    return;
                }
                if (GoogleCloudTestingNotificationsHandler.this.myConsoleProperties == null) {
                    return;
                }
                String testRunDebugId = GoogleCloudTestingNotificationsHandler.this.myConsoleProperties.isDebug() ? ToolWindowId.DEBUG : ToolWindowId.RUN;
                ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)project);
                if (!Comparing.strEqual((String)toolWindowManager.getActiveToolWindowId(), (String)testRunDebugId)) {
                    toolWindowManager.notifyByBalloon(testRunDebugId, type, msg, null, null);
                }
                TestsUIUtil.NOTIFICATION_GROUP.createNotification(msg, type).notify(project);
                SystemNotifications.getInstance().notify("TestRunner", msg, TestsUIUtil.getTestShortSummary((AbstractTestProxy)testsRoot));
            }
        });
    }
}

