/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testing.results;

import com.google.gct.testing.results.GoogleCloudTestEventsAdapter;
import com.google.gct.testing.results.GoogleCloudTestEventsListener;
import com.google.gct.testing.results.GoogleCloudTestProxy;
import com.google.gct.testing.results.GoogleCloudTestingPropagateSelectionHandler;
import com.google.gct.testing.results.GoogleCloudTestingStatisticsTableModel;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.TestFrameworkRunningModel;
import com.intellij.execution.testframework.TestsUIUtil;
import com.intellij.execution.testframework.sm.SMRunnerUtil;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.TableUtil;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.table.BaseTableView;
import com.intellij.ui.table.TableView;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.config.Storage;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ListTableModel;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NonNls;

public class GoogleCloudTestingStatisticsPanel
implements DataProvider {
    public static final DataKey<GoogleCloudTestingStatisticsPanel> SM_TEST_RUNNER_STATISTICS = DataKey.create((String)"SM_TEST_RUNNER_STATISTICS");
    private TableView<GoogleCloudTestProxy> myStatisticsTableView;
    private JPanel myContentPane;
    private final Storage.PropertiesComponentStorage myStorage;
    private final GoogleCloudTestingStatisticsTableModel myTableModel;
    private final List<GoogleCloudTestingPropagateSelectionHandler> myPropagateSelectionHandlers;
    private final Project myProject;
    private final TestFrameworkRunningModel myFrameworkRunningModel;

    public GoogleCloudTestingStatisticsPanel(Project project, TestFrameworkRunningModel model) {
        this.$$$setupUI$$$();
        this.myStorage = new Storage.PropertiesComponentStorage("sm_test_statistics_table_columns");
        this.myPropagateSelectionHandlers = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myProject = project;
        this.myTableModel = new GoogleCloudTestingStatisticsTableModel();
        this.myStatisticsTableView.setModelAndUpdateColumns((ListTableModel)this.myTableModel);
        this.myFrameworkRunningModel = model;
        final Runnable gotoSuiteOrParentAction = this.createGotoSuiteOrParentAction();
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent e) {
                gotoSuiteOrParentAction.run();
                return true;
            }
        }.installOn(this.myStatisticsTableView);
        KeyStroke shiftEnterKey = KeyStroke.getKeyStroke(10, 1);
        SMRunnerUtil.registerAsAction((KeyStroke)shiftEnterKey, (String)"select-test-proxy-in-test-view", (Runnable)new Runnable(){

            @Override
            public void run() {
                GoogleCloudTestingStatisticsPanel.this.showSelectedProxyInTestsTree();
            }
        }, this.myStatisticsTableView);
        KeyStroke enterKey = KeyStroke.getKeyStroke(10, 0);
        SMRunnerUtil.registerAsAction((KeyStroke)enterKey, (String)"go-to-selected-suite-or-parent", (Runnable)gotoSuiteOrParentAction, this.myStatisticsTableView);
        PopupHandler.installPopupHandler(this.myStatisticsTableView, (String)"TestTreePopupMenu", (String)"TestTreeViewPopup");
        DataManager.registerDataProvider(this.myStatisticsTableView, (DataProvider)this);
    }

    public void addPropagateSelectionListener(GoogleCloudTestingPropagateSelectionHandler handler) {
        this.myPropagateSelectionHandlers.add(handler);
    }

    public JPanel getContentPane() {
        return this.myContentPane;
    }

    public GoogleCloudTestEventsListener createTestEventsListener() {
        return new GoogleCloudTestEventsAdapter(){

            @Override
            public void onSuiteStarted(GoogleCloudTestProxy suite) {
                if (GoogleCloudTestingStatisticsPanel.this.myTableModel.shouldUpdateModelBySuite(suite)) {
                    this.updateAndRestoreSelection();
                }
            }

            @Override
            public void onSuiteFinished(GoogleCloudTestProxy suite) {
                if (GoogleCloudTestingStatisticsPanel.this.myTableModel.shouldUpdateModelBySuite(suite)) {
                    this.updateAndRestoreSelection();
                }
            }

            @Override
            public void onTestStarted(GoogleCloudTestProxy test) {
                if (GoogleCloudTestingStatisticsPanel.this.myTableModel.shouldUpdateModelByTest(test)) {
                    this.updateAndRestoreSelection();
                }
            }

            @Override
            public void onTestFinished(GoogleCloudTestProxy test) {
                if (GoogleCloudTestingStatisticsPanel.this.myTableModel.shouldUpdateModelByTest(test)) {
                    this.updateAndRestoreSelection();
                }
            }

            private void updateAndRestoreSelection() {
                SMRunnerUtil.addToInvokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        int newRow;
                        BaseTableView.restore((Storage)GoogleCloudTestingStatisticsPanel.this.myStorage, (JTable)GoogleCloudTestingStatisticsPanel.this.myStatisticsTableView);
                        GoogleCloudTestProxy oldSelection = (GoogleCloudTestProxy)((Object)GoogleCloudTestingStatisticsPanel.this.myStatisticsTableView.getSelectedObject());
                        GoogleCloudTestingStatisticsPanel.this.myTableModel.updateModel();
                        if (oldSelection != null && (newRow = GoogleCloudTestingStatisticsPanel.this.myTableModel.getIndexOf(oldSelection)) > -1) {
                            GoogleCloudTestingStatisticsPanel.this.myStatisticsTableView.setRowSelectionInterval(newRow, newRow);
                        }
                    }
                });
            }
        };
    }

    public Object getData(@NonNls String dataId) {
        if (SM_TEST_RUNNER_STATISTICS.is(dataId)) {
            return this;
        }
        return TestsUIUtil.getData((AbstractTestProxy)this.getSelectedItem(), (String)dataId, (TestFrameworkRunningModel)this.myFrameworkRunningModel);
    }

    public GoogleCloudTestingPropagateSelectionHandler createSelectMeListener() {
        return new GoogleCloudTestingPropagateSelectionHandler(){

            @Override
            public void handlePropagateSelectionRequest(GoogleCloudTestProxy selectedTestProxy, Object sender, boolean requestFocus) {
                GoogleCloudTestingStatisticsPanel.this.selectProxy(selectedTestProxy, sender, requestFocus);
            }
        };
    }

    public void selectProxy(final GoogleCloudTestProxy selectedTestProxy, Object sender, final boolean requestFocus) {
        SMRunnerUtil.addToInvokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                if (requestFocus) {
                    IdeFocusManager.getInstance((Project)GoogleCloudTestingStatisticsPanel.this.myProject).requestFocus((Component)GoogleCloudTestingStatisticsPanel.this.myStatisticsTableView, true);
                }
                GoogleCloudTestingStatisticsPanel.this.selectProxy(selectedTestProxy);
            }
        });
    }

    protected void showSelectedProxyInTestsTree() {
        Collection proxies = this.myStatisticsTableView.getSelection();
        if (proxies.isEmpty()) {
            return;
        }
        GoogleCloudTestProxy proxy = (GoogleCloudTestProxy)((Object)proxies.iterator().next());
        this.myStatisticsTableView.clearSelection();
        this.fireOnPropagateSelection(proxy);
    }

    protected Runnable createGotoSuiteOrParentAction() {
        return new Runnable(){

            @Override
            public void run() {
                GoogleCloudTestProxy selectedProxy = GoogleCloudTestingStatisticsPanel.this.getSelectedItem();
                if (selectedProxy == null) {
                    return;
                }
                int i = GoogleCloudTestingStatisticsPanel.this.myStatisticsTableView.getSelectedRow();
                assert (i >= 0);
                if (selectedProxy.isSuite()) {
                    GoogleCloudTestingStatisticsPanel.this.showInTableAndSelectRow(selectedProxy, selectedProxy);
                }
            }
        };
    }

    protected void selectProxy(GoogleCloudTestProxy selectedTestProxy) {
        this.myTableModel.updateModelOnProxySelected(selectedTestProxy);
        if (selectedTestProxy != null) {
            this.findAndSelectInTable(selectedTestProxy);
        }
    }

    protected void selectRow(final int rowIndex) {
        SMRunnerUtil.addToInvokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                GoogleCloudTestingStatisticsPanel.this.myStatisticsTableView.setRowSelectionInterval(rowIndex, rowIndex);
                TableUtil.scrollSelectionToVisible((JTable)GoogleCloudTestingStatisticsPanel.this.myStatisticsTableView);
            }
        });
    }

    protected void selectRowOf(final GoogleCloudTestProxy proxy) {
        SMRunnerUtil.addToInvokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                int indexOf = GoogleCloudTestingStatisticsPanel.this.myTableModel.getIndexOf(proxy);
                if (indexOf > -1) {
                    int rowIndex = GoogleCloudTestingStatisticsPanel.this.myStatisticsTableView.convertRowIndexToView(indexOf);
                    GoogleCloudTestingStatisticsPanel.this.myStatisticsTableView.setRowSelectionInterval(rowIndex, rowIndex >= 0 ? rowIndex : 0);
                    TableUtil.scrollSelectionToVisible((JTable)GoogleCloudTestingStatisticsPanel.this.myStatisticsTableView);
                }
            }
        });
    }

    protected GoogleCloudTestProxy getSelectedItem() {
        return (GoogleCloudTestProxy)((Object)this.myStatisticsTableView.getSelectedObject());
    }

    protected List<GoogleCloudTestProxy> getTableItems() {
        return this.myTableModel.getItems();
    }

    private void findAndSelectInTable(final GoogleCloudTestProxy proxy) {
        SMRunnerUtil.addToInvokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                int rowIndex = GoogleCloudTestingStatisticsPanel.this.myTableModel.getIndexOf(proxy);
                if (rowIndex >= 0) {
                    GoogleCloudTestingStatisticsPanel.this.myStatisticsTableView.setRowSelectionInterval(rowIndex, rowIndex);
                }
            }
        });
    }

    private void fireOnPropagateSelection(GoogleCloudTestProxy selectedTestProxy) {
        for (GoogleCloudTestingPropagateSelectionHandler handler : this.myPropagateSelectionHandlers) {
            handler.handlePropagateSelectionRequest(selectedTestProxy, this, true);
        }
    }

    private void createUIComponents() {
        this.myStatisticsTableView = new TableView();
    }

    private void showInTableAndSelectRow(GoogleCloudTestProxy suite, GoogleCloudTestProxy suiteProxy) {
        this.selectProxy(suite);
        this.selectRowOf(suiteProxy);
    }

    public void doDispose() {
        BaseTableView.store((Storage)this.myStorage, this.myStatisticsTableView);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        this.createUIComponents();
        this.myContentPane = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        TableView<GoogleCloudTestProxy> tableView = this.myStatisticsTableView;
        tableView.setShowVerticalLines(true);
        jBScrollPane.setViewportView((Component)tableView);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPane;
    }
}

