/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testing.ui;

import java.awt.BasicStroke;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.beans.ConstructorProperties;
import javax.swing.border.AbstractBorder;

public class StrokeBorder
extends AbstractBorder {
    private final BasicStroke stroke;
    private final Paint paint;

    public StrokeBorder(BasicStroke stroke) {
        this(stroke, null);
    }

    @ConstructorProperties(value={"stroke", "paint"})
    public StrokeBorder(BasicStroke stroke, Paint paint) {
        if (stroke == null) {
            throw new NullPointerException("border's stroke");
        }
        this.stroke = stroke;
        this.paint = paint;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        float size = this.stroke.getLineWidth();
        if (size > 0.0f) {
            if ((g = g.create()) instanceof Graphics2D) {
                Graphics2D g2d = (Graphics2D)g;
                g2d.setStroke(this.stroke);
                g2d.setPaint((Paint)(this.paint != null ? this.paint : (c == null ? null : c.getForeground())));
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2d.draw(new Rectangle2D.Float((float)x + size / 2.0f, (float)y + size / 2.0f, (float)width - size, (float)height - size));
            }
            g.dispose();
        }
    }

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        int size = (int)Math.ceil(this.stroke.getLineWidth());
        insets.set(size, size, size, size);
        return insets;
    }

    public BasicStroke getStroke() {
        return this.stroke;
    }

    public Paint getPaint() {
        return this.paint;
    }
}

