/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testing.vnc;

import com.glavsoft.viewer.Viewer;
import com.glavsoft.viewer.VncKeepAliveThread;
import com.glavsoft.viewer.cli.Parser;
import com.google.api.services.testing.model.Device;
import com.google.gct.testing.launcher.CloudAuthenticator;
import java.io.File;
import javax.swing.SwingUtilities;

public class VncKeepAliveThreadImpl
extends VncKeepAliveThread {
    private final Parser parser;
    private final String configurationName;
    private final String cloudProjectId;
    private final String cloudDeviceId;
    private final String deviceAddress;
    private final File workingDir;
    private volatile boolean hasCrashed = false;
    private Viewer currentViewer;

    public static void startVnc(String[] args, String configurationName, String cloudProjectId, String cloudDeviceId, String deviceAddress, File workingDir) {
        Parser parser = Viewer.prepareParser((String[])args);
        if (parser == null) {
            return;
        }
        new VncKeepAliveThreadImpl(parser, configurationName, cloudProjectId, cloudDeviceId, deviceAddress, workingDir).start();
    }

    public VncKeepAliveThreadImpl(Parser parser, String configurationName, String cloudProjectId, String cloudDeviceId, String deviceAddress, File workingDir) {
        this.parser = parser;
        this.configurationName = configurationName;
        this.cloudProjectId = cloudProjectId;
        this.cloudDeviceId = cloudDeviceId;
        this.deviceAddress = deviceAddress;
        this.workingDir = workingDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.currentViewer = new Viewer((VncKeepAliveThread)this, this.parser, this.configurationName);
            SwingUtilities.invokeLater((Runnable)this.currentViewer);
            while (!Thread.currentThread().isInterrupted() && this.deviceIsReady()) {
                try {
                    CloudAuthenticator.getTest().projects().devices().keepalive(this.cloudProjectId, this.cloudDeviceId).execute();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (this.hasCrashed) {
                    this.hasCrashed = false;
                    System.out.println("Restarting TightVNC Viewer");
                    this.currentViewer = new Viewer((VncKeepAliveThread)this, this.parser, this.configurationName);
                    SwingUtilities.invokeLater((Runnable)this.currentViewer);
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                    break;
                }
            }
        }
        finally {
            this.tearDown();
        }
    }

    private void tearDown() {
        try {
            Runtime.getRuntime().exec("./adb disconnect " + this.deviceAddress, null, this.workingDir);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            CloudAuthenticator.getTest().projects().devices().delete(this.cloudProjectId, this.cloudDeviceId).execute();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.currentViewer.stopViewer();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private boolean deviceIsReady() {
        try {
            return ((Device)CloudAuthenticator.getTest().projects().devices().get(this.cloudProjectId, this.cloudDeviceId).execute()).getState().equals("READY");
        }
        catch (Exception e) {
            return true;
        }
    }

    public void setCrashed() {
        this.hasCrashed = true;
    }
}

