/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server;

import java.io.File;
import java.rmi.RemoteException;
import java.util.List;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.maven.execution.MavenExecutionRequest;
import org.jetbrains.idea.maven.server.MavenRemoteObject;
import org.jetbrains.idea.maven.server.MavenServerEmbedder;
import org.jetbrains.idea.maven.server.MavenServerSettings;

public abstract class Maven3ServerEmbedder
extends MavenRemoteObject
implements MavenServerEmbedder {
    public static final boolean USE_MVN2_COMPATIBLE_DEPENDENCY_RESOLVING = System.getProperty("idea.maven3.use.compat.resolver") != null;
    private static final String MAVEN_VERSION = System.getProperty("idea.maven.embedder.version");

    public Maven3ServerEmbedder(MavenServerSettings settings) {
        Maven3ServerEmbedder.initLog4J(settings);
    }

    public String getMavenVersion() {
        return MAVEN_VERSION;
    }

    public abstract <T> T getComponent(Class<T> var1, String var2);

    public abstract <T> T getComponent(Class<T> var1);

    public abstract void executeWithMavenSession(MavenExecutionRequest var1, Runnable var2);

    public abstract MavenExecutionRequest createRequest(File var1, List<String> var2, List<String> var3, List<String> var4) throws RemoteException;

    private static void initLog4J(MavenServerSettings settings) {
        try {
            BasicConfigurator.configure();
            Level rootLoggerLevel = Maven3ServerEmbedder.toLog4JLevel(settings.getLoggingLevel());
            Logger.getRootLogger().setLevel(rootLoggerLevel);
            if (!rootLoggerLevel.isGreaterOrEqual((Priority)Level.ERROR)) {
                Logger.getLogger((String)"org.apache.maven.wagon.providers.http.httpclient.wire").setLevel(Level.ERROR);
                Logger.getLogger((String)"org.apache.http.wire").setLevel(Level.ERROR);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static Level toLog4JLevel(int level) {
        switch (level) {
            case 0: {
                return Level.ALL;
            }
            case 3: {
                return Level.ERROR;
            }
            case 4: {
                return Level.FATAL;
            }
            case 5: {
                return Level.OFF;
            }
            case 1: {
                return Level.INFO;
            }
            case 2: {
                return Level.WARN;
            }
        }
        return Level.INFO;
    }
}

