/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server.embedder;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.metadata.ArtifactMetadataRetrievalException;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.metadata.ResolutionGroup;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.LegacyLocalRepositoryManager;
import org.apache.maven.artifact.repository.RepositoryRequest;
import org.apache.maven.artifact.repository.metadata.Snapshot;
import org.apache.maven.artifact.repository.metadata.SnapshotArtifactRepositoryMetadata;
import org.apache.maven.artifact.resolver.AbstractArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactCollector;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.DebugResolutionListener;
import org.apache.maven.artifact.resolver.ResolutionErrorHandler;
import org.apache.maven.artifact.resolver.ResolutionListener;
import org.apache.maven.artifact.resolver.ResolutionNode;
import org.apache.maven.artifact.resolver.WarningResolutionListener;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.LegacySupport;
import org.apache.maven.repository.legacy.metadata.DefaultMetadataResolutionRequest;
import org.apache.maven.repository.legacy.metadata.MetadataResolutionRequest;
import org.apache.maven.repository.legacy.resolver.conflict.ConflictResolver;
import org.apache.maven.wagon.events.TransferListener;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.logging.Logger;
import org.jetbrains.idea.maven.model.MavenWorkspaceMap;
import org.jetbrains.idea.maven.server.MavenModelConverter;
import org.jetbrains.idea.maven.server.UnresolvedArtifactsCollector;
import org.sonatype.aether.RepositorySystem;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.repository.LocalRepositoryManager;
import org.sonatype.aether.resolution.ArtifactRequest;
import org.sonatype.aether.resolution.ArtifactResult;
import org.sonatype.aether.transfer.ArtifactNotFoundException;

@Component(role=ArtifactResolver.class, hint="ide")
public class CustomMaven3ArtifactResolver
implements ArtifactResolver {
    @Requirement
    private Logger logger;
    @Requirement
    protected ArtifactFactory artifactFactory;
    @Requirement
    private ArtifactCollector artifactCollector;
    @Requirement
    private ResolutionErrorHandler resolutionErrorHandler;
    @Requirement
    private ArtifactMetadataSource source;
    @Requirement
    private PlexusContainer container;
    @Requirement
    private LegacySupport legacySupport;
    @Requirement
    private RepositorySystem repoSystem;
    private final Executor executor;
    private volatile MavenWorkspaceMap myWorkspaceMap;
    private volatile UnresolvedArtifactsCollector myUnresolvedCollector;

    public CustomMaven3ArtifactResolver() {
        int threads = Integer.getInteger("maven.artifact.threads", 5);
        this.executor = threads <= 1 ? new Executor(){

            @Override
            public void execute(Runnable command) {
                command.run();
            }
        } : new ThreadPoolExecutor(threads, threads, 3L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new DaemonThreadCreator());
    }

    protected void finalize() throws Throwable {
        if (this.executor instanceof ExecutorService) {
            ((ExecutorService)this.executor).shutdown();
        }
    }

    private RepositorySystemSession getSession(ArtifactRepository localRepository) {
        return LegacyLocalRepositoryManager.overlay((ArtifactRepository)localRepository, (RepositorySystemSession)this.legacySupport.getRepositorySession(), (RepositorySystem)this.repoSystem);
    }

    private void injectSession1(RepositoryRequest request, MavenSession session) {
        if (session != null) {
            request.setOffline(session.isOffline());
            request.setForceUpdate(session.getRequest().isUpdateSnapshots());
        }
    }

    private void injectSession2(ArtifactResolutionRequest request, MavenSession session) {
        this.injectSession1((RepositoryRequest)request, session);
        if (session != null) {
            request.setServers(session.getRequest().getServers());
            request.setMirrors(session.getRequest().getMirrors());
            request.setProxies(session.getRequest().getProxies());
        }
    }

    public void resolve(Artifact artifact, List<ArtifactRepository> remoteRepositories, ArtifactRepository localRepository, TransferListener resolutionListener) throws ArtifactResolutionException, org.apache.maven.artifact.resolver.ArtifactNotFoundException {
        this.resolve(artifact, remoteRepositories, this.getSession(localRepository));
    }

    public void resolveAlways(Artifact artifact, List<ArtifactRepository> remoteRepositories, ArtifactRepository localRepository) throws ArtifactResolutionException, org.apache.maven.artifact.resolver.ArtifactNotFoundException {
        this.resolve(artifact, remoteRepositories, this.getSession(localRepository));
    }

    private void resolve(Artifact artifact, List<ArtifactRepository> remoteRepositories, RepositorySystemSession session) throws ArtifactResolutionException, org.apache.maven.artifact.resolver.ArtifactNotFoundException {
        if (this.resolveAsModule(artifact)) {
            return;
        }
        try {
            this.resolveOld(artifact, remoteRepositories, session);
        }
        catch (AbstractArtifactResolutionException e) {
            this.myUnresolvedCollector.collectAndSetResolved(artifact);
        }
    }

    private void resolveOld(Artifact artifact, List<ArtifactRepository> remoteRepositories, RepositorySystemSession session) throws ArtifactResolutionException, org.apache.maven.artifact.resolver.ArtifactNotFoundException {
        if (artifact == null) {
            return;
        }
        if ("system".equals(artifact.getScope())) {
            File systemFile = artifact.getFile();
            if (systemFile == null) {
                throw new org.apache.maven.artifact.resolver.ArtifactNotFoundException("System artifact: " + artifact + " has no file attached", artifact);
            }
            if (!systemFile.exists()) {
                throw new org.apache.maven.artifact.resolver.ArtifactNotFoundException("System artifact: " + artifact + " not found in path: " + systemFile, artifact);
            }
            if (!systemFile.isFile()) {
                throw new org.apache.maven.artifact.resolver.ArtifactNotFoundException("System artifact: " + artifact + " is not a file: " + systemFile, artifact);
            }
            artifact.setResolved(true);
            return;
        }
        if (!artifact.isResolved()) {
            Matcher matcher;
            ArtifactResult result;
            try {
                ArtifactRequest artifactRequest = new ArtifactRequest();
                artifactRequest.setArtifact(RepositoryUtils.toArtifact((Artifact)artifact));
                artifactRequest.setRepositories(RepositoryUtils.toRepos(remoteRepositories));
                LocalRepositoryManager lrm = session.getLocalRepositoryManager();
                String path = lrm.getPathForLocalArtifact(artifactRequest.getArtifact());
                artifact.setFile(new File(lrm.getRepository().getBasedir(), path));
                result = this.repoSystem.resolveArtifact(session, artifactRequest);
            }
            catch (org.sonatype.aether.resolution.ArtifactResolutionException e) {
                if (e.getCause() instanceof ArtifactNotFoundException) {
                    throw new org.apache.maven.artifact.resolver.ArtifactNotFoundException(e.getMessage(), artifact, remoteRepositories, e){};
                }
                throw new ArtifactResolutionException(e.getMessage(), artifact, remoteRepositories, (Throwable)e);
            }
            artifact.selectVersion(result.getArtifact().getVersion());
            artifact.setFile(result.getArtifact().getFile());
            artifact.setResolved(true);
            if (artifact.isSnapshot() && (matcher = Artifact.VERSION_FILE_PATTERN.matcher(artifact.getVersion())).matches()) {
                Snapshot snapshot = new Snapshot();
                snapshot.setTimestamp(matcher.group(2));
                try {
                    snapshot.setBuildNumber(Integer.parseInt(matcher.group(3)));
                    artifact.addMetadata((ArtifactMetadata)new SnapshotArtifactRepositoryMetadata(artifact, snapshot));
                }
                catch (NumberFormatException e) {
                    this.logger.warn("Invalid artifact version " + artifact.getVersion() + ": " + e.getMessage());
                }
            }
        }
    }

    public ArtifactResolutionResult resolveTransitively(Set<Artifact> artifacts, Artifact originatingArtifact, ArtifactRepository localRepository, List<ArtifactRepository> remoteRepositories, ArtifactMetadataSource source, ArtifactFilter filter) throws ArtifactResolutionException, org.apache.maven.artifact.resolver.ArtifactNotFoundException {
        return this.resolveTransitively(artifacts, originatingArtifact, Collections.EMPTY_MAP, localRepository, remoteRepositories, source, filter);
    }

    public ArtifactResolutionResult resolveTransitively(Set<Artifact> artifacts, Artifact originatingArtifact, Map managedVersions, ArtifactRepository localRepository, List<ArtifactRepository> remoteRepositories, ArtifactMetadataSource source) throws ArtifactResolutionException, org.apache.maven.artifact.resolver.ArtifactNotFoundException {
        return this.resolveTransitively(artifacts, originatingArtifact, managedVersions, localRepository, remoteRepositories, source, null);
    }

    public ArtifactResolutionResult resolveTransitively(Set<Artifact> artifacts, Artifact originatingArtifact, Map managedVersions, ArtifactRepository localRepository, List<ArtifactRepository> remoteRepositories, ArtifactMetadataSource source, ArtifactFilter filter) throws ArtifactResolutionException, org.apache.maven.artifact.resolver.ArtifactNotFoundException {
        return this.resolveTransitively(artifacts, originatingArtifact, managedVersions, localRepository, remoteRepositories, source, filter, null);
    }

    public ArtifactResolutionResult resolveTransitively(Set<Artifact> artifacts, Artifact originatingArtifact, List<ArtifactRepository> remoteRepositories, ArtifactRepository localRepository, ArtifactMetadataSource source) throws ArtifactResolutionException, org.apache.maven.artifact.resolver.ArtifactNotFoundException {
        return this.resolveTransitively(artifacts, originatingArtifact, localRepository, remoteRepositories, source, null);
    }

    public ArtifactResolutionResult resolveTransitively(Set<Artifact> artifacts, Artifact originatingArtifact, List<ArtifactRepository> remoteRepositories, ArtifactRepository localRepository, ArtifactMetadataSource source, List<ResolutionListener> listeners) throws ArtifactResolutionException, org.apache.maven.artifact.resolver.ArtifactNotFoundException {
        return this.resolveTransitively(artifacts, originatingArtifact, Collections.EMPTY_MAP, localRepository, remoteRepositories, source, null, listeners);
    }

    public ArtifactResolutionResult resolveTransitively(Set<Artifact> artifacts, Artifact originatingArtifact, Map managedVersions, ArtifactRepository localRepository, List<ArtifactRepository> remoteRepositories, ArtifactMetadataSource source, ArtifactFilter filter, List<ResolutionListener> listeners) throws ArtifactResolutionException, org.apache.maven.artifact.resolver.ArtifactNotFoundException {
        return this.resolveTransitively(artifacts, originatingArtifact, managedVersions, localRepository, remoteRepositories, source, filter, listeners, null);
    }

    public ArtifactResolutionResult resolveTransitively(Set<Artifact> artifacts, Artifact originatingArtifact, Map managedVersions, ArtifactRepository localRepository, List<ArtifactRepository> remoteRepositories, ArtifactMetadataSource source, ArtifactFilter filter, List<ResolutionListener> listeners, List<ConflictResolver> conflictResolvers) throws ArtifactResolutionException, org.apache.maven.artifact.resolver.ArtifactNotFoundException {
        ArtifactResolutionRequest request = new ArtifactResolutionRequest().setArtifact(originatingArtifact).setResolveRoot(false).setArtifactDependencies(artifacts).setManagedVersionMap(managedVersions).setLocalRepository(localRepository).setRemoteRepositories(remoteRepositories).setCollectionFilter(filter).setListeners(listeners);
        this.injectSession2(request, this.legacySupport.getSession());
        return this.resolveWithExceptions(request);
    }

    public ArtifactResolutionResult resolveWithExceptions(ArtifactResolutionRequest request) throws ArtifactResolutionException, org.apache.maven.artifact.resolver.ArtifactNotFoundException {
        ArtifactResolutionResult result = this.resolve(request);
        this.resolutionErrorHandler.throwErrors(request, result);
        return result;
    }

    public ArtifactResolutionResult resolve(ArtifactResolutionRequest request) {
        Artifact rootArtifact = request.getArtifact();
        LinkedHashSet artifacts = request.getArtifactDependencies();
        Map managedVersions = request.getManagedVersionMap();
        ArrayList<Object> listeners = request.getListeners();
        ArtifactFilter collectionFilter = request.getCollectionFilter();
        ArtifactFilter resolutionFilter = request.getResolutionFilter();
        RepositorySystemSession session = this.getSession(request.getLocalRepository());
        if (this.source == null) {
            try {
                this.source = (ArtifactMetadataSource)this.container.lookup(ArtifactMetadataSource.class);
            }
            catch (ComponentLookupException e) {
                // empty catch block
            }
        }
        if (listeners == null) {
            listeners = new ArrayList<Object>();
            if (this.logger.isDebugEnabled()) {
                listeners.add(new DebugResolutionListener(this.logger));
            }
            listeners.add(new WarningResolutionListener(this.logger));
        }
        ArtifactResolutionResult result = new ArtifactResolutionResult();
        if (request.isResolveRoot()) {
            try {
                this.resolve(rootArtifact, (List<ArtifactRepository>)request.getRemoteRepositories(), session);
            }
            catch (ArtifactResolutionException e) {
                result.addErrorArtifactException(e);
                return result;
            }
            catch (org.apache.maven.artifact.resolver.ArtifactNotFoundException e) {
                result.addMissingArtifact(request.getArtifact());
                return result;
            }
        }
        ArtifactResolutionRequest collectionRequest = request;
        if (request.isResolveTransitively()) {
            DefaultMetadataResolutionRequest metadataRequest = new DefaultMetadataResolutionRequest(request);
            metadataRequest.setArtifact(rootArtifact);
            metadataRequest.setResolveManagedVersions(managedVersions == null);
            try {
                ResolutionGroup resolutionGroup = this.source.retrieve((MetadataResolutionRequest)metadataRequest);
                if (managedVersions == null) {
                    managedVersions = resolutionGroup.getManagedVersions();
                }
                Set directArtifacts = resolutionGroup.getArtifacts();
                if (artifacts == null || artifacts.isEmpty()) {
                    artifacts = directArtifacts;
                } else {
                    ArrayList allArtifacts = new ArrayList();
                    allArtifacts.addAll(artifacts);
                    allArtifacts.addAll(directArtifacts);
                    LinkedHashMap<String, Artifact> mergedArtifacts = new LinkedHashMap<String, Artifact>();
                    for (Artifact artifact : allArtifacts) {
                        String conflictId = artifact.getDependencyConflictId();
                        if (mergedArtifacts.containsKey(conflictId)) continue;
                        mergedArtifacts.put(conflictId, artifact);
                    }
                    artifacts = new LinkedHashSet(mergedArtifacts.values());
                }
                collectionRequest = new ArtifactResolutionRequest((RepositoryRequest)request);
                collectionRequest.setServers(request.getServers());
                collectionRequest.setMirrors(request.getMirrors());
                collectionRequest.setProxies(request.getProxies());
                collectionRequest.setRemoteRepositories(resolutionGroup.getResolutionRepositories());
            }
            catch (ArtifactMetadataRetrievalException e) {
                ArtifactResolutionException are = new ArtifactResolutionException("Unable to get dependency information for " + rootArtifact.getId() + ": " + e.getMessage(), rootArtifact, metadataRequest.getRemoteRepositories(), (Throwable)e);
                result.addMetadataResolutionException(are);
                return result;
            }
        }
        if (artifacts == null || artifacts.isEmpty()) {
            if (request.isResolveRoot()) {
                result.addArtifact(rootArtifact);
            }
            return result;
        }
        result = this.artifactCollector.collect((Set)artifacts, rootArtifact, managedVersions, collectionRequest, this.source, collectionFilter, listeners, null);
        if (result.hasMetadataResolutionExceptions() || result.hasVersionRangeViolations() || result.hasCircularDependencyExceptions()) {
            return result;
        }
        if (result.getArtifactResolutionNodes() != null) {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            CountDownLatch latch = new CountDownLatch(result.getArtifactResolutionNodes().size());
            for (ResolutionNode node : result.getArtifactResolutionNodes()) {
                Artifact artifact = node.getArtifact();
                if (resolutionFilter == null || resolutionFilter.include(artifact)) {
                    this.executor.execute(new ResolveTask(classLoader, latch, artifact, session, node.getRemoteRepositories(), result));
                    continue;
                }
                latch.countDown();
            }
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                result.addErrorArtifactException(new ArtifactResolutionException("Resolution interrupted", rootArtifact, (Throwable)e));
            }
        }
        if (request.isResolveRoot()) {
            LinkedHashSet<Artifact> allArtifacts = new LinkedHashSet<Artifact>();
            allArtifacts.add(rootArtifact);
            allArtifacts.addAll(result.getArtifacts());
            result.setArtifacts(allArtifacts);
        }
        return result;
    }

    public void resolve(Artifact artifact, List<ArtifactRepository> remoteRepositories, ArtifactRepository localRepository) throws ArtifactResolutionException, org.apache.maven.artifact.resolver.ArtifactNotFoundException {
        this.resolve(artifact, remoteRepositories, localRepository, null);
    }

    public void customize(MavenWorkspaceMap workspaceMap, boolean failOnUnresolved) {
        this.myWorkspaceMap = workspaceMap;
        this.myUnresolvedCollector = new UnresolvedArtifactsCollector(failOnUnresolved);
    }

    public void reset() {
        this.myWorkspaceMap = null;
        this.myUnresolvedCollector = null;
    }

    public UnresolvedArtifactsCollector getUnresolvedCollector() {
        return this.myUnresolvedCollector;
    }

    private boolean resolveAsModule(Artifact a) {
        MavenWorkspaceMap map = this.myWorkspaceMap;
        if (map == null) {
            return false;
        }
        MavenWorkspaceMap.Data resolved = map.findFileAndOriginalId(MavenModelConverter.createMavenId(a));
        if (resolved == null) {
            return false;
        }
        a.setResolved(true);
        a.setFile(resolved.getFile(a.getType()));
        a.selectVersion(resolved.originalId.getVersion());
        return true;
    }

    private class ResolveTask
    implements Runnable {
        private final ClassLoader classLoader;
        private final CountDownLatch latch;
        private final Artifact artifact;
        private final RepositorySystemSession session;
        private final List<ArtifactRepository> remoteRepositories;
        private final ArtifactResolutionResult result;

        public ResolveTask(ClassLoader classLoader, CountDownLatch latch, Artifact artifact, RepositorySystemSession session, List<ArtifactRepository> remoteRepositories, ArtifactResolutionResult result) {
            this.classLoader = classLoader;
            this.latch = latch;
            this.artifact = artifact;
            this.session = session;
            this.remoteRepositories = remoteRepositories;
            this.result = result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Thread.currentThread().setContextClassLoader(this.classLoader);
                CustomMaven3ArtifactResolver.this.resolve(this.artifact, (List<ArtifactRepository>)this.remoteRepositories, this.session);
            }
            catch (org.apache.maven.artifact.resolver.ArtifactNotFoundException anfe) {
                ArtifactResolutionResult artifactResolutionResult = this.result;
                synchronized (artifactResolutionResult) {
                    this.result.addMissingArtifact(this.artifact);
                }
            }
            catch (ArtifactResolutionException e) {
                ArtifactResolutionResult artifactResolutionResult = this.result;
                synchronized (artifactResolutionResult) {
                    this.result.addErrorArtifactException(e);
                }
            }
            finally {
                this.latch.countDown();
            }
        }
    }

    static final class DaemonThreadCreator
    implements ThreadFactory {
        static final String THREADGROUP_NAME = "org.apache.maven.artifact.resolver.DefaultArtifactResolver";
        static final ThreadGroup group = new ThreadGroup("org.apache.maven.artifact.resolver.DefaultArtifactResolver");
        static final AtomicInteger threadNumber = new AtomicInteger(1);

        DaemonThreadCreator() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread newThread = new Thread(group, r, "resolver-" + threadNumber.getAndIncrement());
            newThread.setDaemon(true);
            return newThread;
        }
    }
}

