/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.png;

import com.android.annotations.NonNull;
import com.android.builder.png.AaptProcess;
import com.android.builder.tasks.Job;
import com.android.builder.tasks.JobContext;
import com.android.builder.tasks.QueueThreadContext;
import com.android.builder.tasks.Task;
import com.android.builder.tasks.WorkQueue;
import com.android.ide.common.internal.PngCruncher;
import com.android.ide.common.internal.PngException;
import com.android.utils.ILogger;
import com.google.common.base.Objects;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;

public class QueuedCruncher
implements PngCruncher {
    @NonNull
    private final String mAaptLocation;
    @NonNull
    private final ILogger mLogger;
    @NonNull
    private final WorkQueue<AaptProcess> mCrunchingRequests;
    @NonNull
    private final Map<Integer, ConcurrentLinkedQueue<Job<AaptProcess>>> mOutstandingJobs = new ConcurrentHashMap<Integer, ConcurrentLinkedQueue<Job<AaptProcess>>>();
    @NonNull
    private final AtomicInteger refCount = new AtomicInteger(0);
    @NonNull
    private final AtomicInteger keyProvider = new AtomicInteger(0);

    private QueuedCruncher(@NonNull String aaptLocation, @NonNull ILogger iLogger) {
        this.mAaptLocation = aaptLocation;
        this.mLogger = iLogger;
        QueueThreadContext<AaptProcess> queueThreadContext = new QueueThreadContext<AaptProcess>(){
            @NonNull
            private final Map<String, AaptProcess> mAaptProcesses = new ConcurrentHashMap<String, AaptProcess>();

            @Override
            public void creation(@NonNull Thread t) throws IOException {
                try {
                    QueuedCruncher.this.mLogger.verbose("Thread(%1$s): create aapt slave", new Object[]{Thread.currentThread().getName()});
                    AaptProcess aaptProcess = new AaptProcess.Builder(QueuedCruncher.this.mAaptLocation, QueuedCruncher.this.mLogger).start();
                    assert (aaptProcess != null);
                    aaptProcess.waitForReady();
                    this.mAaptProcesses.put(t.getName(), aaptProcess);
                }
                catch (InterruptedException e) {
                    QueuedCruncher.this.mLogger.error((Throwable)e, "Cannot start slave process", new Object[0]);
                    e.printStackTrace();
                }
            }

            @Override
            public void runTask(@NonNull Job<AaptProcess> job) throws Exception {
                job.runTask(new JobContext<AaptProcess>(this.mAaptProcesses.get(Thread.currentThread().getName())));
                ((ConcurrentLinkedQueue)QueuedCruncher.this.mOutstandingJobs.get(((QueuedJob)job).key)).remove(job);
            }

            @Override
            public void destruction(@NonNull Thread t) throws IOException, InterruptedException {
                AaptProcess aaptProcess = this.mAaptProcesses.get(Thread.currentThread().getName());
                if (aaptProcess != null) {
                    QueuedCruncher.this.mLogger.verbose("Thread(%1$s): notify aapt slave shutdown", new Object[]{Thread.currentThread().getName()});
                    aaptProcess.shutdown();
                    this.mAaptProcesses.remove(t.getName());
                    QueuedCruncher.this.mLogger.verbose("Thread(%1$s): after shutdown queue_size=%2$d", new Object[]{Thread.currentThread().getName(), this.mAaptProcesses.size()});
                }
            }

            @Override
            public void shutdown() {
                if (!this.mAaptProcesses.isEmpty()) {
                    QueuedCruncher.this.mLogger.warning("Process list not empty", new Object[0]);
                    for (Map.Entry<String, AaptProcess> aaptProcessEntry : this.mAaptProcesses.entrySet()) {
                        QueuedCruncher.this.mLogger.warning("Thread(%1$s): queue not cleaned", new Object[]{aaptProcessEntry.getKey()});
                        try {
                            aaptProcessEntry.getValue().shutdown();
                        }
                        catch (Exception e) {
                            QueuedCruncher.this.mLogger.error((Throwable)e, "while shutting down" + aaptProcessEntry.getKey(), new Object[0]);
                        }
                    }
                }
                this.mAaptProcesses.clear();
            }
        };
        this.mCrunchingRequests = new WorkQueue<AaptProcess>(this.mLogger, queueThreadContext, "png-cruncher", 5, 2.0f);
    }

    public void crunchPng(int key, final @NonNull File from, final @NonNull File to) throws PngException {
        try {
            QueuedJob aaptProcessJob = new QueuedJob(key, "Cruncher " + from.getName(), new Task<AaptProcess>(){

                @Override
                public void run(@NonNull Job<AaptProcess> job, @NonNull JobContext<AaptProcess> context) throws IOException {
                    QueuedCruncher.this.mLogger.verbose("Thread(%1$s): begin executing job %2$s", new Object[]{Thread.currentThread().getName(), job.getJobTitle()});
                    context.getPayload().crunch(from, to, job);
                    QueuedCruncher.this.mLogger.verbose("Thread(%1$s): done executing job %2$s", new Object[]{Thread.currentThread().getName(), job.getJobTitle()});
                }

                public String toString() {
                    return Objects.toStringHelper((Object)this).add("from", (Object)from.getAbsolutePath()).add("to", (Object)to.getAbsolutePath()).toString();
                }
            });
            this.mOutstandingJobs.get(key).add(aaptProcessJob);
            this.mCrunchingRequests.push(aaptProcessJob);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PngException((Throwable)e);
        }
    }

    private void waitForAll(int key) throws InterruptedException {
        this.mLogger.verbose("Thread(%1$s): begin waitForAll", new Object[]{Thread.currentThread().getName()});
        ConcurrentLinkedQueue<Job<AaptProcess>> jobs = this.mOutstandingJobs.get(key);
        Job<AaptProcess> aaptProcessJob = jobs.poll();
        while (aaptProcessJob != null) {
            this.mLogger.verbose("Thread(%1$s) : wait for {%2$s)", new Object[]{Thread.currentThread().getName(), aaptProcessJob.toString()});
            if (!aaptProcessJob.await()) {
                throw new RuntimeException("Crunching " + aaptProcessJob.getJobTitle() + " failed, see logs");
            }
            aaptProcessJob = jobs.poll();
        }
        this.mLogger.verbose("Thread(%1$s): end waitForAll", new Object[]{Thread.currentThread().getName()});
    }

    public synchronized int start() {
        this.refCount.incrementAndGet();
        int key = this.keyProvider.incrementAndGet();
        this.mOutstandingJobs.put(key, new ConcurrentLinkedQueue());
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void end(int key) throws InterruptedException {
        long startTime = System.currentTimeMillis();
        try {
            this.waitForAll(key);
            this.mOutstandingJobs.get(key).clear();
            this.mLogger.verbose("Job finished in %1$d", new Object[]{System.currentTimeMillis() - startTime});
            if (this.refCount.decrementAndGet() != 0) return;
        }
        catch (Throwable throwable) {
            if (this.refCount.decrementAndGet() != 0) throw throwable;
            this.mCrunchingRequests.shutdown();
            this.mLogger.verbose("Shutdown finished in %1$d", new Object[]{System.currentTimeMillis() - startTime});
            throw throwable;
        }
        this.mCrunchingRequests.shutdown();
        this.mLogger.verbose("Shutdown finished in %1$d", new Object[]{System.currentTimeMillis() - startTime});
    }

    private static final class QueuedJob
    extends Job<AaptProcess> {
        private final int key;

        public QueuedJob(int key, String jobTile, Task<AaptProcess> task) {
            super(jobTile, task);
            this.key = key;
        }
    }

    public static enum Builder {
        INSTANCE;

        private final Map<String, QueuedCruncher> sInstances = new ConcurrentHashMap<String, QueuedCruncher>();
        private final Object sLock = new Object();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public QueuedCruncher newCruncher(@NonNull String aaptLocation, @NonNull ILogger logger) {
            Object object = this.sLock;
            synchronized (object) {
                logger.info("QueuedCruncher is using %1$s", new Object[]{aaptLocation});
                if (!this.sInstances.containsKey(aaptLocation)) {
                    QueuedCruncher queuedCruncher = new QueuedCruncher(aaptLocation, logger);
                    this.sInstances.put(aaptLocation, queuedCruncher);
                }
                return this.sInstances.get(aaptLocation);
            }
        }
    }
}

