/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal.packaging;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.builder.internal.packaging.JavaResourceProcessor;
import com.android.builder.model.PackagingOptions;
import com.android.builder.packaging.DuplicateFileException;
import com.android.builder.packaging.PackagerException;
import com.android.builder.packaging.SealedPackageException;
import com.android.builder.signing.SignedJarBuilder;
import com.android.ide.common.packaging.PackagingUtils;
import com.android.ide.common.signing.CertificateInfo;
import com.android.utils.FileUtils;
import com.android.utils.ILogger;
import com.google.common.base.Predicate;
import com.google.common.collect.Sets;
import com.google.common.io.Closeables;
import com.google.common.io.Files;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.regex.Pattern;

public final class Packager
implements JavaResourceProcessor.IArchiveBuilder {
    private static final Pattern PATTERN_NATIVELIB_EXT = Pattern.compile("^.+\\.so$", 2);
    private SignedJarBuilder mBuilder = null;
    private final ILogger mLogger;
    private boolean mJniDebugMode = false;
    private boolean mIsSealed = false;
    private final FileFilter mFileFilter;
    private final NullZipFilter mNullFilter = new NullZipFilter();
    private final JavaAndNativeResourceFilter mJarFilter;
    private final HashMap<String, File> mAddedFiles = new HashMap();
    private final HashMap<String, File> mMergeFiles = new HashMap();

    public Packager(@NonNull String apkLocation, @NonNull String resLocation, @NonNull File mergingFolder, CertificateInfo certificateInfo, @Nullable String createdBy, @Nullable PackagingOptions packagingOptions, ILogger logger) throws PackagerException {
        this.mFileFilter = new FileFilter(packagingOptions);
        this.mJarFilter = new JavaAndNativeResourceFilter(this.mFileFilter);
        try {
            File apkFile = new File(apkLocation);
            this.checkOutputFile(apkFile);
            File resFile = new File(resLocation);
            Packager.checkInputFile(resFile);
            Packager.checkMergingFolder(mergingFolder);
            if (packagingOptions != null) {
                for (String merge : packagingOptions.getMerges()) {
                    this.mMergeFiles.put(merge, new File(mergingFolder, merge));
                }
            }
            this.mLogger = logger;
            this.mBuilder = new SignedJarBuilder(new FileOutputStream(apkFile, false), certificateInfo != null ? certificateInfo.getKey() : null, certificateInfo != null ? certificateInfo.getCertificate() : null, Packager.getLocalVersion(), createdBy);
            this.mLogger.verbose("Packaging %s", new Object[]{apkFile.getName()});
            this.addZipFile(resFile);
        }
        catch (PackagerException e) {
            if (this.mBuilder != null) {
                this.mBuilder.cleanUp();
            }
            throw e;
        }
        catch (Exception e) {
            if (this.mBuilder != null) {
                this.mBuilder.cleanUp();
            }
            throw new PackagerException(e);
        }
    }

    public void addDexFiles(@NonNull File mainDexFolder, @NonNull Collection<File> extraDexFiles) throws DuplicateFileException, SealedPackageException, PackagerException {
        File[] mainDexFiles = mainDexFolder.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File file, String name) {
                return name.endsWith(".dex");
            }
        });
        if (mainDexFiles != null && mainDexFiles.length > 0) {
            for (File dexFile : mainDexFiles) {
                this.addFile(dexFile, dexFile.getName());
            }
            int dexIndex = mainDexFiles.length + 1;
            for (File dexFile : extraDexFiles) {
                this.addFile(dexFile, String.format("classes%d.dex", dexIndex++));
            }
        }
    }

    public void setJniDebugMode(boolean jniDebugMode) {
        this.mJniDebugMode = jniDebugMode;
    }

    @Override
    public void addFile(File file, String archivePath) throws PackagerException, SealedPackageException, DuplicateFileException {
        if (this.mIsSealed) {
            throw new SealedPackageException("APK is already sealed", new Object[0]);
        }
        try {
            this.doAddFile(file, archivePath);
        }
        catch (DuplicateFileException e) {
            this.mBuilder.cleanUp();
            throw e;
        }
        catch (Exception e) {
            this.mBuilder.cleanUp();
            throw new PackagerException(e, "Failed to add %s", file);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void addZipFile(File zipFile) throws PackagerException, SealedPackageException, DuplicateFileException {
        if (this.mIsSealed) {
            throw new SealedPackageException("APK is already sealed", new Object[0]);
        }
        FileInputStream fis = null;
        try {
            this.mLogger.verbose("%s:", new Object[]{zipFile});
            this.mNullFilter.reset(zipFile);
            fis = new FileInputStream(zipFile);
            this.mBuilder.writeZip(fis, this.mNullFilter, new MergeEntryExtractor());
        }
        catch (DuplicateFileException e) {
            try {
                this.mBuilder.cleanUp();
                throw e;
                catch (Exception e2) {
                    this.mBuilder.cleanUp();
                    throw new PackagerException(e2, "Failed to add %s", zipFile);
                }
            }
            catch (Throwable throwable) {
                try {
                    Closeables.close(fis, (boolean)true);
                    throw throwable;
                }
                catch (IOException e3) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        try {
            Closeables.close((Closeable)fis, (boolean)true);
            return;
        }
        catch (IOException e) {
            return;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JarStatus addResourcesFromJar(File jarFile) throws PackagerException, SealedPackageException, DuplicateFileException {
        JarStatusImpl jarStatusImpl;
        if (this.mIsSealed) {
            throw new SealedPackageException("APK is already sealed", new Object[0]);
        }
        FileInputStream fis = null;
        try {
            this.mLogger.verbose("%s:", new Object[]{jarFile});
            this.mJarFilter.reset(jarFile);
            fis = new FileInputStream(jarFile);
            this.mBuilder.writeZip(fis, this.mJarFilter, new MergeEntryExtractor());
            jarStatusImpl = new JarStatusImpl(this.mJarFilter.getNativeLibs(), this.mJarFilter.getNativeLibsConflict());
        }
        catch (DuplicateFileException e) {
            try {
                this.mBuilder.cleanUp();
                throw e;
                catch (Exception e2) {
                    this.mBuilder.cleanUp();
                    throw new PackagerException(e2, "Failed to add %s", jarFile);
                }
            }
            catch (Throwable throwable) {
                try {
                    Closeables.close(fis, (boolean)true);
                    throw throwable;
                }
                catch (IOException e3) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        try {
            Closeables.close((Closeable)fis, (boolean)true);
            return jarStatusImpl;
        }
        catch (IOException e) {
            // empty catch block
        }
        return jarStatusImpl;
    }

    public void addNativeLibraries(@NonNull File nativeFolder, @Nullable Set<String> abiFilters) throws PackagerException, SealedPackageException, DuplicateFileException {
        if (this.mIsSealed) {
            throw new SealedPackageException("APK is already sealed", new Object[0]);
        }
        if (!nativeFolder.isDirectory()) {
            if (nativeFolder.exists()) {
                throw new PackagerException("%s is not a folder", nativeFolder);
            }
            throw new PackagerException("%s does not exist", nativeFolder);
        }
        File[] abiList = nativeFolder.listFiles();
        this.mLogger.verbose("Native folder: %s", new Object[]{nativeFolder});
        if (abiList != null) {
            for (File abi : abiList) {
                File[] libs;
                if (abiFilters != null && !abiFilters.isEmpty() && !abiFilters.contains(abi.getName()) || !abi.isDirectory() || (libs = abi.listFiles()) == null) continue;
                for (File lib : libs) {
                    String libName = lib.getName();
                    if (!lib.isFile() || !PATTERN_NATIVELIB_EXT.matcher(lib.getName()).matches() && (!this.mJniDebugMode || !"gdbserver".equals(libName) && !"gdb.setup".equals(libName))) continue;
                    String path = "lib/" + abi.getName() + "/" + libName;
                    try {
                        this.doAddFile(lib, path);
                    }
                    catch (IOException e) {
                        this.mBuilder.cleanUp();
                        throw new PackagerException(e, "Failed to add %s", lib);
                    }
                }
            }
        }
    }

    public void sealApk() throws PackagerException, SealedPackageException {
        if (this.mIsSealed) {
            throw new SealedPackageException("APK is already sealed", new Object[0]);
        }
        for (Map.Entry<String, File> entry : this.mMergeFiles.entrySet()) {
            File inputFile = entry.getValue();
            String archivePath = entry.getKey();
            try {
                if (!inputFile.exists()) continue;
                this.mBuilder.writeFile(inputFile, archivePath);
            }
            catch (IOException e) {
                this.mBuilder.cleanUp();
                throw new PackagerException(e, "Failed to add merged file %s", inputFile);
            }
        }
        try {
            this.mBuilder.close();
            this.mIsSealed = true;
        }
        catch (Exception e) {
            throw new PackagerException(e, "Failed to seal APK", new Object[0]);
        }
        finally {
            this.mBuilder.cleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAddFile(File file, String archivePath) throws DuplicateFileException, IOException {
        if (!this.mFileFilter.apply(archivePath)) {
            return;
        }
        this.mLogger.verbose("%1$s => %2$s", new Object[]{file, archivePath});
        if (!this.mMergeFiles.keySet().contains(archivePath)) {
            File duplicate = this.checkFileForDuplicate(archivePath);
            if (duplicate != null) {
                throw new DuplicateFileException(archivePath, duplicate, file);
            }
        } else {
            File mergingFile = this.mMergeFiles.get(archivePath);
            if (!mergingFile.getParentFile().exists()) {
                mergingFile.getParentFile().mkdirs();
            }
            FileOutputStream fos = new FileOutputStream(this.mMergeFiles.get(archivePath), true);
            try {
                fos.write(Files.toByteArray((File)file));
            }
            finally {
                fos.close();
            }
            return;
        }
        this.mAddedFiles.put(archivePath, file);
        this.mBuilder.writeFile(file, archivePath);
    }

    private File checkFileForDuplicate(String archivePath) {
        return this.mAddedFiles.get(archivePath);
    }

    private void checkOutputFile(File file) throws PackagerException {
        if (file.isDirectory()) {
            throw new PackagerException("%s is a directory!", file);
        }
        if (file.exists()) {
            if (!file.canWrite()) {
                throw new PackagerException("Cannot write %s", file);
            }
        } else {
            try {
                if (!file.createNewFile()) {
                    throw new PackagerException("Failed to create %s", file);
                }
            }
            catch (IOException e) {
                throw new PackagerException("Failed to create '%1$ss': %2$s", file, e.getMessage());
            }
        }
    }

    private static void checkMergingFolder(File file) throws PackagerException {
        if (file.isFile()) {
            throw new PackagerException("%s is a file!", file);
        }
        if (file.exists()) {
            if (!file.canWrite()) {
                throw new PackagerException("Cannot write %s", file);
            }
            FileUtils.deleteFolder((File)file);
        }
        if (!file.mkdirs()) {
            throw new PackagerException("Failed to create %s", file);
        }
    }

    private static void checkInputFile(File file) throws FileNotFoundException, PackagerException {
        if (file.isDirectory()) {
            throw new PackagerException("%s is a directory!", file);
        }
        if (file.exists()) {
            if (!file.canRead()) {
                throw new PackagerException("Cannot read %s", file);
            }
        } else {
            throw new FileNotFoundException(String.format("%s does not exist", file));
        }
    }

    public static String getLocalVersion() {
        Class<Packager> clazz = Packager.class;
        String className = clazz.getSimpleName() + ".class";
        String classPath = clazz.getResource(className).toString();
        if (!classPath.startsWith("jar")) {
            return null;
        }
        try {
            String manifestPath = classPath.substring(0, classPath.lastIndexOf(33) + 1) + "/META-INF/MANIFEST.MF";
            URLConnection jarConnection = new URL(manifestPath).openConnection();
            jarConnection.setUseCaches(false);
            InputStream jarInputStream = jarConnection.getInputStream();
            Attributes attr = new Manifest(jarInputStream).getMainAttributes();
            jarInputStream.close();
            return attr.getValue("Builder-Version");
        }
        catch (MalformedURLException ignored) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private static final class JarStatusImpl
    implements JarStatus {
        public final List<String> mLibs;
        public final boolean mNativeLibsConflict;

        private JarStatusImpl(List<String> libs, boolean nativeLibsConflict) {
            this.mLibs = libs;
            this.mNativeLibsConflict = nativeLibsConflict;
        }

        @Override
        public List<String> getNativeLibs() {
            return this.mLibs;
        }

        @Override
        public boolean hasNativeLibsConflicts() {
            return this.mNativeLibsConflict;
        }
    }

    public static interface JarStatus {
        public List<String> getNativeLibs();

        public boolean hasNativeLibsConflicts();
    }

    private class MergeEntryExtractor
    implements SignedJarBuilder.ZipEntryExtractor {
        private MergeEntryExtractor() {
        }

        @Override
        public boolean checkEntry(String archivePath) {
            return Packager.this.mMergeFiles.containsKey(archivePath);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void extract(String archivePath, InputStream zis) throws IOException {
            FileOutputStream fos = new FileOutputStream((File)Packager.this.mMergeFiles.get(archivePath), true);
            try {
                int count;
                byte[] buffer = new byte[4096];
                while ((count = zis.read(buffer)) != -1) {
                    fos.write(buffer, 0, count);
                }
            }
            finally {
                fos.close();
            }
        }
    }

    private final class JavaAndNativeResourceFilter
    implements SignedJarBuilder.IZipEntryFilter {
        private final List<String> mNativeLibs = new ArrayList<String>();
        private boolean mNativeLibsConflict = false;
        private File mInputFile;
        private FileFilter mFilter;

        private JavaAndNativeResourceFilter(FileFilter filter) {
            this.mFilter = filter;
        }

        @Override
        public boolean checkEntry(String archivePath) throws SignedJarBuilder.IZipEntryFilter.ZipAbortException {
            String[] segments = archivePath.split("/");
            if (segments.length == 0) {
                return false;
            }
            if (!this.mFilter.apply(archivePath)) {
                return false;
            }
            for (int i = 0; i < segments.length - 1; ++i) {
                if (PackagingUtils.checkFolderForPackaging((String)segments[i])) continue;
                return false;
            }
            String fileName = segments[segments.length - 1];
            boolean check = PackagingUtils.checkFileForPackaging((String)fileName);
            if (check) {
                Packager.this.mLogger.verbose("=> %s", new Object[]{archivePath});
                if (!Packager.this.mMergeFiles.keySet().contains(archivePath)) {
                    File duplicate = Packager.this.checkFileForDuplicate(archivePath);
                    if (duplicate != null) {
                        throw new DuplicateFileException(archivePath, duplicate, this.mInputFile);
                    }
                    Packager.this.mAddedFiles.put(archivePath, this.mInputFile);
                }
                if (archivePath.endsWith(".so")) {
                    this.mNativeLibs.add(archivePath);
                    if (archivePath.startsWith("lib/")) {
                        this.mNativeLibsConflict = true;
                    }
                } else if (archivePath.endsWith(".jnilib")) {
                    this.mNativeLibs.add(archivePath);
                }
            }
            return check;
        }

        List<String> getNativeLibs() {
            return this.mNativeLibs;
        }

        boolean getNativeLibsConflict() {
            return this.mNativeLibsConflict;
        }

        void reset(File inputFile) {
            this.mInputFile = inputFile;
            this.mNativeLibs.clear();
            this.mNativeLibsConflict = false;
        }
    }

    private static final class FileFilter
    implements Predicate<String> {
        @Nullable
        private final PackagingOptions mPackagingOptions;
        @NonNull
        private final Set<String> mExcludes;
        @NonNull
        private final Set<String> mPickFirsts;
        private Set<String> mUsedPickFirsts = null;

        public FileFilter(@Nullable PackagingOptions packagingOptions) {
            this.mPackagingOptions = packagingOptions;
            this.mExcludes = this.mPackagingOptions != null ? this.mPackagingOptions.getExcludes() : Collections.emptySet();
            this.mPickFirsts = this.mPackagingOptions != null ? this.mPackagingOptions.getPickFirsts() : Collections.emptySet();
        }

        public boolean apply(@Nullable String input) {
            if (this.mPackagingOptions != null) {
                if (this.mExcludes.contains(input)) {
                    return false;
                }
                if (this.mPickFirsts.contains(input)) {
                    if (this.mUsedPickFirsts == null) {
                        this.mUsedPickFirsts = Sets.newHashSetWithExpectedSize((int)this.mPickFirsts.size());
                    }
                    if (this.mUsedPickFirsts.contains(input)) {
                        return false;
                    }
                    this.mUsedPickFirsts.add(input);
                }
            }
            return true;
        }
    }

    private final class NullZipFilter
    implements SignedJarBuilder.IZipEntryFilter {
        private File mInputFile;

        private NullZipFilter() {
        }

        void reset(File inputFile) {
            this.mInputFile = inputFile;
        }

        @Override
        public boolean checkEntry(String archivePath) throws SignedJarBuilder.IZipEntryFilter.ZipAbortException {
            Packager.this.mLogger.verbose("=> %s", new Object[]{archivePath});
            File duplicate = Packager.this.checkFileForDuplicate(archivePath);
            if (duplicate != null) {
                throw new DuplicateFileException(archivePath, duplicate, this.mInputFile);
            }
            Packager.this.mAddedFiles.put(archivePath, this.mInputFile);
            return true;
        }
    }
}

