/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.png;

import com.android.annotations.NonNull;
import com.android.ide.common.resources.configuration.DensityQualifier;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.VersionQualifier;
import com.android.resources.Density;
import com.android.resources.ResourceFolderType;
import com.android.utils.FileUtils;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;

public class VectorDrawableRenderer {
    public static final int MIN_SDK_WITH_VECTOR_SUPPORT = 21;

    public Collection<File> createPngFiles(@NonNull File inputXmlFile, @NonNull File outputResDirectory, @NonNull Collection<Density> densities) throws IOException {
        Preconditions.checkArgument((boolean)inputXmlFile.exists());
        Preconditions.checkArgument((boolean)outputResDirectory.exists());
        Preconditions.checkArgument((boolean)this.isInDrawable(inputXmlFile), (String)"XML file is not in a 'drawable-*' folder, [%s].", (Object[])new Object[]{inputXmlFile});
        FolderConfiguration originalConfiguration = this.getFolderConfiguration(inputXmlFile);
        ArrayList createdFiles = Lists.newArrayList();
        for (Density density : densities) {
            FolderConfiguration newConfiguration = FolderConfiguration.copyOf((FolderConfiguration)originalConfiguration);
            newConfiguration.setDensityQualifier(new DensityQualifier(density));
            File directory = new File(outputResDirectory, newConfiguration.getFolderName(ResourceFolderType.DRAWABLE));
            File pngFile = new File(directory, inputXmlFile.getName().replace(".xml", ".png"));
            Files.createParentDirs((File)pngFile);
            Files.write((CharSequence)String.format("%s in %s, %s%n", inputXmlFile.getName(), density.getResourceValue(), FileUtils.sha1((File)inputXmlFile)), (File)pngFile, (Charset)Charsets.UTF_8);
            createdFiles.add(pngFile);
            newConfiguration.setVersionQualifier(new VersionQualifier(21));
            File xmlCopy = this.copyOriginalXml(inputXmlFile, outputResDirectory, newConfiguration);
            createdFiles.add(xmlCopy);
        }
        return createdFiles;
    }

    @NonNull
    private File copyOriginalXml(@NonNull File inputXmlFile, @NonNull File outputResDirectory, FolderConfiguration newConfiguration) throws IOException {
        File destination = new File(outputResDirectory, newConfiguration.getFolderName(ResourceFolderType.DRAWABLE));
        File copy = new File(destination, inputXmlFile.getName());
        Files.createParentDirs((File)copy);
        Files.copy((File)inputXmlFile, (File)copy);
        return copy;
    }

    @NonNull
    private FolderConfiguration getFolderConfiguration(@NonNull File inputXmlFile) {
        String parentName = inputXmlFile.getParentFile().getName();
        FolderConfiguration originalConfiguration = FolderConfiguration.getConfigForFolder((String)parentName);
        Preconditions.checkArgument((originalConfiguration != null ? 1 : 0) != 0, (String)"Invalid resource folder name [%s].", (Object[])new Object[]{parentName});
        return originalConfiguration;
    }

    private boolean isInDrawable(@NonNull File inputXmlFile) {
        ResourceFolderType folderType = ResourceFolderType.getFolderType((String)inputXmlFile.getParentFile().getName());
        return folderType == ResourceFolderType.DRAWABLE;
    }

    public boolean needsPreprocessing(File resourceFile) {
        return resourceFile.getPath().endsWith(".xml") && this.isInDrawable(resourceFile) && this.getEffectiveVersion(resourceFile) < 21;
    }

    private int getEffectiveVersion(File resourceFile) {
        FolderConfiguration configuration = this.getFolderConfiguration(resourceFile);
        configuration.createDefault();
        return configuration.getVersionQualifier().getVersion();
    }
}

