/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.testing;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.builder.internal.InstallUtils;
import com.android.builder.internal.testing.CustomTestRunListener;
import com.android.builder.internal.testing.SimpleTestCallable;
import com.android.builder.testing.TestData;
import com.android.builder.testing.TestRunner;
import com.android.builder.testing.api.DeviceConfigProvider;
import com.android.builder.testing.api.DeviceConfigProviderImpl;
import com.android.builder.testing.api.DeviceConnector;
import com.android.builder.testing.api.DeviceException;
import com.android.builder.testing.api.TestException;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.testrunner.TestIdentifier;
import com.android.ide.common.internal.WaitableExecutor;
import com.android.ide.common.process.ProcessException;
import com.android.ide.common.process.ProcessExecutor;
import com.android.utils.ILogger;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;

public class SimpleTestRunner
implements TestRunner {
    @NonNull
    private final File mAdbExec;
    @Nullable
    private final File mSplitSelectExec;
    @NonNull
    private final ProcessExecutor mProcessExecutor;

    public SimpleTestRunner(@NonNull File adbExec, @Nullable File splitSelectExec, @NonNull ProcessExecutor processExecutor) {
        this.mAdbExec = adbExec;
        this.mSplitSelectExec = splitSelectExec;
        this.mProcessExecutor = processExecutor;
    }

    @Override
    public boolean runTests(@NonNull String projectName, @NonNull String variantName, @NonNull File testApk, @NonNull TestData testData, @NonNull List<? extends DeviceConnector> deviceList, int maxThreads, int timeoutInMs, @NonNull Collection<String> installOptions, @NonNull File resultsDir, @NonNull File coverageDir, @NonNull ILogger logger) throws TestException, TestRunner.NoAuthorizedDeviceFoundException, InterruptedException {
        int n;
        TestIdentifier fakeTest;
        CustomTestRunListener fakeRunListener;
        WaitableExecutor executor = new WaitableExecutor(maxThreads);
        int totalDevices = deviceList.size();
        int unauthorizedDevices = 0;
        int compatibleDevices = 0;
        for (DeviceConnector deviceConnector : deviceList) {
            if (deviceConnector.getState() != IDevice.DeviceState.UNAUTHORIZED) {
                DeviceConfigProviderImpl deviceConfigProvider;
                if (!InstallUtils.checkDeviceApiLevel(deviceConnector, testData.getMinSdkVersion(), logger, projectName, variantName)) continue;
                try {
                    deviceConfigProvider = new DeviceConfigProviderImpl(deviceConnector);
                }
                catch (DeviceException e) {
                    throw new TestException((Throwable)e);
                }
                ImmutableList<File> testedApks = ImmutableList.of();
                if (!testData.isLibrary()) {
                    try {
                        testedApks = testData.getTestedApks(this.mProcessExecutor, this.mSplitSelectExec, (DeviceConfigProvider)deviceConfigProvider, logger);
                    }
                    catch (ProcessException e) {
                        throw new TestException((Throwable)e);
                    }
                    if (testedApks.isEmpty()) {
                        logger.info("Skipping device '%1$s' for '%2$s:%3$s': No matching output file", new Object[]{deviceConnector.getName(), projectName, variantName});
                        continue;
                    }
                }
                ++compatibleDevices;
                executor.execute((Callable)new SimpleTestCallable(deviceConnector, projectName, variantName, testApk, (List<File>)testedApks, this.mAdbExec, testData, resultsDir, coverageDir, timeoutInMs, installOptions, logger));
                continue;
            }
            ++unauthorizedDevices;
        }
        if (totalDevices == 0 || compatibleDevices == 0) {
            fakeRunListener = new CustomTestRunListener("TestRunner", projectName, variantName, logger);
            fakeRunListener.setReportDir(resultsDir);
            Map<String, String> map = Collections.emptyMap();
            fakeTest = new TestIdentifier(variantName, totalDevices == 0 ? ": No devices connected." : ": No compatible devices connected.");
            fakeRunListener.testStarted(fakeTest);
            fakeRunListener.testFailed(fakeTest, String.format("Found %d connected device(s), %d of which were compatible.", totalDevices, compatibleDevices));
            fakeRunListener.testEnded(fakeTest, map);
            fakeRunListener.testRunEnded(0L, map);
            return false;
        }
        if (unauthorizedDevices > 0) {
            fakeRunListener = new CustomTestRunListener("TestRunner", projectName, variantName, logger);
            fakeRunListener.setReportDir(resultsDir);
            Map<String, String> map = Collections.emptyMap();
            fakeTest = new TestIdentifier(variantName, ": found unauthorized devices.");
            fakeRunListener.testStarted(fakeTest);
            fakeRunListener.testFailed(fakeTest, String.format("Found %d unauthorized device(s).", unauthorizedDevices));
            fakeRunListener.testEnded(fakeTest, map);
            fakeRunListener.testRunEnded(0L, map);
        }
        List results = executor.waitForAllTasks();
        boolean bl = unauthorizedDevices == 0;
        for (WaitableExecutor.TaskResult result : results) {
            if (result.value != null) {
                n &= ((Boolean)result.value).booleanValue();
                continue;
            }
            n = 0;
            logger.error(result.exception, null, new Object[0]);
        }
        return n != 0;
    }
}

