/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.jps.model.impl;

import com.android.tools.idea.jps.AndroidGradleJps;
import com.android.tools.idea.jps.model.JpsAndroidGradleModuleExtension;
import com.android.tools.idea.jps.model.impl.JpsAndroidGradleModuleExtensionImpl;
import com.android.tools.idea.jps.model.impl.JpsAndroidGradleModuleProperties;
import com.google.common.collect.ImmutableList;
import com.intellij.util.xmlb.XmlSerializer;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.jps.android.model.JpsAndroidSdkProperties;
import org.jetbrains.jps.android.model.JpsAndroidSdkType;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsElementFactory;
import org.jetbrains.jps.model.JpsSimpleElement;
import org.jetbrains.jps.model.library.sdk.JpsSdkType;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.serialization.JpsModelSerializerExtension;
import org.jetbrains.jps.model.serialization.facet.JpsFacetConfigurationSerializer;
import org.jetbrains.jps.model.serialization.library.JpsSdkPropertiesSerializer;

public class JpsAndroidGradleModelSerializerExtension
extends JpsModelSerializerExtension {
    private static final List<? extends JpsFacetConfigurationSerializer<JpsAndroidGradleModuleExtension>> FACET_PROPERTY_LOADERS = ImmutableList.of((Object)((Object)new JpsAndroidGradleFacetConfigurationSerializer()));
    private static final JpsAndroidSdkPropertiesSerializer SDK_PROPERTY_LOADER = new JpsAndroidSdkPropertiesSerializer();
    private static final String EXTERNAL_SYSTEM_ID_ATTRIBUTE = "external.system.id";
    private static final String GRADLE_EXTERNAL_SYSTEM_ID = "GRADLE";

    public List<? extends JpsFacetConfigurationSerializer<?>> getFacetConfigurationSerializers() {
        return FACET_PROPERTY_LOADERS;
    }

    public void loadModuleOptions(JpsModule module, Element rootElement) {
        String externalSystemId = rootElement.getAttributeValue(EXTERNAL_SYSTEM_ID_ATTRIBUTE);
        if (GRADLE_EXTERNAL_SYSTEM_ID.equals(externalSystemId)) {
            AndroidGradleJps.getOrCreateGradleSystemExtension(module);
        }
    }

    public void saveModuleOptions(JpsModule module, Element rootElement) {
        if (AndroidGradleJps.getGradleSystemExtension(module) != null) {
            rootElement.setAttribute(EXTERNAL_SYSTEM_ID_ATTRIBUTE, GRADLE_EXTERNAL_SYSTEM_ID);
        }
    }

    public List<? extends JpsSdkPropertiesSerializer<?>> getSdkPropertiesSerializers() {
        return ImmutableList.of((Object)((Object)SDK_PROPERTY_LOADER));
    }

    private static class JpsAndroidSdkPropertiesSerializer
    extends JpsSdkPropertiesSerializer<JpsSimpleElement<JpsAndroidSdkProperties>> {
        private static final String JDK_ATTR = "jdk";
        private static final String SDK_ATTR = "sdk";

        JpsAndroidSdkPropertiesSerializer() {
            super("Android SDK", (JpsSdkType)JpsAndroidSdkType.INSTANCE);
        }

        public JpsSimpleElement<JpsAndroidSdkProperties> loadProperties(Element propertiesElement) {
            String buildTarget = null;
            String jdkName = null;
            if (propertiesElement != null) {
                buildTarget = propertiesElement.getAttributeValue(SDK_ATTR);
                jdkName = propertiesElement.getAttributeValue(JDK_ATTR);
            }
            return JpsElementFactory.getInstance().createSimpleElement((Object)new JpsAndroidSdkProperties(buildTarget, jdkName));
        }

        public void saveProperties(JpsSimpleElement<JpsAndroidSdkProperties> properties, Element element) {
            String buildTarget;
            String jdkName = ((JpsAndroidSdkProperties)properties.getData()).getJdkName();
            if (jdkName != null) {
                element.setAttribute(JDK_ATTR, jdkName);
            }
            if ((buildTarget = ((JpsAndroidSdkProperties)properties.getData()).getBuildTargetHashString()) != null) {
                element.setAttribute(SDK_ATTR, buildTarget);
            }
        }
    }

    private static class JpsAndroidGradleFacetConfigurationSerializer
    extends JpsFacetConfigurationSerializer<JpsAndroidGradleModuleExtension> {
        JpsAndroidGradleFacetConfigurationSerializer() {
            super(JpsAndroidGradleModuleExtensionImpl.KIND, "android-gradle", "Android-Gradle");
        }

        protected JpsAndroidGradleModuleExtension loadExtension(Element facetConfigurationElement, String name, JpsElement parent, JpsModule module) {
            JpsAndroidGradleModuleProperties properties = (JpsAndroidGradleModuleProperties)XmlSerializer.deserialize((Element)facetConfigurationElement, JpsAndroidGradleModuleProperties.class);
            return new JpsAndroidGradleModuleExtensionImpl(properties);
        }

        protected void saveExtension(JpsAndroidGradleModuleExtension extension, Element facetConfigurationTag, JpsModule module) {
            XmlSerializer.serializeInto((Object)extension.getProperties(), (Element)facetConfigurationTag);
        }
    }
}

