/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast;

import java.util.ArrayList;
import java.util.List;
import lombok.ast.AbstractNode;
import lombok.ast.AstException;
import lombok.ast.AstVisitor;
import lombok.ast.ImportDeclaration;
import lombok.ast.ListAccessor;
import lombok.ast.Node;
import lombok.ast.PackageDeclaration;
import lombok.ast.RawListAccessor;
import lombok.ast.StrictListAccessor;
import lombok.ast.TypeDeclaration;

public class CompilationUnit
extends AbstractNode {
    private AbstractNode packageDeclaration = null;
    ListAccessor<ImportDeclaration, CompilationUnit> importDeclarations = ListAccessor.of(this, ImportDeclaration.class, "CompilationUnit.importDeclarations");
    ListAccessor<TypeDeclaration, CompilationUnit> typeDeclarations = ListAccessor.of(this, TypeDeclaration.class, "CompilationUnit.typeDeclarations");

    public PackageDeclaration astPackageDeclaration() {
        if (!(this.packageDeclaration instanceof PackageDeclaration)) {
            return null;
        }
        return (PackageDeclaration)this.packageDeclaration;
    }

    public CompilationUnit astPackageDeclaration(PackageDeclaration packageDeclaration) {
        return this.rawPackageDeclaration(packageDeclaration);
    }

    public Node rawPackageDeclaration() {
        return this.packageDeclaration;
    }

    public CompilationUnit rawPackageDeclaration(Node packageDeclaration) {
        if (packageDeclaration == this.packageDeclaration) {
            return this;
        }
        if (packageDeclaration != null) {
            this.adopt((AbstractNode)packageDeclaration);
        }
        if (this.packageDeclaration != null) {
            this.disown(this.packageDeclaration);
        }
        this.packageDeclaration = (AbstractNode)packageDeclaration;
        return this;
    }

    public RawListAccessor<ImportDeclaration, CompilationUnit> rawImportDeclarations() {
        return this.importDeclarations.asRaw();
    }

    public StrictListAccessor<ImportDeclaration, CompilationUnit> astImportDeclarations() {
        return this.importDeclarations.asStrict();
    }

    public RawListAccessor<TypeDeclaration, CompilationUnit> rawTypeDeclarations() {
        return this.typeDeclarations.asRaw();
    }

    public StrictListAccessor<TypeDeclaration, CompilationUnit> astTypeDeclarations() {
        return this.typeDeclarations.asStrict();
    }

    @Override
    public List<Node> getChildren() {
        ArrayList<Node> result = new ArrayList<Node>();
        if (this.packageDeclaration != null) {
            result.add(this.packageDeclaration);
        }
        result.addAll(this.importDeclarations.backingList());
        result.addAll(this.typeDeclarations.backingList());
        return result;
    }

    @Override
    public boolean replaceChild(Node original, Node replacement) throws AstException {
        if (this.packageDeclaration == original) {
            this.rawPackageDeclaration(replacement);
            return true;
        }
        if (this.rawImportDeclarations().replace(original, replacement)) {
            return true;
        }
        return this.rawTypeDeclarations().replace(original, replacement);
    }

    @Override
    public boolean detach(Node child) {
        if (this.packageDeclaration == child) {
            this.disown((AbstractNode)child);
            this.packageDeclaration = null;
            return true;
        }
        if (this.rawImportDeclarations().remove(child)) {
            return true;
        }
        return this.rawTypeDeclarations().remove(child);
    }

    @Override
    public void accept(AstVisitor visitor) {
        if (visitor.visitCompilationUnit(this)) {
            return;
        }
        if (this.packageDeclaration != null) {
            this.packageDeclaration.accept(visitor);
        }
        for (AbstractNode child : this.importDeclarations.asIterable()) {
            child.accept(visitor);
        }
        for (AbstractNode child : this.typeDeclarations.asIterable()) {
            child.accept(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    public CompilationUnit copy() {
        CompilationUnit result = new CompilationUnit();
        if (this.packageDeclaration != null) {
            result.rawPackageDeclaration(this.packageDeclaration.copy());
        }
        for (AbstractNode n : this.importDeclarations.backingList()) {
            result.rawImportDeclarations().addToEnd(n == null ? null : n.copy());
        }
        for (AbstractNode n : this.typeDeclarations.backingList()) {
            result.rawTypeDeclarations().addToEnd(n == null ? null : n.copy());
        }
        return result;
    }
}

