/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.vectordrawable;

import com.android.ide.common.vectordrawable.PathBuilder;
import com.android.ide.common.vectordrawable.SvgGroupNode;
import com.android.ide.common.vectordrawable.SvgLeafNode;
import com.android.ide.common.vectordrawable.SvgTree;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Svg2Vector {
    private static Logger logger = Logger.getLogger(Svg2Vector.class.getSimpleName());
    public static final String SVG_POLYGON = "polygon";
    public static final String SVG_POLYLINE = "polyline";
    public static final String SVG_RECT = "rect";
    public static final String SVG_CIRCLE = "circle";
    public static final String SVG_LINE = "line";
    public static final String SVG_PATH = "path";
    public static final String SVG_GROUP = "g";
    public static final String SVG_TRANSFORM = "transform";
    public static final String SVG_WIDTH = "width";
    public static final String SVG_HEIGHT = "height";
    public static final String SVG_VIEW_BOX = "viewBox";
    public static final String SVG_STYLE = "style";
    public static final String SVG_DISPLAY = "display";
    public static final String SVG_D = "d";
    public static final String SVG_STROKE_COLOR = "stroke";
    public static final String SVG_STROKE_OPACITY = "stroke-opacity";
    public static final String SVG_STROKE_LINEJOINE = "stroke-linejoin";
    public static final String SVG_STROKE_LINECAP = "stroke-linecap";
    public static final String SVG_STROKE_WIDTH = "stroke-width";
    public static final String SVG_FILL_COLOR = "fill";
    public static final String SVG_FILL_OPACITY = "fill-opacity";
    public static final String SVG_OPACITY = "opacity";
    public static final String SVG_CLIP = "clip";
    public static final String SVG_POINTS = "points";
    public static final ImmutableMap<String, String> presentationMap = ImmutableMap.builder().put((Object)"stroke", (Object)"android:strokeColor").put((Object)"stroke-opacity", (Object)"android:strokeAlpha").put((Object)"stroke-linejoin", (Object)"android:strokeLineJoin").put((Object)"stroke-linecap", (Object)"android:strokeLineCap").put((Object)"stroke-width", (Object)"android:strokeWidth").put((Object)"fill", (Object)"android:fillColor").put((Object)"fill-opacity", (Object)"android:fillAlpha").put((Object)"clip", (Object)"android:clip").put((Object)"opacity", (Object)"android:fillAlpha").build();
    private static final HashSet<String> unsupportedSvgNodes = Sets.newHashSet((Object[])new String[]{"animate", "animateColor", "animateMotion", "animateTransform", "mpath", "set", "a", "defs", "glyph", "marker", "mask", "missing-glyph", "pattern", "switch", "symbol", "feBlend", "feColorMatrix", "feComponentTransfer", "feComposite", "feConvolveMatrix", "feDiffuseLighting", "feDisplacementMap", "feFlood", "feFuncA", "feFuncB", "feFuncG", "feFuncR", "feGaussianBlur", "feImage", "feMerge", "feMergeNode", "feMorphology", "feOffset", "feSpecularLighting", "feTile", "feTurbulence", "font", "font-face", "font-face-format", "font-face-name", "font-face-src", "font-face-uri", "hkern", "vkern", "linearGradient", "radialGradient", "stop", "ellipse", "text", "use", "feDistantLight", "fePointLight", "feSpotLight", "defs", "symbol", "use", "altGlyph", "altGlyphDef", "altGlyphItem", "glyph", "glyphRef", "textPath", "text", "tref", "tspan", "altGlyph", "textPath", "tref", "tspan", "clipPath", "color-profile", "cursor", "filter", "foreignObject", "script", "view"});
    private static final String head = "<vector xmlns:android=\"http://schemas.android.com/apk/res/android\"\n";

    private static SvgTree parse(File f) throws Exception {
        SvgTree svgTree = new SvgTree();
        Document doc = svgTree.parse(f);
        NodeList nSvgNode = doc.getElementsByTagName("svg");
        if (nSvgNode.getLength() != 1) {
            throw new IllegalStateException("Not a proper SVG file");
        }
        Node rootNode = nSvgNode.item(0);
        for (int i = 0; i < nSvgNode.getLength(); ++i) {
            Node nNode = nSvgNode.item(i);
            if (nNode.getNodeType() != 1) continue;
            Svg2Vector.parseDimension(svgTree, nNode);
        }
        if (svgTree.viewBox == null) {
            svgTree.logErrorLine("Missing \"viewBox\" in <svg> element", rootNode, SvgTree.SvgLogLevel.ERROR);
            return svgTree;
        }
        if ((svgTree.w == 0.0f || svgTree.h == 0.0f) && svgTree.viewBox[2] > 0.0f && svgTree.viewBox[3] > 0.0f) {
            svgTree.w = svgTree.viewBox[2];
            svgTree.h = svgTree.viewBox[3];
        }
        svgTree.matrix = new float[6];
        svgTree.matrix[0] = 1.0f;
        svgTree.matrix[3] = 1.0f;
        NodeList nUseTags = doc.getElementsByTagName("use");
        for (int temp = 0; temp < nUseTags.getLength(); ++temp) {
            Node nNode = nUseTags.item(temp);
            if (nNode.getNodeType() != 1) continue;
            Svg2Vector.parseTransformation(svgTree, nNode);
        }
        SvgGroupNode root = new SvgGroupNode(svgTree, rootNode, "root");
        svgTree.setRoot(root);
        Svg2Vector.traverseSVGAndExtract(svgTree, root, rootNode);
        svgTree.dump(root);
        return svgTree;
    }

    private static void traverseSVGAndExtract(SvgTree svgTree, SvgGroupNode currentGroup, Node item) {
        NodeList allChildren = item.getChildNodes();
        for (int i = 0; i < allChildren.getLength(); ++i) {
            Node currentNode = allChildren.item(i);
            String nodeName = currentNode.getNodeName();
            if (!currentNode.hasChildNodes() && !currentNode.hasAttributes()) continue;
            if (SVG_PATH.equals(nodeName) || SVG_RECT.equals(nodeName) || SVG_CIRCLE.equals(nodeName) || SVG_POLYGON.equals(nodeName) || SVG_POLYLINE.equals(nodeName) || SVG_LINE.equals(nodeName)) {
                SvgLeafNode child = new SvgLeafNode(svgTree, currentNode, nodeName + i);
                Svg2Vector.extractAllItemsAs(svgTree, child, currentNode);
                currentGroup.addChild(child);
                svgTree.setHasLeafNode(true);
                continue;
            }
            if (SVG_GROUP.equals(nodeName)) {
                SvgGroupNode childGroup = new SvgGroupNode(svgTree, currentNode, "child" + i);
                currentGroup.addChild(childGroup);
                Svg2Vector.traverseSVGAndExtract(svgTree, childGroup, currentNode);
                continue;
            }
            if (unsupportedSvgNodes.contains(nodeName)) {
                svgTree.logErrorLine("<" + nodeName + "> is not supported", currentNode, SvgTree.SvgLogLevel.ERROR);
            }
            Svg2Vector.traverseSVGAndExtract(svgTree, currentGroup, currentNode);
        }
    }

    private static void parseTransformation(SvgTree avg, Node nNode) {
        NamedNodeMap a = nNode.getAttributes();
        int len = a.getLength();
        for (int i = 0; i < len; ++i) {
            Node n = a.item(i);
            String name = n.getNodeName();
            String value = n.getNodeValue();
            if (SVG_TRANSFORM.equals(name)) {
                if (!value.startsWith("matrix(")) continue;
                value = value.substring("matrix(".length(), value.length() - 1);
                String[] sp = value.split(" ");
                for (int j = 0; j < sp.length; ++j) {
                    avg.matrix[j] = Float.parseFloat(sp[j]);
                }
                continue;
            }
            if (name.equals("y")) {
                Float.parseFloat(value);
                continue;
            }
            if (!name.equals("x")) continue;
            Float.parseFloat(value);
        }
    }

    private static void parseDimension(SvgTree avg, Node nNode) {
        NamedNodeMap a = nNode.getAttributes();
        int len = a.getLength();
        for (int i = 0; i < len; ++i) {
            Node n = a.item(i);
            String name = n.getNodeName();
            String value = n.getNodeValue();
            int subStringSize = value.length();
            if (subStringSize > 2 && value.endsWith("px")) {
                subStringSize -= 2;
            }
            if (SVG_WIDTH.equals(name)) {
                avg.w = Float.parseFloat(value.substring(0, subStringSize));
                continue;
            }
            if (SVG_HEIGHT.equals(name)) {
                avg.h = Float.parseFloat(value.substring(0, subStringSize));
                continue;
            }
            if (!SVG_VIEW_BOX.equals(name)) continue;
            avg.viewBox = new float[4];
            String[] strbox = value.split(" ");
            for (int j = 0; j < avg.viewBox.length; ++j) {
                avg.viewBox[j] = Float.parseFloat(strbox[j]);
            }
        }
        if (avg.viewBox == null && avg.w != 0.0f && avg.h != 0.0f) {
            avg.viewBox = new float[4];
            avg.viewBox[2] = avg.w;
            avg.viewBox[3] = avg.h;
        }
    }

    private static void extractAllItemsAs(SvgTree avg, SvgLeafNode child, Node currentItem) {
        Node currentGroupNode;
        boolean hasNodeAttr = false;
        String styleContent = "";
        boolean nothingToDisplay = false;
        for (Node currentGroup = currentItem.getParentNode(); currentGroup != null && currentGroup.getNodeName().equals(SVG_GROUP); currentGroup = currentGroup.getParentNode()) {
            Node displayAttr;
            logger.log(Level.FINE, "Printing current parent");
            Svg2Vector.printlnCommon(currentGroup);
            NamedNodeMap attr = currentGroup.getAttributes();
            Node nodeAttr = attr.getNamedItem(SVG_STYLE);
            if (nodeAttr != null) {
                styleContent = styleContent + nodeAttr.getTextContent() + ";";
                logger.log(Level.FINE, "styleContent is :" + styleContent + "at number group ");
                if (styleContent.contains("display:none")) {
                    logger.log(Level.FINE, "Found none style, skip the whole group");
                    nothingToDisplay = true;
                    break;
                }
                hasNodeAttr = true;
            }
            if ((displayAttr = attr.getNamedItem(SVG_DISPLAY)) == null || !"none".equals(displayAttr.getNodeValue())) continue;
            logger.log(Level.FINE, "Found display:none style, skip the whole group");
            nothingToDisplay = true;
            break;
        }
        if (nothingToDisplay) {
            return;
        }
        logger.log(Level.FINE, "Print current item");
        Svg2Vector.printlnCommon(currentItem);
        if (hasNodeAttr && styleContent != null) {
            Svg2Vector.addStyleToPath(child, styleContent);
        }
        if (SVG_PATH.equals((currentGroupNode = currentItem).getNodeName())) {
            Svg2Vector.extractPathItem(avg, child, currentGroupNode);
        }
        if (SVG_RECT.equals(currentGroupNode.getNodeName())) {
            Svg2Vector.extractRectItem(avg, child, currentGroupNode);
        }
        if (SVG_CIRCLE.equals(currentGroupNode.getNodeName())) {
            Svg2Vector.extractCircleItem(avg, child, currentGroupNode);
        }
        if (SVG_POLYGON.equals(currentGroupNode.getNodeName()) || SVG_POLYLINE.equals(currentGroupNode.getNodeName())) {
            Svg2Vector.extractPolyItem(avg, child, currentGroupNode);
        }
        if (SVG_LINE.equals(currentGroupNode.getNodeName())) {
            Svg2Vector.extractLineItem(avg, child, currentGroupNode);
        }
    }

    private static void printlnCommon(Node n) {
        logger.log(Level.FINE, " nodeName=\"" + n.getNodeName() + "\"");
        String val = n.getNamespaceURI();
        if (val != null) {
            logger.log(Level.FINE, " uri=\"" + val + "\"");
        }
        if ((val = n.getPrefix()) != null) {
            logger.log(Level.FINE, " pre=\"" + val + "\"");
        }
        if ((val = n.getLocalName()) != null) {
            logger.log(Level.FINE, " local=\"" + val + "\"");
        }
        if ((val = n.getNodeValue()) != null) {
            logger.log(Level.FINE, " nodeValue=");
            if (val.trim().equals("")) {
                logger.log(Level.FINE, "[WS]");
            } else {
                logger.log(Level.FINE, "\"" + n.getNodeValue() + "\"");
            }
        }
    }

    private static void extractPolyItem(SvgTree avg, SvgLeafNode child, Node currentGroupNode) {
        logger.log(Level.FINE, "Polyline or Polygon found" + currentGroupNode.getTextContent());
        if (currentGroupNode.getNodeType() == 1) {
            NamedNodeMap a = currentGroupNode.getAttributes();
            int len = a.getLength();
            for (int itemIndex = 0; itemIndex < len; ++itemIndex) {
                Node n = a.item(itemIndex);
                String name = n.getNodeName();
                String value = n.getNodeValue();
                if (name.equals(SVG_STYLE)) {
                    Svg2Vector.addStyleToPath(child, value);
                    continue;
                }
                if (presentationMap.containsKey((Object)name)) {
                    child.fillPresentationAttributes(name, value);
                    continue;
                }
                if (!name.equals(SVG_POINTS)) continue;
                PathBuilder builder = new PathBuilder();
                String[] split = value.split("[\\s,]+");
                float baseX = Float.parseFloat(split[0]);
                float baseY = Float.parseFloat(split[1]);
                builder.absoluteMoveTo(baseX, baseY);
                for (int j = 2; j < split.length; j += 2) {
                    float x = Float.parseFloat(split[j]);
                    float y = Float.parseFloat(split[j + 1]);
                    builder.relativeLineTo(x - baseX, y - baseY);
                    baseX = x;
                    baseY = y;
                }
                if (SVG_POLYGON.equals(currentGroupNode.getNodeName())) {
                    builder.relativeClose();
                }
                child.setPathData(builder.toString());
            }
        }
    }

    private static void extractRectItem(SvgTree avg, SvgLeafNode child, Node currentGroupNode) {
        logger.log(Level.FINE, "Rect found" + currentGroupNode.getTextContent());
        if (currentGroupNode.getNodeType() == 1) {
            float x = 0.0f;
            float y = 0.0f;
            float width = Float.NaN;
            float height = Float.NaN;
            NamedNodeMap a = currentGroupNode.getAttributes();
            int len = a.getLength();
            boolean pureTransparent = false;
            for (int j = 0; j < len; ++j) {
                Node n = a.item(j);
                String name = n.getNodeName();
                String value = n.getNodeValue();
                if (name.equals(SVG_STYLE)) {
                    Svg2Vector.addStyleToPath(child, value);
                    if (!value.contains("opacity:0;")) continue;
                    pureTransparent = true;
                    continue;
                }
                if (presentationMap.containsKey((Object)name)) {
                    child.fillPresentationAttributes(name, value);
                    continue;
                }
                if (name.equals("clip-path") && value.startsWith("url(#SVGID_")) continue;
                if (name.equals("x")) {
                    x = Float.parseFloat(value);
                    continue;
                }
                if (name.equals("y")) {
                    y = Float.parseFloat(value);
                    continue;
                }
                if (name.equals(SVG_WIDTH)) {
                    width = Float.parseFloat(value);
                    continue;
                }
                if (name.equals(SVG_HEIGHT)) {
                    height = Float.parseFloat(value);
                    continue;
                }
                if (!name.equals(SVG_STYLE)) continue;
            }
            if (!(pureTransparent || avg == null || Float.isNaN(x) || Float.isNaN(y) || Float.isNaN(width) || Float.isNaN(height))) {
                PathBuilder builder = new PathBuilder();
                builder.absoluteMoveTo(x, y);
                builder.relativeHorizontalTo(width);
                builder.relativeVerticalTo(height);
                builder.relativeHorizontalTo(-width);
                builder.relativeClose();
                child.setPathData(builder.toString());
            }
        }
    }

    private static void extractCircleItem(SvgTree avg, SvgLeafNode child, Node currentGroupNode) {
        logger.log(Level.FINE, "circle found" + currentGroupNode.getTextContent());
        if (currentGroupNode.getNodeType() == 1) {
            float cx = 0.0f;
            float cy = 0.0f;
            float radius = 0.0f;
            NamedNodeMap a = currentGroupNode.getAttributes();
            int len = a.getLength();
            boolean pureTransparent = false;
            for (int j = 0; j < len; ++j) {
                Node n = a.item(j);
                String name = n.getNodeName();
                String value = n.getNodeValue();
                if (name.equals(SVG_STYLE)) {
                    Svg2Vector.addStyleToPath(child, value);
                    if (!value.contains("opacity:0;")) continue;
                    pureTransparent = true;
                    continue;
                }
                if (presentationMap.containsKey((Object)name)) {
                    child.fillPresentationAttributes(name, value);
                    continue;
                }
                if (name.equals("clip-path") && value.startsWith("url(#SVGID_")) continue;
                if (name.equals("cx")) {
                    cx = Float.parseFloat(value);
                    continue;
                }
                if (name.equals("cy")) {
                    cy = Float.parseFloat(value);
                    continue;
                }
                if (!name.equals("r")) continue;
                radius = Float.parseFloat(value);
            }
            if (!(pureTransparent || avg == null || Float.isNaN(cx) || Float.isNaN(cy))) {
                PathBuilder builder = new PathBuilder();
                builder.absoluteMoveTo(cx, cy);
                builder.relativeMoveTo(-radius, 0.0f);
                builder.relativeArcTo(radius, radius, false, true, true, 2.0f * radius, 0.0f);
                builder.relativeArcTo(radius, radius, false, true, true, -2.0f * radius, 0.0f);
                child.setPathData(builder.toString());
            }
        }
    }

    private static void extractLineItem(SvgTree avg, SvgLeafNode child, Node currentGroupNode) {
        logger.log(Level.FINE, "line found" + currentGroupNode.getTextContent());
        if (currentGroupNode.getNodeType() == 1) {
            float x1 = 0.0f;
            float y1 = 0.0f;
            float x2 = 0.0f;
            float y2 = 0.0f;
            NamedNodeMap a = currentGroupNode.getAttributes();
            int len = a.getLength();
            boolean pureTransparent = false;
            for (int j = 0; j < len; ++j) {
                Node n = a.item(j);
                String name = n.getNodeName();
                String value = n.getNodeValue();
                if (name.equals(SVG_STYLE)) {
                    Svg2Vector.addStyleToPath(child, value);
                    if (!value.contains("opacity:0;")) continue;
                    pureTransparent = true;
                    continue;
                }
                if (presentationMap.containsKey((Object)name)) {
                    child.fillPresentationAttributes(name, value);
                    continue;
                }
                if (name.equals("clip-path") && value.startsWith("url(#SVGID_")) continue;
                if (name.equals("x1")) {
                    x1 = Float.parseFloat(value);
                    continue;
                }
                if (name.equals("y1")) {
                    y1 = Float.parseFloat(value);
                    continue;
                }
                if (name.equals("x2")) {
                    x2 = Float.parseFloat(value);
                    continue;
                }
                if (!name.equals("y2")) continue;
                y2 = Float.parseFloat(value);
            }
            if (!(pureTransparent || avg == null || Float.isNaN(x1) || Float.isNaN(y1) || Float.isNaN(x2) || Float.isNaN(y2))) {
                PathBuilder builder = new PathBuilder();
                builder.absoluteMoveTo(x1, y1);
                builder.absoluteLineTo(x2, y2);
                child.setPathData(builder.toString());
            }
        }
    }

    private static void extractPathItem(SvgTree avg, SvgLeafNode child, Node currentGroupNode) {
        logger.log(Level.FINE, "Path found " + currentGroupNode.getTextContent());
        if (currentGroupNode.getNodeType() == 1) {
            Element eElement = (Element)currentGroupNode;
            NamedNodeMap a = currentGroupNode.getAttributes();
            int len = a.getLength();
            for (int j = 0; j < len; ++j) {
                Node n = a.item(j);
                String name = n.getNodeName();
                String value = n.getNodeValue();
                if (name.equals(SVG_STYLE)) {
                    Svg2Vector.addStyleToPath(child, value);
                    continue;
                }
                if (presentationMap.containsKey((Object)name)) {
                    child.fillPresentationAttributes(name, value);
                    continue;
                }
                if (!name.equals(SVG_D)) continue;
                String pathData = value.replaceAll("(\\d)-", "$1,-");
                child.setPathData(pathData);
            }
        }
    }

    private static void addStyleToPath(SvgLeafNode path, String value) {
        logger.log(Level.FINE, "Style found is " + value);
        if (value != null) {
            String[] parts = value.split(";");
            for (int k = parts.length - 1; k >= 0; --k) {
                String subStyle = parts[k];
                String[] nameValue = subStyle.split(":");
                if (nameValue.length != 2 || nameValue[0] == null || nameValue[1] == null) continue;
                if (presentationMap.containsKey((Object)nameValue[0])) {
                    path.fillPresentationAttributes(nameValue[0], nameValue[1]);
                    continue;
                }
                if (!nameValue[0].equals(SVG_OPACITY)) continue;
                path.fillPresentationAttributes(SVG_FILL_OPACITY, nameValue[1]);
            }
        }
    }

    private static String getSizeString(float w, float h, float scaleFactor) {
        String size = "        android:width=\"" + (int)(w * scaleFactor) + "dp\"\n" + "        android:height=\"" + (int)(h * scaleFactor) + "dp\"\n";
        return size;
    }

    private static void writeFile(OutputStream outStream, SvgTree svgTree) throws IOException {
        OutputStreamWriter fw = new OutputStreamWriter(outStream);
        fw.write(head);
        float finalWidth = svgTree.w;
        float finalHeight = svgTree.h;
        fw.write(Svg2Vector.getSizeString(finalWidth, finalHeight, svgTree.mScaleFactor));
        fw.write("        android:viewportWidth=\"" + svgTree.w + "\"\n");
        fw.write("        android:viewportHeight=\"" + svgTree.h + "\">\n");
        svgTree.normalize();
        Svg2Vector.writeXML(svgTree, fw);
        fw.write("</vector>\n");
        fw.close();
    }

    private static void writeXML(SvgTree svgTree, OutputStreamWriter fw) throws IOException {
        svgTree.getRoot().writeXML(fw);
    }

    public static String parseSvgToXml(File inputSVG, OutputStream outStream) {
        String errorLog = null;
        try {
            SvgTree svgTree = Svg2Vector.parse(inputSVG);
            errorLog = svgTree.getErrorLog();
            if (svgTree.getHasLeafNode()) {
                Svg2Vector.writeFile(outStream, svgTree);
            }
        }
        catch (Exception e) {
            errorLog = "EXCEPTION in parsing " + inputSVG.getName() + ":\n" + e.getMessage();
        }
        return errorLog;
    }
}

