/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.vectordrawable;

import com.android.ide.common.vectordrawable.Svg2Vector;
import com.android.ide.common.vectordrawable.SvgNode;
import com.android.ide.common.vectordrawable.SvgTree;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

class SvgGroupNode
extends SvgNode {
    private static Logger logger = Logger.getLogger(SvgGroupNode.class.getSimpleName());
    private static final String INDENT_LEVEL = "    ";
    private ArrayList<SvgNode> mChildren = new ArrayList();

    public SvgGroupNode(SvgTree svgTree, Node docNode, String name) {
        super(svgTree, docNode, name);
        NamedNodeMap a = docNode.getAttributes();
        int len = a.getLength();
        for (int itemIndex = 0; itemIndex < len; ++itemIndex) {
            Node n = a.item(itemIndex);
            String nodeName = n.getNodeName();
            String nodeValue = n.getNodeValue();
            if (!Svg2Vector.presentationMap.containsKey((Object)nodeName)) continue;
            this.fillPresentationAttributes(nodeName, nodeValue, logger);
        }
    }

    public void addChild(SvgNode child) {
        this.mChildren.add(child);
        child.fillEmptyAttributes(this.mVdAttributesMap);
    }

    @Override
    public void dumpNode(String indent) {
        logger.log(Level.FINE, indent + "current group is :" + this.getName());
        for (SvgNode node : this.mChildren) {
            node.dumpNode(indent + INDENT_LEVEL);
        }
    }

    @Override
    public boolean isGroupNode() {
        return true;
    }

    @Override
    public void transform(float a, float b, float c, float d, float e, float f) {
        for (SvgNode p : this.mChildren) {
            p.transform(a, b, c, d, e, f);
        }
    }

    @Override
    public void writeXML(OutputStreamWriter writer) throws IOException {
        for (SvgNode node : this.mChildren) {
            node.writeXML(writer);
        }
    }
}

