/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.NotNullFunction;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.model.module.JpsModule;

public class ModuleChunk {
    private static final NotNullFunction<JpsModule, String> GET_NAME = new NotNullFunction<JpsModule, String>(){

        public String fun(JpsModule dom) {
            return dom.getName();
        }
    };
    private Set<JpsModule> myModules;
    private final boolean myContainsTests;
    private Set<ModuleBuildTarget> myTargets;

    public ModuleChunk(Set<ModuleBuildTarget> targets) {
        boolean containsTests = false;
        this.myTargets = targets;
        this.myModules = new LinkedHashSet<JpsModule>();
        for (ModuleBuildTarget target : targets) {
            this.myModules.add(target.getModule());
            containsTests |= target.isTests();
        }
        this.myContainsTests = containsTests;
    }

    public String getPresentableShortName() {
        String name = this.myModules.iterator().next().getName();
        if (this.myModules.size() > 1) {
            name = name + " and " + (this.myModules.size() - 1) + " more";
            String fullName = this.getName();
            if (fullName.length() < name.length()) {
                name = fullName;
            }
        }
        if (this.containsTests()) {
            name = "tests of " + name;
        }
        return name;
    }

    public String getName() {
        if (this.myModules.size() == 1) {
            return this.myModules.iterator().next().getName();
        }
        return StringUtil.join(this.myModules, GET_NAME, (String)",");
    }

    public Set<JpsModule> getModules() {
        return this.myModules;
    }

    public boolean containsTests() {
        return this.myContainsTests;
    }

    public Set<ModuleBuildTarget> getTargets() {
        return this.myTargets;
    }

    public String toString() {
        return this.getName();
    }

    public ModuleBuildTarget representativeTarget() {
        return this.myTargets.iterator().next();
    }
}

