/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.builders.impl;

import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.jps.builders.BuildRootDescriptor;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.DirtyFilesHolder;
import org.jetbrains.jps.builders.FileProcessor;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.Utils;

public abstract class DirtyFilesHolderBase<R extends BuildRootDescriptor, T extends BuildTarget<R>>
implements DirtyFilesHolder<R, T> {
    protected final CompileContext myContext;

    public DirtyFilesHolderBase(CompileContext context) {
        this.myContext = context;
    }

    @Override
    public boolean hasDirtyFiles() throws IOException {
        final Ref hasDirtyFiles = Ref.create((Object)false);
        this.processDirtyFiles(new FileProcessor<R, T>(){

            @Override
            public boolean apply(T target, File file, R root) throws IOException {
                hasDirtyFiles.set((Object)true);
                return false;
            }
        });
        return (Boolean)hasDirtyFiles.get();
    }

    @Override
    public boolean hasRemovedFiles() {
        Map map = (Map)Utils.REMOVED_SOURCES_KEY.get((UserDataHolder)this.myContext);
        return map != null && !map.isEmpty();
    }

    @Override
    public Collection<String> getRemovedFiles(T target) {
        Collection paths;
        Map map = (Map)Utils.REMOVED_SOURCES_KEY.get((UserDataHolder)this.myContext);
        if (map != null && (paths = (Collection)map.get(target)) != null) {
            return paths;
        }
        return Collections.emptyList();
    }
}

