/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.builders.impl.java;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Collections;
import java.util.List;
import java.util.ServiceLoader;
import javax.tools.JavaCompiler;
import org.jetbrains.jps.builders.java.CannotCreateJavaCompilerException;
import org.jetbrains.jps.builders.java.JavaCompilingTool;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.Utils;

public class EclipseCompilerTool
extends JavaCompilingTool {
    @Override
    public String getId() {
        return "Eclipse";
    }

    @Override
    public String getAlternativeId() {
        return "EclipseEmbedded";
    }

    @Override
    public String getDescription() {
        return "Eclipse compiler";
    }

    @Override
    public JavaCompiler createCompiler() throws CannotCreateJavaCompilerException {
        for (JavaCompiler javaCompiler : ServiceLoader.load(JavaCompiler.class)) {
            if (!"EclipseCompiler".equals(StringUtil.getShortName(javaCompiler.getClass()))) continue;
            return javaCompiler;
        }
        throw new CannotCreateJavaCompilerException("Eclipse Batch Compiler was not found in classpath");
    }

    @Override
    public List<File> getAdditionalClasspath() {
        return ContainerUtil.createMaybeSingletonList((Object)EclipseCompilerTool.findEcjJarFile());
    }

    public static File findEcjJarFile() {
        File[] libs;
        for (File lib : libs = new File[]{new File(PathManager.getHomePath(), "lib"), new File(PathManager.getHomePath(), "community/lib")}) {
            File[] children = lib.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.startsWith("ecj-") && name.endsWith(".jar");
                }
            });
            if (children == null || children.length <= 0) continue;
            return children[0];
        }
        return null;
    }

    @Override
    public void processCompilerOptions(CompileContext context, List<String> options) {
        for (String option : options) {
            if (!option.startsWith("-proceedOnError")) continue;
            Utils.PROCEED_ON_ERROR_KEY.set((UserDataHolder)context, (Object)Boolean.TRUE);
            break;
        }
    }

    @Override
    public List<String> getDefaultCompilerOptions() {
        return Collections.singletonList("-noExit");
    }
}

