/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.builders.java;

import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.FileFilter;
import java.util.Set;
import org.jetbrains.jps.builders.BuildRootDescriptor;
import org.jetbrains.jps.incremental.BuilderRegistry;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.java.compiler.JpsCompilerExcludes;

public class JavaSourceRootDescriptor
extends BuildRootDescriptor {
    public final File root;
    public final ModuleBuildTarget target;
    public final boolean isGeneratedSources;
    public final boolean isTemp;
    private final String myPackagePrefix;
    private final Set<File> myExcludes;

    public JavaSourceRootDescriptor(File root, ModuleBuildTarget target, boolean isGenerated, boolean isTemp, String packagePrefix, Set<File> excludes) {
        this.root = root;
        this.target = target;
        this.isGeneratedSources = isGenerated;
        this.isTemp = isTemp;
        this.myPackagePrefix = packagePrefix;
        this.myExcludes = excludes;
    }

    public String toString() {
        return "RootDescriptor{target='" + this.target + '\'' + ", root=" + this.root + ", generated=" + this.isGeneratedSources + '}';
    }

    @Override
    public Set<File> getExcludedRoots() {
        return this.myExcludes;
    }

    public String getPackagePrefix() {
        return this.myPackagePrefix;
    }

    @Override
    public String getRootId() {
        return FileUtil.toSystemIndependentName((String)this.root.getPath());
    }

    @Override
    public File getRootFile() {
        return this.root;
    }

    public ModuleBuildTarget getTarget() {
        return this.target;
    }

    @Override
    public FileFilter createFileFilter() {
        final JpsCompilerExcludes excludes = JpsJavaExtensionService.getInstance().getOrCreateCompilerConfiguration(this.target.getModule().getProject()).getCompilerExcludes();
        final FileFilter baseFilter = BuilderRegistry.getInstance().getModuleBuilderFileFilter();
        return new FileFilter(){

            @Override
            public boolean accept(File file) {
                return baseFilter.accept(file) && !excludes.isExcluded(file);
            }
        };
    }

    @Override
    public boolean isGenerated() {
        return this.isGeneratedSources;
    }

    @Override
    public boolean canUseFileCache() {
        return true;
    }
}

