/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.builders.java;

import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.util.Set;
import org.jetbrains.jps.builders.BuildRootDescriptor;
import org.jetbrains.jps.incremental.ResourcesTarget;

public class ResourceRootDescriptor
extends BuildRootDescriptor {
    private final File myRoot;
    private final ResourcesTarget myTarget;
    private final String myPackagePrefix;
    private final Set<File> myExcludes;

    public ResourceRootDescriptor(File root, ResourcesTarget target, String packagePrefix, Set<File> excludes) {
        this.myPackagePrefix = packagePrefix;
        this.myRoot = root;
        this.myTarget = target;
        this.myExcludes = excludes;
    }

    @Override
    public File getRootFile() {
        return this.myRoot;
    }

    @Override
    public Set<File> getExcludedRoots() {
        return this.myExcludes;
    }

    public ResourcesTarget getTarget() {
        return this.myTarget;
    }

    public String getPackagePrefix() {
        return this.myPackagePrefix;
    }

    @Override
    public boolean isGenerated() {
        return false;
    }

    public String toString() {
        return "ResourceRootDescriptor{target='" + this.myTarget + '\'' + ", root=" + this.myRoot + '}';
    }

    @Override
    public boolean canUseFileCache() {
        return true;
    }

    @Override
    public String getRootId() {
        return FileUtil.toSystemIndependentName((String)this.myRoot.getPath());
    }
}

