/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.builders.java;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.jps.builders.BuildTargetLoader;
import org.jetbrains.jps.builders.ModuleBasedBuildTargetType;
import org.jetbrains.jps.incremental.ResourcesTarget;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.module.JpsModule;

public class ResourcesTargetType
extends ModuleBasedBuildTargetType<ResourcesTarget> {
    public static final ResourcesTargetType PRODUCTION = new ResourcesTargetType("resources-production", false);
    public static final ResourcesTargetType TEST = new ResourcesTargetType("resources-test", true);
    public static final List<ResourcesTargetType> ALL_TYPES = Arrays.asList(PRODUCTION, TEST);
    private boolean myTests;

    private ResourcesTargetType(String typeId, boolean tests) {
        super(typeId);
        this.myTests = tests;
    }

    @Override
    public List<ResourcesTarget> computeAllTargets(JpsModel model) {
        List modules = model.getProject().getModules();
        ArrayList<ResourcesTarget> targets = new ArrayList<ResourcesTarget>(modules.size());
        for (JpsModule module : modules) {
            targets.add(new ResourcesTarget(module, this));
        }
        return targets;
    }

    public Loader createLoader(JpsModel model) {
        return new Loader(model);
    }

    public boolean isTests() {
        return this.myTests;
    }

    public static ResourcesTargetType getInstance(boolean tests) {
        return tests ? TEST : PRODUCTION;
    }

    private class Loader
    extends BuildTargetLoader<ResourcesTarget> {
        private final Map<String, JpsModule> myModules = new HashMap<String, JpsModule>();

        public Loader(JpsModel model) {
            for (JpsModule module : model.getProject().getModules()) {
                this.myModules.put(module.getName(), module);
            }
        }

        @Override
        public ResourcesTarget createTarget(String targetId) {
            JpsModule module = this.myModules.get(targetId);
            return module != null ? new ResourcesTarget(module, ResourcesTargetType.this) : null;
        }
    }
}

