/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.builders.java.dependencyView;

import com.intellij.util.io.DataInputOutputUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintStream;
import org.jetbrains.jps.builders.java.dependencyView.DependencyContext;
import org.jetbrains.jps.builders.java.dependencyView.Difference;
import org.jetbrains.jps.builders.java.dependencyView.Proto;
import org.jetbrains.jps.builders.java.dependencyView.RW;
import org.jetbrains.jps.builders.java.dependencyView.TypeRepr;
import org.jetbrains.jps.builders.storage.BuildDataCorruptedException;
import org.jetbrains.org.objectweb.asm.Type;

abstract class ProtoMember
extends Proto {
    private static final byte STRING = 0;
    private static final byte NONE = 1;
    private static final byte INTEGER = 2;
    private static final byte LONG = 3;
    private static final byte FLOAT = 4;
    private static final byte DOUBLE = 5;
    private static final byte TYPE = 6;
    public final TypeRepr.AbstractType myType;
    public final Object myValue;

    public boolean hasValue() {
        return this.myValue != null;
    }

    protected ProtoMember(int access, int signature, int name, TypeRepr.AbstractType t, Object value) {
        super(access, signature, name);
        this.myType = t;
        this.myValue = value;
    }

    private static Object loadTyped(DataInput in) {
        try {
            switch (in.readByte()) {
                case 0: {
                    return RW.readUTF(in);
                }
                case 1: {
                    return null;
                }
                case 2: {
                    return DataInputOutputUtil.readINT((DataInput)in);
                }
                case 3: {
                    return in.readLong();
                }
                case 4: {
                    return Float.valueOf(in.readFloat());
                }
                case 5: {
                    return in.readDouble();
                }
                case 6: {
                    return Type.getType((String)RW.readUTF(in));
                }
            }
        }
        catch (IOException e) {
            throw new BuildDataCorruptedException(e);
        }
        assert (false);
        return null;
    }

    protected ProtoMember(DependencyContext context, DataInput in) {
        super(in);
        try {
            this.myType = (TypeRepr.AbstractType)TypeRepr.externalizer(context).read(in);
            this.myValue = ProtoMember.loadTyped(in);
        }
        catch (IOException e) {
            throw new BuildDataCorruptedException(e);
        }
    }

    @Override
    public void save(DataOutput out) {
        super.save(out);
        this.myType.save(out);
        try {
            if (this.myValue instanceof String) {
                out.writeByte(0);
                String value = (String)this.myValue;
                RW.writeUTF(out, value);
            } else if (this.myValue instanceof Integer) {
                out.writeByte(2);
                DataInputOutputUtil.writeINT((DataOutput)out, (int)((Integer)this.myValue));
            } else if (this.myValue instanceof Long) {
                out.writeByte(3);
                out.writeLong((Long)this.myValue);
            } else if (this.myValue instanceof Float) {
                out.writeByte(4);
                out.writeFloat(((Float)this.myValue).floatValue());
            } else if (this.myValue instanceof Double) {
                out.writeByte(5);
                out.writeDouble((Double)this.myValue);
            } else if (this.myValue instanceof Type) {
                out.writeByte(6);
                RW.writeUTF(out, ((Type)this.myValue).getDescriptor());
            } else {
                out.writeByte(1);
            }
        }
        catch (IOException e) {
            throw new BuildDataCorruptedException(e);
        }
    }

    @Override
    public Difference difference(final Proto past) {
        ProtoMember m = (ProtoMember)past;
        final Difference diff = super.difference(past);
        int base = diff.base();
        if (!m.myType.equals(this.myType)) {
            base |= 2;
        }
        switch ((this.myValue == null ? 0 : 1) + (m.myValue == null ? 0 : 2)) {
            case 3: {
                if (this.myValue.equals(m.myValue)) break;
                base |= 4;
                break;
            }
            case 2: {
                base |= 4;
                break;
            }
            case 1: {
                base |= 4;
                break;
            }
        }
        final int newBase = base;
        return new Difference(){

            @Override
            public int base() {
                return newBase;
            }

            @Override
            public boolean no() {
                return newBase == 0 && diff.no();
            }

            @Override
            public int addedModifiers() {
                return diff.addedModifiers();
            }

            @Override
            public int removedModifiers() {
                return diff.removedModifiers();
            }

            @Override
            public boolean packageLocalOn() {
                return diff.packageLocalOn();
            }

            @Override
            public boolean hadValue() {
                return ((ProtoMember)past).hasValue();
            }

            @Override
            public boolean weakedAccess() {
                return diff.weakedAccess();
            }
        };
    }

    @Override
    public void toStream(DependencyContext context, PrintStream stream) {
        super.toStream(context, stream);
        stream.print("          Type       : ");
        stream.println(this.myType.getDescr(context));
        stream.print("          Value      : ");
        stream.println(this.myValue == null ? "<null>" : this.myValue.toString());
    }
}

