/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.classFilesIndex;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Set;
import org.jetbrains.org.objectweb.asm.Type;

public class AsmUtil {
    private static final Set<String> ASM_PRIMITIVE_TYPES = ContainerUtil.newHashSet((Object[])new String[]{"C", "D", "F", "I", "J", "S", "Z", "B", "V", "Ljava/lang/Object;", "Ljava/lang/String;", "Ljava/lang/Class;"});

    private AsmUtil() {
    }

    public static String getQualifiedClassName(String name) {
        return StringUtil.replaceChar((String)Type.getObjectType((String)name).getClassName(), (char)'$', (char)'.');
    }

    public static boolean isPrimitiveOrArrayOfPrimitives(String asmType) {
        for (int i = 0; i < asmType.length(); ++i) {
            if (asmType.charAt(i) == '[') continue;
            return ASM_PRIMITIVE_TYPES.contains(asmType.substring(i));
        }
        throw new AssertionError((Object)("Illegal string: " + asmType));
    }
}

