/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.classFilesIndex;

import com.intellij.util.io.DataExternalizer;
import gnu.trove.TObjectIntHashMap;
import gnu.trove.TObjectIntProcedure;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class TObjectIntHashMapExternalizer<K>
implements DataExternalizer<TObjectIntHashMap<K>> {
    private final DataExternalizer<K> myKeyDataExternalizer;

    public TObjectIntHashMapExternalizer(DataExternalizer<K> keyDataExternalizer) {
        this.myKeyDataExternalizer = keyDataExternalizer;
    }

    public void save(final DataOutput out, TObjectIntHashMap<K> map) throws IOException {
        out.writeInt(map.size());
        try {
            map.forEachEntry(new TObjectIntProcedure<K>(){

                public boolean execute(K key, int value) {
                    try {
                        TObjectIntHashMapExternalizer.this.myKeyDataExternalizer.save(out, key);
                        out.writeInt(value);
                    }
                    catch (IOException e) {
                        throw new IoExceptionRuntimeWrapperException(e);
                    }
                    return true;
                }
            });
        }
        catch (IoExceptionRuntimeWrapperException e) {
            throw e.getIoException();
        }
    }

    public TObjectIntHashMap<K> read(DataInput in) throws IOException {
        int size = in.readInt();
        TObjectIntHashMap map = new TObjectIntHashMap(size);
        for (int i = 0; i < size; ++i) {
            map.put(this.myKeyDataExternalizer.read(in), in.readInt());
        }
        return map;
    }

    private static class IoExceptionRuntimeWrapperException
    extends RuntimeException {
        private final IOException myIoException;

        private IoExceptionRuntimeWrapperException(IOException ioException) {
            this.myIoException = ioException;
        }

        public IOException getIoException() {
            return this.myIoException;
        }
    }
}

