/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.cmdline;

import com.google.protobuf.MessageLite;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileSystemUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.protobuf.ProtobufDecoder;
import io.netty.handler.codec.protobuf.ProtobufEncoder;
import io.netty.handler.codec.protobuf.ProtobufVarint32FrameDecoder;
import io.netty.handler.codec.protobuf.ProtobufVarint32LengthFieldPrepender;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Level;
import org.apache.log4j.PropertyConfigurator;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.jps.api.CmdlineProtoUtil;
import org.jetbrains.jps.api.CmdlineRemoteProto;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.cmdline.BuildRunner;
import org.jetbrains.jps.cmdline.BuildSession;
import org.jetbrains.jps.cmdline.JpsModelLoaderImpl;
import org.jetbrains.jps.cmdline.PreloadedData;
import org.jetbrains.jps.cmdline.ProjectDescriptor;
import org.jetbrains.jps.incremental.BuilderRegistry;
import org.jetbrains.jps.incremental.MessageHandler;
import org.jetbrains.jps.incremental.Utils;
import org.jetbrains.jps.incremental.fs.BuildFSState;
import org.jetbrains.jps.incremental.messages.BuildMessage;
import org.jetbrains.jps.incremental.storage.BuildTargetsState;
import org.jetbrains.jps.service.SharedThreadPool;

public class BuildMain {
    private static final String PRELOAD_PROJECT_PATH = "preload.project.path";
    private static final String PRELOAD_CONFIG_PATH = "preload.config.path";
    private static final String LOG_CONFIG_FILE_NAME = "build-log.properties";
    private static final String LOG_FILE_NAME = "build.log";
    private static final String DEFAULT_LOGGER_CONFIG = "defaultLogConfig.properties";
    private static final String LOG_FILE_MACRO = "$LOG_FILE_PATH$";
    private static final Logger LOG;
    private static final int HOST_ARG = 0;
    private static final int PORT_ARG = 1;
    private static final int SESSION_ID_ARG = 2;
    private static final int SYSTEM_DIR_ARG = 3;
    private static NioEventLoopGroup ourEventLoopGroup;
    private static PreloadedData ourPreloadedData;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        Bootstrap bootstrap;
        ChannelFuture future;
        boolean success;
        long processStart = System.currentTimeMillis();
        String startMessage = "Build process started. Classpath: " + System.getProperty("java.class.path");
        System.out.println(startMessage);
        LOG.info(startMessage);
        String host = args[0];
        int port = Integer.parseInt(args[1]);
        final UUID sessionId = UUID.fromString(args[2]);
        File systemDir = new File(FileUtil.toCanonicalPath((String)args[3]));
        Utils.setSystemRoot(systemDir);
        long connectStart = System.currentTimeMillis();
        for (int attempt = 0; attempt < 3; ++attempt) {
            try {
                ourEventLoopGroup = new NioEventLoopGroup(1, (Executor)SharedThreadPool.getInstance());
                break;
            }
            catch (IllegalStateException e) {
                if (attempt == 2) {
                    BuildMain.printErrorAndExit(host, port, e);
                    return;
                }
                LOG.warn("Cannot create event loop, attempt #" + attempt, (Throwable)e);
                try {
                    Thread.sleep(10 * (attempt + 1));
                }
                catch (InterruptedException ignored) {
                    // empty catch block
                }
                continue;
            }
        }
        if (success = (future = (bootstrap = (Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)ourEventLoopGroup)).channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer(){

            protected void initChannel(Channel channel) throws Exception {
                channel.pipeline().addLast(new ChannelHandler[]{new ProtobufVarint32FrameDecoder(), new ProtobufDecoder((MessageLite)CmdlineRemoteProto.Message.getDefaultInstance()), new ProtobufVarint32LengthFieldPrepender(), new ProtobufEncoder(), new MyMessageHandler(sessionId)});
            }
        })).option(ChannelOption.TCP_NODELAY, (Object)true)).option(ChannelOption.SO_KEEPALIVE, (Object)true)).connect((SocketAddress)new InetSocketAddress(host, port)).awaitUninterruptibly()).isSuccess()) {
            LOG.info("Connection to IDE established in " + (System.currentTimeMillis() - connectStart) + " ms");
            String projectPathToPreload = System.getProperty(PRELOAD_PROJECT_PATH, null);
            String globalsPathToPreload = System.getProperty(PRELOAD_CONFIG_PATH, null);
            if (projectPathToPreload != null && globalsPathToPreload != null) {
                PreloadedData data;
                ourPreloadedData = data = new PreloadedData();
                try {
                    FileSystemUtil.getAttributes((String)projectPathToPreload);
                    BuildRunner runner = new BuildRunner(new JpsModelLoaderImpl(projectPathToPreload, globalsPathToPreload, null));
                    data.setRunner(runner);
                    File dataStorageRoot = Utils.getDataStorageRoot(projectPathToPreload);
                    BuildFSState fsState = new BuildFSState(false);
                    ProjectDescriptor pd = runner.load(new MessageHandler(){

                        @Override
                        public void processMessage(BuildMessage msg) {
                            data.addMessage(msg);
                        }
                    }, dataStorageRoot, fsState);
                    data.setProjectDescriptor(pd);
                    try {
                        File fsStateFile = new File(dataStorageRoot, "fs_state.dat");
                        DataInputStream in = new DataInputStream(new BufferedInputStream(new FileInputStream(fsStateFile)));
                        try {
                            int version = in.readInt();
                            if (version == 3) {
                                long savedOrdinal = in.readLong();
                                boolean hasWorkToDo = in.readBoolean();
                                fsState.load(in, pd.getModel(), pd.getBuildRootIndex());
                                data.setFsEventOrdinal(savedOrdinal);
                                data.setHasHasWorkToDo(hasWorkToDo);
                            }
                        }
                        finally {
                            in.close();
                        }
                    }
                    catch (FileNotFoundException ignored) {
                    }
                    catch (IOException e) {
                        LOG.info("Error pre-loading FS state", (Throwable)e);
                        fsState.clearAll();
                    }
                    BuildTargetsState targetsState = pd.getTargetsState();
                    for (BuildTarget<?> target : pd.getBuildTargetIndex().getAllTargets()) {
                        targetsState.getTargetConfiguration(target);
                    }
                    BuilderRegistry.getInstance();
                    LOG.info("Pre-loaded process ready in " + (System.currentTimeMillis() - processStart) + " ms");
                }
                catch (Throwable e) {
                    LOG.info("Failed to pre-load project " + projectPathToPreload, e);
                }
            } else if (projectPathToPreload != null || globalsPathToPreload != null) {
                LOG.info("Skipping project pre-loading step: both paths to project configuration files and path to global settings must be specified");
            }
            future.channel().writeAndFlush((Object)CmdlineProtoUtil.toMessage(sessionId, CmdlineProtoUtil.createParamRequest()));
        } else {
            BuildMain.printErrorAndExit(host, port, future.cause());
        }
    }

    private static void printErrorAndExit(String host, int port, Throwable reason) {
        System.err.println("Error connecting to " + host + ":" + port + "; reason: " + (reason != null ? reason.getMessage() : "unknown"));
        if (reason != null) {
            reason.printStackTrace(System.err);
        }
        System.err.println("Exiting.");
        System.exit(-1);
    }

    private static void initLoggers() {
        try {
            String logDir = System.getProperty("jps.log.dir", null);
            File configFile = logDir != null ? new File(logDir, LOG_CONFIG_FILE_NAME) : new File(LOG_CONFIG_FILE_NAME);
            BuildMain.ensureLogConfigExists(configFile);
            String text = FileUtil.loadFile((File)configFile);
            String logFile = logDir != null ? new File(logDir, LOG_FILE_NAME).getAbsolutePath() : LOG_FILE_NAME;
            text = StringUtil.replace((String)text, (String)LOG_FILE_MACRO, (String)StringUtil.replace((String)logFile, (String)"\\", (String)"\\\\"));
            PropertyConfigurator.configure((InputStream)new ByteArrayInputStream(text.getBytes("UTF-8")));
        }
        catch (IOException e) {
            System.err.println("Failed to configure logging: ");
            e.printStackTrace(System.err);
        }
        Logger.setFactory(MyLoggerFactory.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void ensureLogConfigExists(File logConfig) throws IOException {
        if (!logConfig.exists()) {
            FileUtil.createIfDoesntExist((File)logConfig);
            InputStream in = BuildMain.class.getResourceAsStream("/defaultLogConfig.properties");
            if (in != null) {
                try {
                    FileOutputStream out = new FileOutputStream(logConfig);
                    try {
                        FileUtil.copy((InputStream)in, (OutputStream)out);
                    }
                    finally {
                        out.close();
                    }
                }
                finally {
                    in.close();
                }
            }
        }
    }

    static {
        BuildMain.initLoggers();
        LOG = Logger.getInstance((String)"#org.jetbrains.jps.cmdline.BuildMain");
    }

    private static class MyLoggerFactory
    implements Logger.Factory {
        private MyLoggerFactory() {
        }

        public Logger getLoggerInstance(String category) {
            final org.apache.log4j.Logger logger = org.apache.log4j.Logger.getLogger((String)category);
            return new Logger(){

                public boolean isDebugEnabled() {
                    return logger.isDebugEnabled();
                }

                public void debug(@NonNls String message) {
                    logger.debug((Object)message);
                }

                public void debug(Throwable t) {
                    logger.debug((Object)"", t);
                }

                public void debug(@NonNls String message, Throwable t) {
                    logger.debug((Object)message, t);
                }

                public void error(@NonNls String message, Throwable t, String ... details) {
                    logger.error((Object)message, t);
                }

                public void info(@NonNls String message) {
                    logger.info((Object)message);
                }

                public void info(@NonNls String message, Throwable t) {
                    logger.info((Object)message, t);
                }

                public void warn(@NonNls String message, Throwable t) {
                    logger.warn((Object)message, t);
                }

                public void setLevel(Level level) {
                    logger.setLevel(level);
                }
            };
        }
    }

    private static class MyMessageHandler
    extends SimpleChannelInboundHandler<CmdlineRemoteProto.Message> {
        private final UUID mySessionId;
        private volatile BuildSession mySession;

        private MyMessageHandler(UUID sessionId) {
            this.mySessionId = sessionId;
        }

        public void channelRead0(ChannelHandlerContext context, CmdlineRemoteProto.Message message) throws Exception {
            CmdlineRemoteProto.Message.Type type = message.getType();
            final Channel channel = context.channel();
            if (type == CmdlineRemoteProto.Message.Type.CONTROLLER_MESSAGE) {
                CmdlineRemoteProto.Message.ControllerMessage controllerMessage = message.getControllerMessage();
                switch (controllerMessage.getType()) {
                    case BUILD_PARAMETERS: {
                        if (this.mySession == null) {
                            BuildSession session;
                            CmdlineRemoteProto.Message.ControllerMessage.FSEvent delta = controllerMessage.hasFsEvent() ? controllerMessage.getFsEvent() : null;
                            this.mySession = session = new BuildSession(this.mySessionId, channel, controllerMessage.getParamsMessage(), delta, ourPreloadedData);
                            SharedThreadPool.getInstance().executeOnPooledThread(new Runnable(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                @Override
                                public void run() {
                                    try {
                                        try {
                                            session.run();
                                        }
                                        finally {
                                            channel.close();
                                        }
                                    }
                                    finally {
                                        System.exit(0);
                                    }
                                }
                            });
                        } else {
                            LOG.info("Cannot start another build session because one is already running");
                        }
                        return;
                    }
                    case FS_EVENT: {
                        BuildSession session = this.mySession;
                        if (session != null) {
                            session.processFSEvent(controllerMessage.getFsEvent());
                        }
                        return;
                    }
                    case CONSTANT_SEARCH_RESULT: {
                        BuildSession session = this.mySession;
                        if (session != null) {
                            session.processConstantSearchResult(controllerMessage.getConstantSearchResult());
                        }
                        return;
                    }
                    case CANCEL_BUILD_COMMAND: {
                        BuildSession session = this.mySession;
                        if (session != null) {
                            session.cancel();
                        } else {
                            ProjectDescriptor pd;
                            LOG.info("Build canceled, but no build session is running. Exiting.");
                            try {
                                CmdlineRemoteProto.Message.BuilderMessage canceledEvent = CmdlineProtoUtil.createBuildCompletedEvent("build completed", CmdlineRemoteProto.Message.BuilderMessage.BuildEvent.Status.CANCELED);
                                channel.writeAndFlush((Object)CmdlineProtoUtil.toMessage(this.mySessionId, canceledEvent)).await();
                                channel.close();
                            }
                            catch (Throwable e) {
                                LOG.info(e);
                            }
                            Thread.interrupted();
                            PreloadedData preloaded = ourPreloadedData;
                            ProjectDescriptor projectDescriptor = pd = preloaded != null ? preloaded.getProjectDescriptor() : null;
                            if (pd != null) {
                                pd.release();
                            }
                            System.exit(0);
                        }
                        return;
                    }
                }
            }
            channel.writeAndFlush((Object)CmdlineProtoUtil.toMessage(this.mySessionId, CmdlineProtoUtil.createFailure("Unsupported message type: " + type.name(), null)));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void channelInactive(ChannelHandlerContext context) throws Exception {
            try {
                super.channelInactive(context);
            }
            catch (Throwable throwable) {
                new Thread("Shutdown thread"){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            ourEventLoopGroup.shutdownGracefully(0L, 15L, TimeUnit.SECONDS);
                        }
                        finally {
                            System.exit(0);
                        }
                    }
                }.start();
                throw throwable;
            }
            new /* invalid duplicate definition of identical inner class */.start();
        }
    }
}

