/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.cmdline;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import gnu.trove.THashSet;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.jps.api.BuildType;
import org.jetbrains.jps.api.CanceledStatus;
import org.jetbrains.jps.api.CmdlineRemoteProto;
import org.jetbrains.jps.builders.BuildRootDescriptor;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.BuildTargetLoader;
import org.jetbrains.jps.builders.BuildTargetType;
import org.jetbrains.jps.builders.TargetOutputIndex;
import org.jetbrains.jps.builders.impl.BuildDataPathsImpl;
import org.jetbrains.jps.builders.impl.BuildRootIndexImpl;
import org.jetbrains.jps.builders.impl.BuildTargetIndexImpl;
import org.jetbrains.jps.builders.impl.BuildTargetRegistryImpl;
import org.jetbrains.jps.builders.java.dependencyView.Callbacks;
import org.jetbrains.jps.builders.logging.BuildLoggingManager;
import org.jetbrains.jps.cmdline.JpsModelLoader;
import org.jetbrains.jps.cmdline.ProjectDescriptor;
import org.jetbrains.jps.incremental.BuilderRegistry;
import org.jetbrains.jps.incremental.CompileScope;
import org.jetbrains.jps.incremental.CompileScopeImpl;
import org.jetbrains.jps.incremental.IncProjectBuilder;
import org.jetbrains.jps.incremental.MessageHandler;
import org.jetbrains.jps.incremental.RebuildRequestedException;
import org.jetbrains.jps.incremental.TargetTypeRegistry;
import org.jetbrains.jps.incremental.Utils;
import org.jetbrains.jps.incremental.fs.BuildFSState;
import org.jetbrains.jps.incremental.messages.BuildMessage;
import org.jetbrains.jps.incremental.messages.CompilerMessage;
import org.jetbrains.jps.incremental.storage.BuildDataManager;
import org.jetbrains.jps.incremental.storage.BuildTargetsState;
import org.jetbrains.jps.incremental.storage.ProjectTimestamps;
import org.jetbrains.jps.incremental.storage.TimestampStorage;
import org.jetbrains.jps.indices.impl.IgnoredFileIndexImpl;
import org.jetbrains.jps.indices.impl.ModuleExcludeIndexImpl;
import org.jetbrains.jps.model.JpsModel;

public class BuildRunner {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.jps.cmdline.BuildRunner");
    public static final boolean PARALLEL_BUILD_ENABLED = Boolean.parseBoolean(System.getProperty("compile.parallel", "false"));
    private static final boolean STORE_TEMP_CACHES_IN_MEMORY = PARALLEL_BUILD_ENABLED || Boolean.valueOf(System.getProperty("use.memory.temp.cache", "true")) != false;
    private final JpsModelLoader myModelLoader;
    private List<String> myFilePaths = Collections.emptyList();
    private Map<String, String> myBuilderParams = Collections.emptyMap();
    private boolean myForceCleanCaches;

    public BuildRunner(JpsModelLoader modelLoader) {
        this.myModelLoader = modelLoader;
    }

    public void setFilePaths(List<String> filePaths) {
        this.myFilePaths = filePaths != null ? filePaths : Collections.emptyList();
    }

    public void setBuilderParams(Map<String, String> builderParams) {
        this.myBuilderParams = builderParams != null ? builderParams : Collections.emptyMap();
    }

    public ProjectDescriptor load(MessageHandler msgHandler, File dataStorageRoot, BuildFSState fsState) throws IOException {
        JpsModel jpsModel = this.myModelLoader.loadModel();
        BuildDataPathsImpl dataPaths = new BuildDataPathsImpl(dataStorageRoot);
        BuildTargetRegistryImpl targetRegistry = new BuildTargetRegistryImpl(jpsModel);
        ModuleExcludeIndexImpl index = new ModuleExcludeIndexImpl(jpsModel);
        IgnoredFileIndexImpl ignoredFileIndex = new IgnoredFileIndexImpl(jpsModel);
        BuildRootIndexImpl buildRootIndex = new BuildRootIndexImpl(targetRegistry, jpsModel, index, dataPaths, ignoredFileIndex);
        BuildTargetIndexImpl targetIndex = new BuildTargetIndexImpl(targetRegistry, buildRootIndex);
        BuildTargetsState targetsState = new BuildTargetsState(dataPaths, jpsModel, buildRootIndex);
        ProjectTimestamps projectTimestamps = null;
        BuildDataManager dataManager = null;
        try {
            projectTimestamps = new ProjectTimestamps(dataStorageRoot, targetsState);
            dataManager = new BuildDataManager(dataPaths, targetsState, STORE_TEMP_CACHES_IN_MEMORY);
            if (dataManager.versionDiffers()) {
                this.myForceCleanCaches = true;
                msgHandler.processMessage(new CompilerMessage("build", BuildMessage.Kind.INFO, "Dependency data format has changed, project rebuild required"));
            }
        }
        catch (Exception e) {
            LOG.info((Throwable)e);
            if (projectTimestamps != null) {
                projectTimestamps.close();
            }
            if (dataManager != null) {
                dataManager.close();
            }
            this.myForceCleanCaches = true;
            FileUtil.delete((File)dataStorageRoot);
            targetsState = new BuildTargetsState(dataPaths, jpsModel, buildRootIndex);
            projectTimestamps = new ProjectTimestamps(dataStorageRoot, targetsState);
            dataManager = new BuildDataManager(dataPaths, targetsState, STORE_TEMP_CACHES_IN_MEMORY);
            msgHandler.processMessage(new CompilerMessage("build", BuildMessage.Kind.INFO, "Project rebuild forced: " + e.getMessage()));
        }
        return new ProjectDescriptor(jpsModel, fsState, projectTimestamps, dataManager, BuildLoggingManager.DEFAULT, index, targetsState, targetIndex, buildRootIndex, ignoredFileIndex);
    }

    public void setForceCleanCaches(boolean forceCleanCaches) {
        this.myForceCleanCaches = forceCleanCaches;
    }

    public void runBuild(ProjectDescriptor pd, CanceledStatus cs, Callbacks.ConstantAffectionResolver constantSearch, MessageHandler msgHandler, BuildType buildType, List<CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope> scopes, boolean includeDependenciesToScope) throws Exception {
        for (int attempt = 0; attempt < 2; ++attempt) {
            boolean forceClean = this.myForceCleanCaches && this.myFilePaths.isEmpty();
            CompileScope compileScope = BuildRunner.createCompilationScope(pd, scopes, this.myFilePaths, forceClean, includeDependenciesToScope);
            IncProjectBuilder builder = new IncProjectBuilder(pd, BuilderRegistry.getInstance(), this.myBuilderParams, cs, constantSearch, Utils.IS_TEST_MODE);
            builder.addMessageHandler(msgHandler);
            try {
                switch (buildType) {
                    case BUILD: {
                        builder.build(compileScope, forceClean);
                        break;
                    }
                    case CLEAN: {
                        break;
                    }
                    case UP_TO_DATE_CHECK: {
                        builder.checkUpToDate(compileScope);
                    }
                }
                break;
            }
            catch (RebuildRequestedException e) {
                if (attempt != 0) {
                    throw e;
                }
                LOG.info((Throwable)e);
                this.myForceCleanCaches = true;
                continue;
            }
        }
    }

    private static CompileScope createCompilationScope(ProjectDescriptor pd, List<CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope> scopes, Collection<String> paths, boolean forceClean, boolean includeDependenciesToScope) throws Exception {
        Map<BuildTarget<?>, Set<File>> files;
        HashSet targetTypes = new HashSet();
        HashSet targetTypesToForceBuild = new HashSet();
        HashSet targets = new HashSet();
        TargetTypeRegistry typeRegistry = TargetTypeRegistry.getInstance();
        for (CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope scope : scopes) {
            BuildTargetType<?> targetType = typeRegistry.getTargetType(scope.getTypeId());
            if (targetType == null) {
                LOG.info("Unknown target type: " + scope.getTypeId());
                continue;
            }
            if (scope.getForceBuild() || forceClean) {
                targetTypesToForceBuild.add(targetType);
            }
            if (scope.getAllTargets()) {
                targetTypes.add(targetType);
                continue;
            }
            BuildTargetLoader<?> loader = targetType.createLoader(pd.getModel());
            for (String targetId : scope.getTargetIdList()) {
                Object target = loader.createTarget(targetId);
                if (target != null) {
                    targets.add((BuildTarget<?>)target);
                    continue;
                }
                LOG.info("Unknown " + targetType + " target id: " + targetId);
            }
        }
        if (includeDependenciesToScope) {
            BuildRunner.includeDependenciesToScope(targetTypes, targets, targetTypesToForceBuild, pd);
        }
        TimestampStorage timestamps = pd.timestamps.getStorage();
        if (!paths.isEmpty()) {
            files = new HashMap();
            for (String path : paths) {
                File file = new File(path);
                Collection descriptors = pd.getBuildRootIndex().findAllParentDescriptors(file, null);
                for (BuildRootDescriptor descriptor : descriptors) {
                    THashSet fileSet = files.get(descriptor.getTarget());
                    if (fileSet == null) {
                        fileSet = new THashSet(FileUtil.FILE_HASHING_STRATEGY);
                        files.put(descriptor.getTarget(), (Set<File>)fileSet);
                    }
                    fileSet.add((File)file);
                    if (!targetTypesToForceBuild.contains(descriptor.getTarget().getTargetType())) continue;
                    pd.fsState.markDirty(null, file, descriptor, timestamps, false);
                }
            }
        } else {
            files = Collections.emptyMap();
        }
        return new CompileScopeImpl(targetTypes, targetTypesToForceBuild, targets, files);
    }

    private static void includeDependenciesToScope(Set<BuildTargetType<?>> targetTypes, Set<BuildTarget<?>> targets, Set<BuildTargetType<?>> targetTypesToForceBuild, ProjectDescriptor descriptor) {
        TargetOutputIndex dummyIndex = new TargetOutputIndex(){

            @Override
            public Collection<BuildTarget<?>> getTargetsByOutputFile(File file) {
                return Collections.emptyList();
            }
        };
        ArrayList<BuildTarget<?>> current = new ArrayList(targets);
        while (!current.isEmpty()) {
            ArrayList next = new ArrayList();
            for (BuildTarget buildTarget : current) {
                for (BuildTarget<?> depTarget : buildTarget.computeDependencies(descriptor.getBuildTargetIndex(), dummyIndex)) {
                    if (targets.contains(depTarget) || targetTypes.contains(depTarget.getTargetType())) continue;
                    next.add(depTarget);
                    if (!targetTypesToForceBuild.contains(buildTarget.getTargetType())) continue;
                    targetTypesToForceBuild.add(depTarget.getTargetType());
                }
            }
            targets.addAll(next);
            current = next;
        }
    }
}

