/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.instrumentation;

import com.intellij.compiler.instrumentation.InstrumentationClassFinder;
import com.intellij.compiler.notNullVerification.NotNullVerifyingInstrumenter;
import java.io.File;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.cmdline.ProjectDescriptor;
import org.jetbrains.jps.incremental.BinaryContent;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.CompiledClass;
import org.jetbrains.jps.incremental.instrumentation.BaseInstrumentingBuilder;
import org.jetbrains.jps.incremental.messages.BuildMessage;
import org.jetbrains.jps.incremental.messages.CompilerMessage;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.ClassWriter;

public class NotNullInstrumentingBuilder
extends BaseInstrumentingBuilder {
    @Override
    public String getPresentableName() {
        return "NotNull instrumentation";
    }

    @Override
    protected String getProgressMessage() {
        return "Adding @NotNull assertions...";
    }

    @Override
    protected boolean isEnabled(CompileContext context, ModuleChunk chunk) {
        ProjectDescriptor pd = context.getProjectDescriptor();
        return JpsJavaExtensionService.getInstance().getOrCreateCompilerConfiguration(pd.getProject()).isAddNotNullAssertions();
    }

    @Override
    protected boolean canInstrument(CompiledClass compiledClass, int classFileVersion) {
        return classFileVersion >= 49;
    }

    @Override
    protected BinaryContent instrument(CompileContext context, CompiledClass compiledClass, ClassReader reader, ClassWriter writer, InstrumentationClassFinder finder) {
        try {
            if (NotNullVerifyingInstrumenter.processClassFile((ClassReader)reader, (ClassVisitor)writer)) {
                return new BinaryContent(writer.toByteArray());
            }
        }
        catch (Throwable e) {
            StringBuilder msg = new StringBuilder();
            msg.append("@NotNull instrumentation failed ");
            File sourceFile = compiledClass.getSourceFile();
            msg.append(" for ").append(sourceFile.getName());
            msg.append(": ").append(e.getMessage());
            context.processMessage(new CompilerMessage(this.getPresentableName(), BuildMessage.Kind.ERROR, msg.toString(), sourceFile.getPath()));
        }
        return null;
    }
}

