/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.javac;

import com.intellij.openapi.util.io.FileUtilRt;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import org.jetbrains.jps.incremental.BinaryContent;
import org.jetbrains.jps.incremental.Utils;
import org.jetbrains.jps.javac.JavacFileManager;

public final class OutputFileObject
extends SimpleJavaFileObject {
    private final JavacFileManager.Context myContext;
    private final File myOutputRoot;
    private final String myRelativePath;
    private final File myFile;
    private final String myClassName;
    private final URI mySourceUri;
    private volatile BinaryContent myContent;
    private final File mySourceFile;
    private final String myEncodingName;

    public OutputFileObject(JavacFileManager.Context context, File outputRoot, String relativePath, File file, JavaFileObject.Kind kind, String className, URI sourceUri, String encodingName) {
        this(context, outputRoot, relativePath, file, kind, className, sourceUri, encodingName, null);
    }

    public OutputFileObject(JavacFileManager.Context context, File outputRoot, String relativePath, File file, JavaFileObject.Kind kind, String className, URI srcUri, String encodingName, BinaryContent content) {
        super(Utils.toURI(file.getPath()), kind);
        this.myContext = context;
        this.mySourceUri = srcUri;
        this.myContent = content;
        this.myOutputRoot = outputRoot;
        this.myRelativePath = relativePath;
        this.myFile = file;
        this.myClassName = className != null ? className.replace('/', '.') : null;
        this.mySourceFile = srcUri != null ? Utils.convertToFile(srcUri) : null;
        this.myEncodingName = encodingName;
    }

    public File getOutputRoot() {
        return this.myOutputRoot;
    }

    public String getRelativePath() {
        return this.myRelativePath;
    }

    public File getFile() {
        return this.myFile;
    }

    public String getClassName() {
        return this.myClassName;
    }

    public File getSourceFile() {
        return this.mySourceFile;
    }

    public URI getSourceUri() {
        return this.mySourceUri;
    }

    @Override
    public ByteArrayOutputStream openOutputStream() {
        return new ByteArrayOutputStream(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void close() throws IOException {
                try {
                    super.close();
                }
                finally {
                    OutputFileObject.this.myContent = new BinaryContent(this.buf, 0, this.size());
                    if (OutputFileObject.this.myContext != null) {
                        OutputFileObject.this.myContext.consumeOutputFile(OutputFileObject.this);
                    }
                }
            }
        };
    }

    @Override
    public InputStream openInputStream() throws IOException {
        BinaryContent bytes = this.myContent;
        if (bytes != null) {
            return new ByteArrayInputStream(bytes.getBuffer(), bytes.getOffset(), bytes.getLength());
        }
        return new BufferedInputStream(new FileInputStream(this.myFile));
    }

    @Override
    public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
        BinaryContent content = this.myContent;
        if (content != null) {
            return new String(content.getBuffer(), content.getOffset(), content.getLength());
        }
        return FileUtilRt.loadFile((File)this.myFile, (String)this.myEncodingName, (boolean)false);
    }

    public BinaryContent getContent() {
        return this.myContent;
    }

    public void updateContent(byte[] updatedContent) {
        this.myContent = new BinaryContent(updatedContent, 0, updatedContent.length);
    }

    public int hashCode() {
        return this.toUri().hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof JavaFileObject && this.toUri().equals(((JavaFileObject)obj).toUri());
    }
}

