/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.idea.appengine.action;

import com.android.tools.idea.gradle.parser.BuildFileKey;
import com.android.tools.idea.gradle.parser.BuildFileStatement;
import com.android.tools.idea.gradle.parser.Dependency;
import com.android.tools.idea.gradle.parser.GradleBuildFile;
import com.android.tools.idea.gradle.project.GradleProjectImporter;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.templates.Parameter;
import com.android.tools.idea.templates.Template;
import com.android.tools.idea.templates.TemplateUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gct.idea.appengine.dom.WebApp;
import com.google.gct.idea.appengine.gradle.facet.AppEngineGradleFacet;
import com.google.gct.idea.appengine.util.AppEngineUtils;
import com.google.gct.idea.appengine.util.PsiUtils;
import com.google.gct.idea.appengine.wizard.CloudTemplateUtils;
import com.google.gct.login.stats.UsageTrackerService;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.actions.ReformatCodeProcessor;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.impl.source.PsiJavaFileImpl;
import com.intellij.util.ArrayUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NonNls;

public class NewEndpointFromClassAction
extends AnAction {
    private static final Logger LOG = Logger.getInstance(NewEndpointFromClassAction.class);
    private static final String COMPILE_DIRTY_ACTION_ID = "CompileDirty";
    private static final String ENTITY_NAME = "entityName";
    private static final String ENTITY_TYPE = "entityType";
    private static final String ENDPOINT_TEMPLATE = "EndpointFromClass";
    private static final String ENDPOINT_CLASS_SUFFIX = "Endpoint";
    private static final String ERROR_MESSAGE_TITLE = "Failed to Generate Endpoint Class";
    private static final String DEFAULT_ERROR_MESSAGE = "Error occurred while generating Endpoint class";
    private static final String ENDPOINTS_DEPENDENCY = "com.google.appengine:appengine-endpoints:";
    private static final String ENDPOINTS_DEPS_DEPENDENCY = "com.google.appengine:appengine-endpoints-deps:";
    private static final String ENDPOINTS_SERVLET_CLASS = "com.google.api.server.spi.SystemServiceServlet";
    private static final String ENDOINTS_SERVLET_NAME = "SystemServiceServlet";
    private static final String ENDPOINTS_SERVICES_INIT_PARAM_NAME = "services";
    private static final String OBJECTIFY_ENTITY_ANNOTATION = "com.googlecode.objectify.annotation.Entity";
    private static final String OBJECTIFY_ID_ANNOTATION = "com.googlecode.objectify.annotation.Id";
    private static final String OBJECTIFY_FILTER_NAME = "ObjectifyFilter";
    private static final String OBJECTIFY_FQ_FILTER_CLASS = "com.googlecode.objectify.ObjectifyFilter";

    public void update(AnActionEvent e) {
        if (ActionPlaces.isPopupPlace((String)e.getPlace())) {
            e.getPresentation().setVisible(NewEndpointFromClassAction.shouldDisplayAction(e));
        }
    }

    private static boolean shouldDisplayAction(AnActionEvent e) {
        if (!AppEngineUtils.isAppEngineModule((Module)((Module)e.getData(LangDataKeys.MODULE)))) {
            return false;
        }
        PsiFile psiFile = (PsiFile)e.getData(LangDataKeys.PSI_FILE);
        if (psiFile == null || !(psiFile instanceof PsiJavaFileImpl)) {
            return false;
        }
        Module srcModule = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiFile);
        if (srcModule == null) {
            return false;
        }
        return ProjectRootManager.getInstance((Project)srcModule.getProject()).getFileIndex().getSourceRootForFile(psiFile.getVirtualFile()) != null;
    }

    public void actionPerformed(AnActionEvent e) {
        PsiJavaFile psiJavaFile = PsiUtils.getPsiJavaFileFromContext((AnActionEvent)e);
        Project project = e.getProject();
        Module module = (Module)e.getData(LangDataKeys.MODULE);
        if (psiJavaFile == null || module == null || project == null) {
            Messages.showErrorDialog((Project)project, (String)"Please select a Java file to create an Endpoint for.", (String)ERROR_MESSAGE_TITLE);
            return;
        }
        if (!AppEngineUtils.isAppEngineModule((Module)module)) {
            Messages.showErrorDialog((Project)project, (String)"Endpoints can only be generated for App Engine projects.", (String)ERROR_MESSAGE_TITLE);
            return;
        }
        String packageName = psiJavaFile.getPackageName();
        PsiDirectory psiJavaFileContainingDirectory = psiJavaFile.getContainingDirectory();
        if (psiJavaFileContainingDirectory == null) {
            Messages.showErrorDialog((Project)project, (String)DEFAULT_ERROR_MESSAGE, (String)ERROR_MESSAGE_TITLE);
        }
        String directory = psiJavaFileContainingDirectory.getVirtualFile().getPath();
        PsiClass[] psiClasses = psiJavaFile.getClasses();
        if (psiClasses.length > 1) {
            Messages.showErrorDialog((Project)project, (String)"We only support generating an endpoint from Java files with one top level class.", (String)"Error Generating Endpoint");
            return;
        }
        if (psiClasses.length == 0) {
            Messages.showErrorDialog((Project)project, (String)"This Java file does not contain any classes.", (String)"Error Generating Endpoint");
            return;
        }
        PsiClass resourcePsiClass = psiClasses[0];
        boolean isObjectifyEntity = AnnotationUtil.isAnnotated((PsiModifierListOwner)resourcePsiClass, (String)OBJECTIFY_ENTITY_ANNOTATION, (boolean)true);
        String idType = null;
        String idName = null;
        String idGetterName = null;
        if (isObjectifyEntity) {
            for (PsiField psiField : resourcePsiClass.getAllFields()) {
                if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)psiField, (String)OBJECTIFY_ID_ANNOTATION, (boolean)false)) continue;
                idType = psiField.getType().getPresentableText();
                idName = psiField.getName();
            }
            if (idType == null) {
                Messages.showErrorDialog((Project)project, (String)"Please add the required @Id annotation to your entity before trying to generate an endpoint from this class.", (String)"Error Generating Objectify Endpoint.");
                return;
            }
            idGetterName = NewEndpointFromClassAction.getIdGetter(resourcePsiClass, idName);
        }
        String fileName = psiJavaFile.getName();
        String classType = fileName.substring(0, fileName.lastIndexOf(46));
        NewEndpointFromClassAction.doAction(project, module, packageName, directory, classType, isObjectifyEntity, idType, idName, idGetterName);
        AnAction compileDirty = ActionManager.getInstance().getAction(COMPILE_DIRTY_ACTION_ID);
        if (compileDirty != null) {
            compileDirty.actionPerformed(e);
        }
    }

    private static String getIdGetter(PsiClass resourcePsiClass, String idName) {
        PsiMethod[] idGetterMethods = resourcePsiClass.findMethodsByName("get" + StringUtil.capitalize((String)idName), true);
        if (idGetterMethods.length == 0) {
            return null;
        }
        for (PsiMethod idGetterMethod : idGetterMethods) {
            if (idGetterMethod.getParameterList().getParametersCount() != 0) continue;
            return idGetterMethod.getName();
        }
        return null;
    }

    private static void doAction(Project project, Module module, String packageName, String directory, @NonNls String classType, boolean isObjectifyEntity, String idType, String idName, String idGetterName) {
        if (classType.isEmpty()) {
            Messages.showErrorDialog((Project)project, (String)"Class object is required for Endpoint generation", (String)ERROR_MESSAGE_TITLE);
            return;
        }
        String endpointFileName = directory + "/" + classType + ENDPOINT_CLASS_SUFFIX + ".java";
        String endpointFQClassName = packageName + "." + classType + ENDPOINT_CLASS_SUFFIX;
        File temp = new File(endpointFileName);
        if (temp.exists()) {
            Messages.showErrorDialog((Project)project, (String)("'" + temp.getName() + "\" already exists"), (String)ERROR_MESSAGE_TITLE);
            return;
        }
        CloudTemplateUtils.TemplateInfo templateInfo = CloudTemplateUtils.getTemplate(ENDPOINT_TEMPLATE);
        if (templateInfo == null) {
            LOG.error("Failed to load endpoint template info: EndpointFromClass");
            Messages.showErrorDialog((Project)project, (String)DEFAULT_ERROR_MESSAGE, (String)ERROR_MESSAGE_TITLE);
            return;
        }
        final Template template = Template.createFromPath((File)templateInfo.getFile());
        final File projectRoot = new File(project.getBasePath());
        final File moduleRoot = new File(projectRoot, module.getName());
        final HashMap replacementMap = Maps.newHashMap();
        try {
            replacementMap.put("projectOut", moduleRoot.getCanonicalPath());
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            Messages.showErrorDialog((String)("Failed to resolve Module output destination : " + e.getMessage()), (String)ERROR_MESSAGE_TITLE);
            return;
        }
        String className = String.valueOf(Character.toLowerCase(classType.charAt(0)));
        if (classType.length() > 1) {
            className = className + classType.substring(1);
        }
        replacementMap.put("isObjectified", isObjectifyEntity);
        replacementMap.put("idType", idType);
        replacementMap.put("idName", idName);
        replacementMap.put("idGetterName", idGetterName);
        replacementMap.put(ENTITY_NAME, className);
        replacementMap.put(ENTITY_TYPE, classType);
        replacementMap.put("srcDir", directory);
        replacementMap.put("packageName", packageName);
        replacementMap.put("endpointOwnerDomain", StringUtil.join((String[])((String[])ArrayUtil.reverseArray((Object[])packageName.split("\\."))), (String)"."));
        replacementMap.put("endpointPackagePath", "");
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                template.render(projectRoot, moduleRoot, replacementMap);
            }
        });
        NewEndpointFromClassAction.updateBuildFile(project, module, template);
        NewEndpointFromClassAction.updateWebXml(project, module, endpointFQClassName, isObjectifyEntity);
        VirtualFile endpointFile = LocalFileSystem.getInstance().findFileByPath(endpointFileName);
        new ReformatCodeProcessor(project, PsiManager.getInstance((Project)project).findFile(endpointFile), null, false).run();
        TemplateUtils.openEditor((Project)project, (VirtualFile)endpointFile);
        UsageTrackerService.getInstance().trackEvent("com.google.cloud.tools", "new.endpoint", isObjectifyEntity ? "objectify" : "pojo", null);
    }

    private static void updateWebXml(Project project, Module module, String endpointFQClassName, boolean isObjectifyEndpoint) {
        String result;
        AppEngineGradleFacet facet = AppEngineGradleFacet.getAppEngineFacetByModule((Module)module);
        final WebApp webApp = facet.getWebXmlForEdit();
        if (isObjectifyEndpoint && !NewEndpointFromClassAction.hasObjectifyFilter(webApp)) {
            CommandProcessor.getInstance().executeCommand(project, new Runnable(){

                @Override
                public void run() {
                    ApplicationManager.getApplication().runWriteAction(new Runnable(){

                        @Override
                        public void run() {
                            WebApp.Filter objectifyFilter = webApp.addFilter();
                            WebApp.FilterMapping filterMapping = webApp.addFilterMapping();
                            objectifyFilter.getFilterName().setValue((Object)NewEndpointFromClassAction.OBJECTIFY_FILTER_NAME);
                            objectifyFilter.getFilterClass().setValue((Object)NewEndpointFromClassAction.OBJECTIFY_FQ_FILTER_CLASS);
                            filterMapping.getFilterName().setValue((Object)NewEndpointFromClassAction.OBJECTIFY_FILTER_NAME);
                            filterMapping.getUrlPattern().setValue((Object)"/*");
                        }
                    });
                }
            }, "Update App Engine web.xml", null);
        }
        if ((result = NewEndpointFromClassAction.validateWebXml(webApp)) != null) {
            Messages.showErrorDialog((String)result, (String)ERROR_MESSAGE_TITLE);
            return;
        }
        WebApp.Servlet.InitParam.ParamValue endpointServletParamValue = NewEndpointFromClassAction.getEndpointServletInitParam(webApp);
        if (endpointServletParamValue == null) {
            Messages.showErrorDialog((String)"Could not find a correctly configured SystemServiceServlet in this module's web.xml", (String)ERROR_MESSAGE_TITLE);
        } else {
            NewEndpointFromClassAction.addEndpointClassToInitParam(project, endpointServletParamValue, endpointFQClassName);
        }
    }

    private static boolean hasObjectifyFilter(WebApp webApp) {
        for (WebApp.Filter filter : webApp.getFilters()) {
            if (!filter.getFilterName().getStringValue().trim().equals(OBJECTIFY_FILTER_NAME)) continue;
            return true;
        }
        return false;
    }

    private static WebApp.Servlet.InitParam.ParamValue getEndpointServletInitParam(WebApp webApp) {
        for (WebApp.Servlet servlet : webApp.getServlets()) {
            String servletName = (String)servlet.getServletName().getValue();
            String servletClass = (String)servlet.getServletClass().getValue();
            if (servletName == null || servletClass == null || !servletName.equals(ENDOINTS_SERVLET_NAME) || !servletClass.equals(ENDPOINTS_SERVLET_CLASS) || servlet.getInitParams() == null) continue;
            for (WebApp.Servlet.InitParam initParam : servlet.getInitParams()) {
                String paramName = (String)initParam.getParamName().getValue();
                if (paramName == null || !paramName.equals(ENDPOINTS_SERVICES_INIT_PARAM_NAME)) continue;
                return initParam.getParamValue();
            }
        }
        return null;
    }

    private static String validateWebXml(WebApp webApp) {
        if (webApp == null) {
            return "This App Engine module's web.xml could not be updated as the file failed to load.";
        }
        if (webApp.getServlets() == null) {
            return "This App Engine module's web.xml does not contain the required SystemServiceServlet servlet.";
        }
        return null;
    }

    private static void addEndpointClassToInitParam(Project project, final WebApp.Servlet.InitParam.ParamValue initParamValue, String endpointFQClassName) {
        if (((String)initParamValue.getValue()).contains(endpointFQClassName)) {
            return;
        }
        final String initParamValueString = ((String)initParamValue.getValue()).trim().isEmpty() ? endpointFQClassName : (String)initParamValue.getValue() + ", " + endpointFQClassName;
        CommandProcessor.getInstance().executeCommand(project, new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        initParamValue.setValue((Object)initParamValueString);
                    }
                });
            }
        }, "Update App Engine web.xml", null);
    }

    private static void updateBuildFile(@NonNls Project project, Module module, @NonNls Template template) {
        VirtualFile buildFile = GradleUtil.getGradleBuildFile((Module)module);
        if (buildFile == null) {
            Messages.showErrorDialog((String)("Cannot find gradle build file for module \"" + module.getName() + "\""), (String)ERROR_MESSAGE_TITLE);
            return;
        }
        Parameter appEngineVersionParam = template.getMetadata().getParameter("appEngineVersion");
        String appEngineVersion = appEngineVersionParam == null ? "+" : appEngineVersionParam.initial;
        final GradleBuildFile gradleBuildFile = new GradleBuildFile(buildFile, project);
        Dependency endpointDependency = new Dependency(Dependency.Scope.COMPILE, Dependency.Type.EXTERNAL, (Object)(ENDPOINTS_DEPENDENCY + appEngineVersion));
        Dependency endpointDepsDependency = new Dependency(Dependency.Scope.COMPILE, Dependency.Type.EXTERNAL, (Object)(ENDPOINTS_DEPS_DEPENDENCY + appEngineVersion));
        ArrayList missingDependencies = Lists.newArrayList();
        if (!gradleBuildFile.hasDependency((BuildFileStatement)endpointDependency)) {
            missingDependencies.add(endpointDependency);
        }
        if (!gradleBuildFile.hasDependency((BuildFileStatement)endpointDepsDependency)) {
            missingDependencies.add(endpointDepsDependency);
        }
        if (!missingDependencies.isEmpty()) {
            final List currentDependencies = gradleBuildFile.getDependencies();
            currentDependencies.addAll(missingDependencies);
            WriteCommandAction.runWriteCommandAction((Project)project, (Runnable)new Runnable(){

                @Override
                public void run() {
                    gradleBuildFile.setValue(BuildFileKey.DEPENDENCIES, (Object)currentDependencies);
                }
            });
            GradleProjectImporter.getInstance().requestProjectSync(project, null);
        }
    }
}

