/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.idea.samples;

import com.android.tools.idea.wizard.dynamic.DynamicWizardStepWithHeaderAndDescription;
import com.android.tools.idea.wizard.dynamic.ScopedDataBinder;
import com.android.tools.idea.wizard.dynamic.ScopedStateStore;
import com.android.utils.HtmlBuilder;
import com.appspot.gsamplesindex.samplesindex.model.Sample;
import com.appspot.gsamplesindex.samplesindex.model.SampleCollection;
import com.google.common.base.Strings;
import com.google.gct.idea.samples.SampleImportTreeManager;
import com.google.gct.idea.samples.SampleImportWizardPath;
import com.google.gct.idea.samples.SamplePreviewPanel;
import com.google.gct.idea.util.GctBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.BadLocationException;

public class SampleBrowserStep
extends DynamicWizardStepWithHeaderAndDescription {
    private Tree mySampleTree;
    private SampleImportTreeManager mySampleTreeManager;
    private JPanel myPanel;
    private HyperlinkLabel myUrlField;
    private JBLabel myDescriptionLabel;
    private SearchTextField mySearchBox;
    private JPanel myDescriptionPanel;
    private SamplePreviewPanel mySamplePreviewPanel;
    private JBScrollPane mySamplePreviewScrollPanel;
    private final SampleCollection mySampleList;
    private static final ScopedStateStore.Key<Sample> SAMPLE_SCREENSHOT = ScopedStateStore.createKey((String)"SampleScreenshot", (ScopedStateStore.Scope)ScopedStateStore.Scope.STEP, Sample.class);

    public SampleBrowserStep(SampleCollection sampleList, Disposable parentDisposable) {
        super(GctBundle.message("sample.browser.title", new Object[0]), GctBundle.message("sample.browser.subtitle", new Object[0]), parentDisposable);
        this.mySampleList = sampleList;
        this.$$$setupUI$$$();
        this.setBodyComponent(this.myPanel);
    }

    public void init() {
        super.init();
        this.initSamplesTree();
        this.register(SampleImportWizardPath.SAMPLE_URL, (JComponent)this.myUrlField, (ScopedDataBinder.ComponentBinding)new ScopedDataBinder.ComponentBinding<String, HyperlinkLabel>(){

            public void setValue(String newValue, HyperlinkLabel component) {
                component.setHyperlinkTarget(newValue);
                newValue = StringUtil.isEmpty((String)newValue) ? "" : GctBundle.message("sample.browse.source", new Object[0]);
                component.setHyperlinkText(newValue);
            }
        });
        this.register(SAMPLE_SCREENSHOT, this.mySamplePreviewPanel, new SamplePreviewComponentBinding());
        this.registerValueDeriver(SampleImportWizardPath.SAMPLE_URL, new SampleUrlValueDeriver());
        this.registerValueDeriver(SAMPLE_SCREENSHOT, new SamplePreviewDeriver());
        this.registerValueDeriver(KEY_DESCRIPTION, new DescriptionValueDeriver());
        this.mySearchBox.addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                try {
                    String keyword = e.getDocument().getText(0, e.getDocument().getLength());
                    SampleBrowserStep.this.mySampleTreeManager.filterTree(keyword);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        });
        this.myUrlField.setOpaque(false);
        this.myDescriptionPanel.setBackground(UIUtil.getTextFieldBackground());
        this.mySamplePreviewScrollPanel.getVerticalScrollBar().setUnitIncrement(16);
    }

    public JComponent getPreferredFocusedComponent() {
        return this.mySearchBox;
    }

    public String getStepName() {
        return GctBundle.message("sample.browser.title", new Object[0]);
    }

    public boolean validate() {
        if (this.myState.get(SampleImportWizardPath.SAMPLE_KEY) == null) {
            this.setErrorHtml(GctBundle.message("sample.browser.please.select", new Object[0]));
            return false;
        }
        this.setErrorHtml("");
        return true;
    }

    protected void initSamplesTree() {
        this.mySampleTreeManager = new SampleImportTreeManager(this.mySampleTree, this.mySampleList);
        this.myState.put(SampleImportWizardPath.SAMPLE_KEY, (Object)this.mySampleTreeManager.getSelectedSample());
        this.register(SampleImportWizardPath.SAMPLE_KEY, (JComponent)this.mySampleTree, (ScopedDataBinder.ComponentBinding)new ScopedDataBinder.ComponentBinding<Sample, Tree>(){

            public Sample getValue(Tree component) {
                return SampleBrowserStep.this.mySampleTreeManager.getSelectedSample();
            }

            public void addActionListener(ActionListener listener, Tree component) {
                component.addTreeSelectionListener((TreeSelectionListener)new SampleSelectionListener(listener));
            }
        });
    }

    protected JLabel getDescriptionLabel() {
        return this.myDescriptionLabel;
    }

    protected DynamicWizardStepWithHeaderAndDescription.WizardStepHeaderSettings getStepHeader() {
        return DynamicWizardStepWithHeaderAndDescription.WizardStepHeaderSettings.createProductHeader((String)GctBundle.message("sample.import.title", new Object[0]));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        SamplePreviewPanel samplePreviewPanel;
        JBScrollPane jBScrollPane;
        HyperlinkLabel hyperlinkLabel;
        JBLabel jBLabel;
        JPanel jPanel;
        Tree tree;
        SearchTextField searchTextField;
        JPanel jPanel2;
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, true, false));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.mySearchBox = searchTextField = new SearchTextField();
        searchTextField.setToolTipText("Search by Name or Key Word");
        jPanel3.add((Component)searchTextField, new GridConstraints(0, 0, 1, 1, 1, 1, 3, 3, null, null, null));
        JBScrollPane jBScrollPane2 = new JBScrollPane();
        jBScrollPane2.setEnabled(true);
        jPanel3.add((Component)jBScrollPane2, new GridConstraints(1, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        this.mySampleTree = tree = new Tree();
        jBScrollPane2.setViewportView((Component)tree);
        JTabbedPane jTabbedPane = new JTabbedPane();
        jPanel2.add((Component)jTabbedPane, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        JBScrollPane jBScrollPane3 = new JBScrollPane();
        jBScrollPane3.setHorizontalScrollBarPolicy(31);
        jTabbedPane.addTab("Description", null, (Component)jBScrollPane3, null);
        this.myDescriptionPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBScrollPane3.setViewportView(jPanel);
        this.myDescriptionLabel = jBLabel = new JBLabel();
        jBLabel.setVerticalAlignment(1);
        jBLabel.setVerticalTextPosition(1);
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myUrlField = hyperlinkLabel = new HyperlinkLabel();
        jPanel.add((Component)hyperlinkLabel, new GridConstraints(1, 0, 1, 1, 0, 3, 7, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.mySamplePreviewScrollPanel = jBScrollPane = new JBScrollPane();
        jBScrollPane.setVerticalScrollBarPolicy(22);
        jBScrollPane.setHorizontalScrollBarPolicy(31);
        jTabbedPane.addTab("Preview", null, (Component)jBScrollPane, null);
        this.mySamplePreviewPanel = samplePreviewPanel = new SamplePreviewPanel();
        jBScrollPane.setViewportView(samplePreviewPanel);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private static class SamplePreviewDeriver
    extends ScopedDataBinder.ValueDeriver<Sample> {
        private SamplePreviewDeriver() {
        }

        public Set<ScopedStateStore.Key<?>> getTriggerKeys() {
            HashSet filterKeys = new HashSet(1);
            filterKeys.add(SampleImportWizardPath.SAMPLE_KEY);
            return filterKeys;
        }

        public Sample deriveValue(ScopedStateStore state, ScopedStateStore.Key changedKey, Sample currentValue) {
            return (Sample)state.get(SampleImportWizardPath.SAMPLE_KEY);
        }
    }

    private static class SamplePreviewComponentBinding
    extends ScopedDataBinder.ComponentBinding<Sample, SamplePreviewPanel> {
        private SamplePreviewComponentBinding() {
        }

        public void setValue(Sample sample, SamplePreviewPanel component) {
            component.setSample(sample);
        }
    }

    private static class DescriptionValueDeriver
    extends ScopedDataBinder.ValueDeriver<String> {
        private DescriptionValueDeriver() {
        }

        public Set<ScopedStateStore.Key<?>> getTriggerKeys() {
            HashSet filterKeys = new HashSet(1);
            filterKeys.add(SampleImportWizardPath.SAMPLE_KEY);
            return filterKeys;
        }

        public String deriveValue(ScopedStateStore state, ScopedStateStore.Key changedKey, String currentValue) {
            Sample sample = (Sample)state.get(SampleImportWizardPath.SAMPLE_KEY);
            if (sample == null) {
                return "";
            }
            HtmlBuilder description = new HtmlBuilder();
            description.openHtmlBody();
            if (sample.getDescription() != null) {
                description.addHtml(sample.getDescription());
            } else {
                description.add(GctBundle.message("sample.browser.no.description", new Object[0]));
            }
            description.newlineIfNecessary().newline();
            description.add("Tags: ");
            description.add(StringUtil.join((Collection)sample.getCategories(), (String)","));
            description.newlineIfNecessary().newline();
            description.closeHtmlBody();
            return description.getHtml();
        }
    }

    private static class SampleUrlValueDeriver
    extends ScopedDataBinder.ValueDeriver<String> {
        private SampleUrlValueDeriver() {
        }

        public Set<ScopedStateStore.Key<?>> getTriggerKeys() {
            HashSet filterKeys = new HashSet(1);
            filterKeys.add(SampleImportWizardPath.SAMPLE_KEY);
            return filterKeys;
        }

        public String deriveValue(ScopedStateStore state, ScopedStateStore.Key changedKey, String currentValue) {
            Sample sample = (Sample)state.get(SampleImportWizardPath.SAMPLE_KEY);
            if (sample == null) {
                return "";
            }
            String url = sample.getCloneUrl();
            String path = sample.getPath();
            if (!Strings.isNullOrEmpty((String)path)) {
                return url + (url.endsWith("/") ? "" : "/") + "tree/master/" + SampleImportWizardPath.trimSlashes(path);
            }
            return url;
        }
    }

    private static class SampleSelectionListener
    implements TreeSelectionListener {
        private final ActionListener myExternalListener;

        public SampleSelectionListener(ActionListener externalListener) {
            this.myExternalListener = externalListener;
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            if (this.myExternalListener != null) {
                this.myExternalListener.actionPerformed(new ActionEvent(e.getSource(), -1, ""));
            }
        }
    }
}

