/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.idea.samples;

import com.android.tools.idea.wizard.dynamic.AndroidStudioWizardPath;
import com.android.tools.idea.wizard.dynamic.DynamicWizard;
import com.appspot.gsamplesindex.samplesindex.model.SampleCollection;
import com.google.gct.idea.samples.SampleImportWizardPath;
import com.google.gct.idea.util.GctBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import icons.AndroidIcons;
import javax.swing.Icon;
import org.jetbrains.android.sdk.AndroidSdkUtils;

public class SampleImportWizard
extends DynamicWizard {
    private SampleCollection mySampleList;

    public SampleImportWizard(Project project, SampleCollection samples) {
        super(project, null, GctBundle.message("sample.import.title", new Object[0]));
        this.mySampleList = samples;
        this.init();
    }

    public void init() {
        if (!AndroidSdkUtils.isAndroidSdkAvailable()) {
            String title = "SDK problem";
            String msg = "<html>Your Android SDK is missing or out of date.<br>You can configure your SDK via <b>Configure | Project Defaults | Project Structure | SDKs</b></html>";
            super.init();
            Messages.showErrorDialog((String)msg, (String)title);
            return;
        }
        this.addPath((AndroidStudioWizardPath)new SampleImportWizardPath(this.mySampleList, this.getDisposable()));
        super.init();
    }

    public Icon getIcon() {
        return AndroidIcons.Wizards.NewProjectMascotGreen;
    }

    public void performFinishingActions() {
    }

    protected String getProgressTitle() {
        return GctBundle.getString("sample.import.progress.title", new Object[0]);
    }

    public String getWizardActionDescription() {
        return GctBundle.message("sample.import.title", new Object[0]);
    }
}

