/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.idea.samples;

import com.android.tools.idea.gradle.project.GradleProjectImporter;
import com.android.tools.idea.wizard.dynamic.DynamicWizardPath;
import com.android.tools.idea.wizard.dynamic.DynamicWizardStep;
import com.android.tools.idea.wizard.dynamic.ScopedStateStore;
import com.appspot.gsamplesindex.samplesindex.model.Sample;
import com.appspot.gsamplesindex.samplesindex.model.SampleCollection;
import com.google.common.base.Strings;
import com.google.gct.idea.samples.GithubRepoContents;
import com.google.gct.idea.samples.SampleBrowserStep;
import com.google.gct.idea.samples.SampleSetupStep;
import com.google.gct.idea.util.GctBundle;
import com.google.gct.login.stats.UsageTrackerService;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import java.io.File;
import java.io.IOException;
import java.util.List;

public class SampleImportWizardPath
extends DynamicWizardPath {
    private static final Logger LOG = Logger.getInstance(SampleImportWizardPath.class);
    private final Disposable myParentDisposable;
    private final SampleCollection mySampleList;
    static final ScopedStateStore.Key<Sample> SAMPLE_KEY = ScopedStateStore.createKey((String)"SampleObject", (ScopedStateStore.Scope)ScopedStateStore.Scope.PATH, Sample.class);
    static final ScopedStateStore.Key<String> SAMPLE_NAME = ScopedStateStore.createKey((String)"SampleName", (ScopedStateStore.Scope)ScopedStateStore.Scope.PATH, String.class);
    static final ScopedStateStore.Key<String> SAMPLE_DIR = ScopedStateStore.createKey((String)"SampleDirectory", (ScopedStateStore.Scope)ScopedStateStore.Scope.PATH, String.class);
    static final ScopedStateStore.Key<String> SAMPLE_URL = ScopedStateStore.createKey((String)"SampleUrl", (ScopedStateStore.Scope)ScopedStateStore.Scope.PATH, String.class);

    public SampleImportWizardPath(SampleCollection sampleList, Disposable parentDisposable) {
        this.mySampleList = sampleList;
        this.myParentDisposable = parentDisposable;
    }

    protected void init() {
        this.addStep((DynamicWizardStep)new SampleBrowserStep(this.mySampleList, this.myParentDisposable));
        this.addStep((DynamicWizardStep)new SampleSetupStep(this.myParentDisposable));
    }

    public String getPathName() {
        return "Sample Import";
    }

    public boolean performFinishingActions() {
        final Ref result = Ref.create();
        ApplicationManager.getApplication().invokeAndWait(new Runnable(){

            @Override
            public void run() {
                result.set((Object)SampleImportWizardPath.this.performFinishingActionsInternal());
            }
        }, ModalityState.any());
        return (Boolean)result.get();
    }

    private boolean performFinishingActionsInternal() {
        Project project;
        String sampleName;
        block13: {
            String url;
            Sample sample = (Sample)this.myState.get(SAMPLE_KEY);
            sampleName = (String)this.myState.get(SAMPLE_NAME);
            File sampleDir = new File((String)this.myState.get(SAMPLE_DIR));
            assert (!sampleDir.exists());
            if (!FileUtilRt.createDirectory((File)sampleDir)) {
                Messages.showErrorDialog((String)GctBundle.message("create.project.dir.failed", new Object[0]), (String)GctBundle.message("sample.import.error.title", new Object[0]));
                return false;
            }
            project = ProjectManager.getInstance().createProject(sampleName, sampleDir.getAbsolutePath());
            GithubRepoContents downloadResult = GithubRepoContents.download(project, url = SampleImportWizardPath.trimSlashes(sample.getCloneUrl()), null, null);
            String errorMessage = downloadResult.getErrorMessage();
            if (errorMessage != null) {
                LOG.error(errorMessage);
                Messages.showErrorDialog((String)errorMessage, (String)GctBundle.message("sample.import.error.title", new Object[0]));
                return false;
            }
            List<File> sampleRoots = downloadResult.getSampleRoots();
            if (sampleRoots.size() == 0) {
                Messages.showErrorDialog((String)GctBundle.message("git.project.dir.empty", new Object[0]), (String)GctBundle.message("sample.import.error.title", new Object[0]));
                return false;
            }
            File rootFolder = downloadResult.getRootFolder();
            try {
                String path = sample.getPath();
                if (!Strings.isNullOrEmpty((String)path)) {
                    path = SampleImportWizardPath.trimSlashes(path);
                    for (File sampleRoot : sampleRoots) {
                        if (!sampleRoot.getCanonicalPath().equals(new File(rootFolder, path).getCanonicalPath())) continue;
                        FileUtil.copyDir((File)sampleRoot, (File)new File(project.getBasePath()));
                        break block13;
                    }
                    Messages.showErrorDialog((String)GctBundle.message("git.project.missing.sample.root", path), (String)GctBundle.message("sample.import.error.title", new Object[0]));
                    return false;
                }
                FileUtil.copyDir((File)sampleRoots.get(0), (File)new File(project.getBasePath()));
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
                Messages.showErrorDialog((String)GctBundle.message("sample.copy.to.project.failed", new Object[0]), (String)GctBundle.message("sample.import.error.title", new Object[0]));
                return false;
            }
        }
        if (SystemInfo.isUnix) {
            File gradlewFile = new File(project.getBasePath(), "gradlew");
            if (!gradlewFile.isFile()) {
                LOG.error("Could not find gradle wrapper for sample: " + sampleName + ". Command line builds may not work properly.");
            } else {
                try {
                    FileUtil.setExecutableAttribute((String)gradlewFile.getPath(), (boolean)true);
                }
                catch (IOException e) {
                    Messages.showWarningDialog((String)GctBundle.message("sample.import.no.gradlew.exec", sampleName), (String)GctBundle.message("sample.import.warning.title", new Object[0]));
                }
            }
        }
        UsageTrackerService.getInstance().trackEvent("com.google.cloud.tools", "sample.importer", sampleName, null);
        GradleProjectImporter.getInstance().importProject(project.getBaseDir());
        return true;
    }

    static String trimSlashes(String path) {
        while (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        while (path.startsWith("/")) {
            path = path.substring(1, path.length());
        }
        return path;
    }
}

