/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.connections;

import com.intellij.CvsBundle;
import com.intellij.cvsSupport2.connections.CvsMethod;
import com.intellij.cvsSupport2.connections.CvsRootException;
import com.intellij.openapi.util.text.StringUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;

public final class CvsRootParser {
    @NonNls
    private static final String PATTERN_STR = "^((.*?{0,1}(:.*?){0,1})@){0,1}([a-zA-Z0-9\\._-]+)(:(\\d*){0,1}){0,1}(.+)$";
    private static final Pattern ourPattern = Pattern.compile("^((.*?{0,1}(:.*?){0,1})@){0,1}([a-zA-Z0-9\\._-]+)(:(\\d*){0,1}){0,1}(.+)$");
    private static final String LOCAL = ":local:";
    private static final int GROUP_USER_NAME_AND_PWD = 2;
    private static final int GROUP_HOST = 4;
    private static final int GROUP_PORT = 5;
    private static final int GROUP_REPOSITORY = 7;
    public CvsMethod METHOD = null;
    public String USER_NAME = "";
    public String HOST = "";
    public String REPOSITORY = "";
    public String PROXY_HOST;
    public String PROXY_PORT;
    public String PORT = null;
    public String PASSWORD = null;
    @NonNls
    private static final String USERNAME_FIELD_NAME = "username";
    @NonNls
    private static final String PASSWORD_FIELD_NAME = "password";
    @NonNls
    private static final String HOSTNAME__FIELD_NAME = "hostname";
    @NonNls
    private static final String PROXY_FIELD_NAME = "proxy";
    @NonNls
    private static final String PROXYPORT_FIELD_NAME = "proxyport";
    @NonNls
    private static final String PORT_FIELD_NAME = "port";

    public static CvsRootParser valueOf(String rootString, boolean check) {
        CvsRootParser result = new CvsRootParser();
        if (rootString.isEmpty()) {
            if (check) {
                throw new CvsRootException(CvsBundle.message("message.error.empty.cvs.root", new Object[0]));
            }
            result.METHOD = CvsMethod.PSERVER_METHOD;
            return result;
        }
        if (!StringUtil.startsWithChar((CharSequence)rootString, (char)':')) {
            result.METHOD = CvsMethod.LOCAL_METHOD;
            result.REPOSITORY = rootString;
            return result;
        }
        if (rootString.startsWith(LOCAL)) {
            result.METHOD = CvsMethod.LOCAL_METHOD;
            result.REPOSITORY = rootString.substring(LOCAL.length());
            return result;
        }
        String suffix = result.extractMethod(rootString, check);
        if (CvsMethod.LOCAL_METHOD.equals(result.METHOD)) {
            result.REPOSITORY = suffix;
            CvsRootParser.skipTrailingRepositorySlash(result);
        } else if (result.HOST != null && !result.HOST.isEmpty() && result.USER_NAME != null && !result.USER_NAME.isEmpty()) {
            result.REPOSITORY = suffix.trim();
        } else if (suffix.contains("@") || suffix.contains(":")) {
            Matcher matcher = ourPattern.matcher(suffix);
            if (matcher.matches()) {
                CvsRootParser.extractUserNameAndPassword(matcher, result);
                CvsRootParser.extractHostAndPort(matcher, result);
                CvsRootParser.extractRepository(matcher, result);
            } else {
                if (check) {
                    throw new CvsRootException(CvsBundle.message("error.message.wrong.remote.repository", rootString));
                }
                result.REPOSITORY = suffix;
            }
        } else {
            result.REPOSITORY = suffix;
        }
        return result;
    }

    private static void extractRepository(Matcher matcher, CvsRootParser cvsRoot) {
        cvsRoot.REPOSITORY = matcher.group(7);
        CvsRootParser.skipTrailingRepositorySlash(cvsRoot);
    }

    private static void skipTrailingRepositorySlash(CvsRootParser cvsRoot) {
        if (StringUtil.endsWithChar((CharSequence)cvsRoot.REPOSITORY, (char)'/')) {
            cvsRoot.REPOSITORY = cvsRoot.REPOSITORY.substring(0, cvsRoot.REPOSITORY.length() - 1);
        }
    }

    private static void extractHostAndPort(Matcher matcher, CvsRootParser cvsRoot) {
        String host = matcher.group(4);
        String port = matcher.group(5);
        if (port != null) {
            cvsRoot.HOST = host + port;
        } else {
            if (StringUtil.endsWithChar((CharSequence)host, (char)':')) {
                host = host.substring(0, host.length() - 1);
            }
            cvsRoot.HOST = host;
        }
    }

    private static void extractUserNameAndPassword(Matcher matcher, CvsRootParser cvsRoot) {
        String userNameAndPwd = matcher.group(2);
        if (userNameAndPwd != null && cvsRoot.USER_NAME.isEmpty()) {
            cvsRoot.USER_NAME = userNameAndPwd;
        }
    }

    private String tryToCutMethod(CvsMethod method, String cvsRoot) {
        String[] paramValueStrings;
        String methodEntry = CvsRootParser.methodEntry(method.getName());
        if (cvsRoot.startsWith(methodEntry)) {
            return cvsRoot.substring(methodEntry.length());
        }
        if (!method.supportsProxyConnection()) {
            return null;
        }
        String proxyBegin = ":" + method.getName() + ";";
        if (!cvsRoot.startsWith(proxyBegin)) {
            return null;
        }
        String tail = cvsRoot.substring(proxyBegin.length() - 1);
        int endOfProxySettings = tail.indexOf(58);
        if (endOfProxySettings == -1) {
            return null;
        }
        String proxySettings = tail.substring(0, endOfProxySettings);
        for (String paramValueString : paramValueStrings = proxySettings.split(";")) {
            int eqIndex = paramValueString.indexOf("=");
            if (eqIndex < 0) continue;
            this.setValue(paramValueString.substring(0, eqIndex), paramValueString.substring(eqIndex + 1));
        }
        return tail.substring(endOfProxySettings + 1);
    }

    private void setValue(String paramName, String paramValue) {
        if (paramName.isEmpty() || paramValue.isEmpty()) {
            return;
        }
        if (USERNAME_FIELD_NAME.equals(paramName)) {
            this.USER_NAME = paramValue;
        } else if (PASSWORD_FIELD_NAME.equals(paramName)) {
            this.PASSWORD = paramValue;
        } else if (HOSTNAME__FIELD_NAME.equals(paramName)) {
            this.HOST = paramValue;
        } else if (PROXY_FIELD_NAME.equals(paramName)) {
            this.PROXY_HOST = paramValue;
        } else if (PROXYPORT_FIELD_NAME.equals(paramName)) {
            this.PROXY_PORT = paramValue;
        } else if (PORT_FIELD_NAME.equals(paramName)) {
            this.PORT = paramValue;
        }
    }

    private static String methodEntry(String method) {
        return ":" + method + ":";
    }

    private String extractMethod(String rootString, boolean check) {
        for (CvsMethod cvsMethod : CvsMethod.AVAILABLE_METHODS) {
            String tail = this.tryToCutMethod(cvsMethod, rootString);
            if (tail == null) continue;
            this.METHOD = cvsMethod;
            return tail;
        }
        if (check) {
            throw new CvsRootException(CvsBundle.message("message.error.invalid.cvs.root", rootString));
        }
        this.METHOD = CvsMethod.AVAILABLE_METHODS[0];
        if (!StringUtil.startsWithChar((CharSequence)rootString, (char)':')) {
            return rootString;
        }
        int nextSep = rootString.indexOf(":", 1);
        if (nextSep < 0) {
            return rootString;
        }
        return rootString.substring(nextSep + 1);
    }

    private CvsRootParser() {
    }
}

