/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.connections.ssh;

import com.intellij.cvsSupport2.connections.ssh.ConnectionLifeCycle;
import com.intellij.cvsSupport2.connections.ssh.SocksAuthenticatorManager;
import com.intellij.cvsSupport2.connections.ssh.SshAuthentication;
import com.intellij.cvsSupport2.connections.ssh.SshConnectionUtils;
import com.intellij.cvsSupport2.connections.ssh.SshLogger;
import com.intellij.cvsSupport2.connections.ssh.SshSessionConnection;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.util.Consumer;
import com.trilead.ssh2.Connection;
import com.trilead.ssh2.Session;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.connection.ConnectionSettings;
import org.netbeans.lib.cvsclient.connection.IConnection;

public class SshSharedConnection {
    private static final int CHECK_GRANULARITY = 10000;
    private static final int EMPTY_CONNECTION_ALLOWED_FOR = 600000;
    private final String myRepository;
    private final ConnectionSettings myConnectionSettings;
    private final Object myLock;
    private final AtomicBoolean myValid = new AtomicBoolean(true);
    private final ThrowableComputable<Connection, AuthenticationException> myConnectionFactory;
    private final List<Cell> myQueue;

    public SshSharedConnection(String repository, final ConnectionSettings connectionSettings, final SshAuthentication authentication) {
        this.myRepository = repository;
        this.myConnectionSettings = connectionSettings;
        this.myLock = new Object();
        this.myConnectionFactory = new ThrowableComputable<Connection, AuthenticationException>(){

            public Connection compute() throws AuthenticationException {
                try {
                    SshLogger.debug("connection factory called");
                    return SshConnectionUtils.openConnection(connectionSettings, authentication);
                }
                catch (AuthenticationException e) {
                    SshSharedConnection.this.myValid.set(false);
                    throw e;
                }
                catch (IOException e) {
                    SshSharedConnection.this.myValid.set(false);
                    throw new AuthenticationException(e.getMessage(), (Throwable)e);
                }
            }
        };
        this.myQueue = new LinkedList<Cell>();
    }

    public boolean isValid() {
        return this.myValid.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IConnection getTicket() {
        long oldMoment = System.currentTimeMillis() - 600000L;
        IConnection result = null;
        Object object = this.myLock;
        synchronized (object) {
            SshLogger.debug("shared connection: queue size " + this.myQueue.size());
            Iterator<Cell> iterator = this.myQueue.iterator();
            while (iterator.hasNext()) {
                Cell cell = iterator.next();
                if (result == null) {
                    result = cell.allocate();
                    continue;
                }
                if (!cell.isEmptyAndOlderThen(oldMoment)) continue;
                SshLogger.debug("empty and older");
                cell.closeSelf();
                iterator.remove();
            }
            if (result != null) {
                return result;
            }
            SshLogger.debug("new cell");
            Cell newCell = new Cell(this.myConnectionFactory, this.myRepository);
            this.myQueue.add(newCell);
            return newCell.allocate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void controlSelf() {
        long oldMoment = System.currentTimeMillis() - 600000L;
        Object object = this.myLock;
        synchronized (object) {
            SshLogger.debug("shared connection: control self: queue size " + this.myQueue.size() + " repo " + this.myRepository);
            Iterator<Cell> iterator = this.myQueue.iterator();
            while (iterator.hasNext()) {
                Cell cell = iterator.next();
                if (cell.isClosed()) {
                    SshLogger.debug("shared connection: control self: closed, removing");
                    iterator.remove();
                    continue;
                }
                if (!cell.isEmptyAndOlderThen(oldMoment)) continue;
                SshLogger.debug("shared connection: control self: is empty and old, closing");
                cell.closeSelf();
                iterator.remove();
            }
            if (this.myQueue.isEmpty()) {
                SshLogger.debug("shared connection: control self: unregister from socks proxy authenticator");
                SocksAuthenticatorManager.getInstance().unregister(this.myConnectionSettings);
            }
        }
    }

    private class Cell {
        private static final int SESSIONS_PER_CONNECTION = 8;
        private final ConnectionLifeCycle myConnectionLifeCycle;
        private final LinkedList<IConnection> mySessions;
        private final Consumer<SshSessionConnection> myCloseListener;
        private final String myRepository;
        private long myTs;
        private final ThrowableComputable<Session, AuthenticationException> mySessionProvider;

        private Cell(ThrowableComputable<Connection, AuthenticationException> factory, String repository) {
            this.myConnectionLifeCycle = new ConnectionLifeCycle(10000, factory);
            this.myRepository = repository;
            this.mySessions = new LinkedList();
            this.myCloseListener = new Consumer<SshSessionConnection>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void consume(SshSessionConnection sshSessionConnection) {
                    Object object = SshSharedConnection.this.myLock;
                    synchronized (object) {
                        boolean removed = Cell.this.mySessions.remove(sshSessionConnection);
                        SshLogger.debug("shared connection: session closed notification, removed: " + removed);
                        Cell.this.myTs = System.currentTimeMillis();
                    }
                }
            };
            this.mySessionProvider = new ThrowableComputable<Session, AuthenticationException>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Session compute() throws AuthenticationException {
                    Connection connection;
                    Object object = SshSharedConnection.this.myLock;
                    synchronized (object) {
                        connection = Cell.this.myConnectionLifeCycle.getConnection();
                    }
                    SshLogger.debug("shared connection: opening session");
                    try {
                        Session session = connection.openSession();
                        session.execCommand("cvs server");
                        return session;
                    }
                    catch (IOException e) {
                        throw new AuthenticationException(e.getMessage(), (Throwable)e);
                    }
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IConnection allocate() {
            Object object = SshSharedConnection.this.myLock;
            synchronized (object) {
                if (this.myConnectionLifeCycle.isClosed()) {
                    return null;
                }
                if (!this.myConnectionLifeCycle.hasDied()) {
                    SshLogger.debug("connection ok, active sessions: " + this.mySessions.size());
                    if (this.mySessions.size() >= 8) {
                        return null;
                    }
                    this.myTs = System.currentTimeMillis();
                    SshSessionConnection wrapper = new SshSessionConnection(this.myRepository, this.myCloseListener, this.mySessionProvider);
                    this.mySessions.addLast(wrapper);
                    return wrapper;
                }
                this.myConnectionLifeCycle.setClosing();
            }
            this.closeSelf();
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void closeSelf() {
            ArrayList<IConnection> copy;
            Object object = SshSharedConnection.this.myLock;
            synchronized (object) {
                copy = new ArrayList<IConnection>(this.mySessions);
            }
            for (IConnection session : copy) {
                try {
                    session.close();
                }
                catch (IOException e) {}
            }
            object = SshSharedConnection.this.myLock;
            synchronized (object) {
                this.mySessions.clear();
                this.myConnectionLifeCycle.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isClosed() {
            Object object = SshSharedConnection.this.myLock;
            synchronized (object) {
                return this.myConnectionLifeCycle.isClosed();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isEmptyAndOlderThen(long moment) {
            Object object = SshSharedConnection.this.myLock;
            synchronized (object) {
                return this.mySessions.isEmpty() && this.myTs < moment;
            }
        }
    }
}

