/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage;

import com.intellij.codeInspection.export.ExportToHTMLDialog;
import com.intellij.coverage.CoverageAnnotator;
import com.intellij.coverage.CoverageFileProvider;
import com.intellij.coverage.CoverageLineMarkerRenderer;
import com.intellij.coverage.CoverageRunner;
import com.intellij.coverage.CoverageSuite;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.coverage.view.CoverageViewExtension;
import com.intellij.coverage.view.CoverageViewManager;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.coverage.CoverageEnabledConfiguration;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.util.Function;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;

public abstract class CoverageEngine {
    public static final ExtensionPointName<CoverageEngine> EP_NAME = ExtensionPointName.create((String)"com.intellij.coverageEngine");

    public abstract boolean isApplicableTo(RunConfigurationBase var1);

    public abstract boolean canHavePerTestCoverage(RunConfigurationBase var1);

    public abstract CoverageEnabledConfiguration createCoverageEnabledConfiguration(RunConfigurationBase var1);

    public CoverageSuite createCoverageSuite(CoverageRunner covRunner, String name, CoverageFileProvider coverageDataFileProvider, String[] filters, long lastCoverageTimeStamp, String suiteToMerge, boolean coverageByTestEnabled, boolean tracingEnabled, boolean trackTestFolders) {
        return this.createCoverageSuite(covRunner, name, coverageDataFileProvider, filters, lastCoverageTimeStamp, suiteToMerge, coverageByTestEnabled, tracingEnabled, trackTestFolders, null);
    }

    public abstract CoverageSuite createCoverageSuite(CoverageRunner var1, String var2, CoverageFileProvider var3, String[] var4, long var5, String var7, boolean var8, boolean var9, boolean var10, Project var11);

    public abstract CoverageSuite createCoverageSuite(CoverageRunner var1, String var2, CoverageFileProvider var3, CoverageEnabledConfiguration var4);

    public abstract CoverageSuite createEmptyCoverageSuite(CoverageRunner var1);

    public abstract CoverageAnnotator getCoverageAnnotator(Project var1);

    public abstract boolean coverageEditorHighlightingApplicableTo(PsiFile var1);

    public abstract boolean acceptedByFilters(PsiFile var1, CoverageSuitesBundle var2);

    public Set<File> getCorrespondingOutputFiles(PsiFile srcFile, Module module, CoverageSuitesBundle suite) {
        VirtualFile virtualFile = srcFile.getVirtualFile();
        return virtualFile == null ? Collections.emptySet() : Collections.singleton(VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile));
    }

    public abstract boolean recompileProjectAndRerunAction(Module var1, CoverageSuitesBundle var2, Runnable var3);

    public String getQualifiedName(File outputFile, PsiFile sourceFile) {
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByIoFile(outputFile);
        if (virtualFile != null) {
            return this.getQualifiedName(virtualFile, sourceFile);
        }
        return null;
    }

    @Deprecated
    public String getQualifiedName(VirtualFile outputFile, PsiFile sourceFile) {
        return null;
    }

    public abstract Set<String> getQualifiedNames(PsiFile var1);

    public boolean includeUntouchedFileInCoverage(String qualifiedName, File outputFile, PsiFile sourceFile, CoverageSuitesBundle suite) {
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByIoFile(outputFile);
        if (virtualFile != null) {
            return this.includeUntouchedFileInCoverage(qualifiedName, virtualFile, sourceFile, suite);
        }
        return false;
    }

    @Deprecated
    public boolean includeUntouchedFileInCoverage(String qualifiedName, VirtualFile outputFile, PsiFile sourceFile, CoverageSuitesBundle suite) {
        return false;
    }

    public List<Integer> collectSrcLinesForUntouchedFile(File classFile, CoverageSuitesBundle suite) {
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByIoFile(classFile);
        if (virtualFile != null) {
            return this.collectSrcLinesForUntouchedFile(virtualFile, suite);
        }
        return null;
    }

    @Deprecated
    public List<Integer> collectSrcLinesForUntouchedFile(VirtualFile classFile, CoverageSuitesBundle suite) {
        return null;
    }

    public String generateBriefReport(Editor editor, PsiFile psiFile, int lineNumber, int startOffset, int endOffset, LineData lineData) {
        int hits = lineData == null ? 0 : lineData.getHits();
        return "Hits: " + hits;
    }

    public abstract List<PsiElement> findTestsByNames(String[] var1, Project var2);

    public abstract String getTestMethodName(PsiElement var1, AbstractTestProxy var2);

    public boolean isReportGenerationAvailable(Project project, DataContext dataContext, CoverageSuitesBundle currentSuite) {
        return false;
    }

    public void generateReport(Project project, DataContext dataContext, CoverageSuitesBundle currentSuite) {
    }

    public ExportToHTMLDialog createGenerateReportDialog(Project project, DataContext dataContext, CoverageSuitesBundle currentSuite) {
        ExportToHTMLDialog dialog = new ExportToHTMLDialog(project, true);
        dialog.setTitle("Generate Coverage Report for: '" + currentSuite.getPresentableName() + "'");
        return dialog;
    }

    public abstract String getPresentableText();

    public boolean coverageProjectViewStatisticsApplicableTo(VirtualFile fileOrDir) {
        return false;
    }

    public Object[] postProcessExecutableLines(Object[] lines, Editor editor) {
        return lines;
    }

    public CoverageLineMarkerRenderer getLineMarkerRenderer(int lineNumber, String className, TreeMap<Integer, LineData> lines, boolean coverageByTestApplicable, CoverageSuitesBundle coverageSuite, Function<Integer, Integer> newToOldConverter, Function<Integer, Integer> oldToNewConverter, boolean subCoverageActive) {
        return CoverageLineMarkerRenderer.getRenderer(lineNumber, className, lines, coverageByTestApplicable, coverageSuite, newToOldConverter, oldToNewConverter, subCoverageActive);
    }

    public boolean shouldHighlightFullLines() {
        return false;
    }

    public static String getEditorTitle() {
        return "Code Coverage";
    }

    public CoverageViewExtension createCoverageViewExtension(Project project, CoverageSuitesBundle suiteBundle, CoverageViewManager.StateBean stateBean) {
        return null;
    }

    public boolean isInLibraryClasses(Project project, VirtualFile file) {
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        return projectFileIndex.isInLibraryClasses(file);
    }
}

