/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage;

import com.intellij.execution.Executor;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindowId;
import javax.swing.Icon;

public class CoverageExecutor
extends Executor {
    public static final String EXECUTOR_ID = "Coverage";

    public String getStartActionText() {
        return "Run with Co_verage";
    }

    public String getStartActionText(String configurationName) {
        String name = configurationName != null ? CoverageExecutor.escapeMnemonicsInConfigurationName(StringUtil.first((String)configurationName, (int)30, (boolean)true)) : null;
        return "Run" + (StringUtil.isEmpty((String)name) ? "" : " '" + name + "'") + " with Co_verage";
    }

    private static String escapeMnemonicsInConfigurationName(String configurationName) {
        return configurationName.replace("_", "__");
    }

    public String getToolWindowId() {
        return ToolWindowId.RUN;
    }

    public Icon getToolWindowIcon() {
        return AllIcons.General.RunWithCoverage;
    }

    public Icon getIcon() {
        return AllIcons.General.RunWithCoverage;
    }

    public Icon getDisabledIcon() {
        return null;
    }

    public String getDescription() {
        return "Run selected configuration with coverage enabled";
    }

    public String getActionName() {
        return "Cover";
    }

    public String getId() {
        return EXECUTOR_ID;
    }

    public String getContextActionId() {
        return "RunCoverage";
    }

    public String getHelpId() {
        return null;
    }
}

