/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage;

import com.intellij.coverage.AbstractCoverageProjectViewNodeDecorator;
import com.intellij.coverage.CoverageAnnotator;
import com.intellij.coverage.CoverageDataManager;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.coverage.JavaCoverageAnnotator;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.impl.nodes.PackageElement;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packageDependencies.ui.PackageDependenciesNode;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.ColoredTreeCellRenderer;

public class CoverageProjectViewClassNodeDecorator
extends AbstractCoverageProjectViewNodeDecorator {
    public CoverageProjectViewClassNodeDecorator(CoverageDataManager coverageDataManager) {
        super(coverageDataManager);
    }

    public void decorate(PackageDependenciesNode node, ColoredTreeCellRenderer cellRenderer) {
        String qName;
        Project project;
        PsiElement element = node.getPsiElement();
        if (element == null || !element.isValid()) {
            return;
        }
        CoverageDataManager dataManager = this.getCoverageDataManager();
        CoverageSuitesBundle currentSuite = dataManager.getCurrentSuitesBundle();
        JavaCoverageAnnotator javaCovAnnotator = CoverageProjectViewClassNodeDecorator.getCovAnnotator(currentSuite, project = element.getProject());
        if (javaCovAnnotator == null) {
            return;
        }
        if (element instanceof PsiClass && (qName = ((PsiClass)element).getQualifiedName()) != null) {
            CoverageProjectViewClassNodeDecorator.appendCoverageInfo(cellRenderer, javaCovAnnotator.getClassCoverageInformationString(qName, dataManager));
        }
    }

    public void decorate(ProjectViewNode node, PresentationData data) {
        Project project;
        CoverageDataManager coverageDataManager = this.getCoverageDataManager();
        CoverageSuitesBundle currentSuite = coverageDataManager.getCurrentSuitesBundle();
        JavaCoverageAnnotator javaCovAnnotator = CoverageProjectViewClassNodeDecorator.getCovAnnotator(currentSuite, project = node.getProject());
        if (javaCovAnnotator == null) {
            return;
        }
        Object value = node.getValue();
        PsiElement element = null;
        if (value instanceof PsiElement) {
            element = (PsiElement)value;
        } else if (value instanceof SmartPsiElementPointer) {
            element = ((SmartPsiElementPointer)value).getElement();
        } else if (value instanceof PackageElement) {
            PackageElement packageElement = (PackageElement)value;
            String coverageString = javaCovAnnotator.getPackageCoverageInformationString(packageElement.getPackage(), packageElement.getModule(), coverageDataManager);
            data.setLocationString(coverageString);
        }
        if (element instanceof PsiClass) {
            String qName;
            GlobalSearchScope searchScope = currentSuite.getSearchScope(project);
            VirtualFile vFile = PsiUtilCore.getVirtualFile((PsiElement)element);
            if (vFile != null && searchScope.contains(vFile) && (qName = ((PsiClass)element).getQualifiedName()) != null) {
                data.setLocationString(javaCovAnnotator.getClassCoverageInformationString(qName, coverageDataManager));
            }
        }
    }

    private static JavaCoverageAnnotator getCovAnnotator(CoverageSuitesBundle currentSuite, Project project) {
        CoverageAnnotator coverageAnnotator;
        if (currentSuite != null && (coverageAnnotator = currentSuite.getAnnotator(project)) instanceof JavaCoverageAnnotator) {
            return (JavaCoverageAnnotator)coverageAnnotator;
        }
        return null;
    }
}

