/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage.view;

import com.intellij.coverage.CoverageDataManager;
import com.intellij.coverage.CoverageSuite;
import com.intellij.coverage.CoverageSuiteListener;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.coverage.DefaultCoverageFileProvider;
import com.intellij.coverage.view.CoverageViewManager;
import com.intellij.openapi.project.Project;

public class CoverageViewSuiteListener
implements CoverageSuiteListener {
    private final CoverageDataManager myDataManager;
    private final Project myProject;

    public CoverageViewSuiteListener(CoverageDataManager dataManager, Project project) {
        this.myDataManager = dataManager;
        this.myProject = project;
    }

    @Override
    public void beforeSuiteChosen() {
        CoverageSuitesBundle suitesBundle = this.myDataManager.getCurrentSuitesBundle();
        if (suitesBundle != null) {
            CoverageViewManager.getInstance(this.myProject).closeView(CoverageViewManager.getDisplayName(suitesBundle));
        }
    }

    @Override
    public void afterSuiteChosen() {
        CoverageSuitesBundle suitesBundle = this.myDataManager.getCurrentSuitesBundle();
        if (suitesBundle == null) {
            return;
        }
        CoverageViewManager viewManager = CoverageViewManager.getInstance(this.myProject);
        if (suitesBundle.getCoverageEngine().createCoverageViewExtension(this.myProject, suitesBundle, viewManager.getState()) != null) {
            viewManager.createToolWindow(CoverageViewManager.getDisplayName(suitesBundle), CoverageViewSuiteListener.shouldActivate(suitesBundle));
        }
    }

    private static boolean shouldActivate(CoverageSuitesBundle suitesBundle) {
        CoverageSuite[] suites;
        for (CoverageSuite suite : suites = suitesBundle.getSuites()) {
            if (suite.getCoverageDataFileProvider() instanceof DefaultCoverageFileProvider) continue;
            return false;
        }
        return true;
    }
}

