/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations.coverage;

import com.intellij.coverage.CoverageEngine;
import com.intellij.coverage.CoverageRunner;
import com.intellij.coverage.CoverageSuite;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;

public abstract class CoverageEnabledConfiguration
implements JDOMExternalizable {
    private static final Logger LOG = Logger.getInstance((String)CoverageEnabledConfiguration.class.getName());
    public static final Key<CoverageEnabledConfiguration> COVERAGE_KEY = Key.create((String)"com.intellij.coverage");
    @NonNls
    protected static final String COVERAGE_ENABLED_ATTRIBUTE_NAME = "enabled";
    @NonNls
    protected static final String COVERAGE_RUNNER = "runner";
    @NonNls
    protected static final String TRACK_PER_TEST_COVERAGE_ATTRIBUTE_NAME = "per_test_coverage_enabled";
    @NonNls
    protected static final String SAMPLING_COVERAGE_ATTRIBUTE_NAME = "sample_coverage";
    @NonNls
    protected static final String TRACK_TEST_FOLDERS = "track_test_folders";
    private final Project myProject;
    private final RunConfigurationBase myConfiguration;
    private boolean myIsCoverageEnabled = false;
    private String myRunnerId;
    private CoverageRunner myCoverageRunner;
    private boolean myTrackPerTestCoverage = true;
    private boolean mySampling = true;
    private boolean myTrackTestFolders = false;
    @NonNls
    protected String myCoverageFilePath;
    private CoverageSuite myCurrentCoverageSuite;

    public CoverageEnabledConfiguration(RunConfigurationBase configuration) {
        this.myConfiguration = configuration;
        this.myProject = configuration.getProject();
    }

    public RunConfigurationBase getConfiguration() {
        return this.myConfiguration;
    }

    public boolean isCoverageEnabled() {
        return this.myIsCoverageEnabled;
    }

    public void setCoverageEnabled(boolean isCoverageEnabled) {
        this.myIsCoverageEnabled = isCoverageEnabled;
    }

    public boolean isSampling() {
        return this.mySampling;
    }

    public void setSampling(boolean sampling) {
        this.mySampling = sampling;
    }

    public String getRunnerId() {
        return this.myRunnerId;
    }

    public CoverageRunner getCoverageRunner() {
        return this.myCoverageRunner;
    }

    public void setCoverageRunner(CoverageRunner coverageRunner) {
        this.myCoverageRunner = coverageRunner;
        this.myRunnerId = coverageRunner != null ? coverageRunner.getId() : null;
        this.myCoverageFilePath = null;
    }

    public boolean isTrackPerTestCoverage() {
        return this.myTrackPerTestCoverage;
    }

    public void setTrackPerTestCoverage(boolean collectLineInfo) {
        this.myTrackPerTestCoverage = collectLineInfo;
    }

    public boolean isTrackTestFolders() {
        return this.myTrackTestFolders;
    }

    public void setTrackTestFolders(boolean trackTestFolders) {
        this.myTrackTestFolders = trackTestFolders;
    }

    public CoverageSuite getCurrentCoverageSuite() {
        return this.myCurrentCoverageSuite;
    }

    public void setCurrentCoverageSuite(CoverageSuite currentCoverageSuite) {
        this.myCurrentCoverageSuite = currentCoverageSuite;
    }

    public String getName() {
        return this.myConfiguration.getName();
    }

    public boolean canHavePerTestCoverage() {
        for (CoverageEngine engine : (CoverageEngine[])CoverageEngine.EP_NAME.getExtensions()) {
            if (!engine.isApplicableTo(this.myConfiguration)) continue;
            return engine.canHavePerTestCoverage(this.myConfiguration);
        }
        return false;
    }

    public static boolean isApplicableTo(RunConfigurationBase runConfiguration) {
        CoverageEnabledConfiguration configuration = (CoverageEnabledConfiguration)runConfiguration.getCopyableUserData(COVERAGE_KEY);
        if (configuration != null) {
            return true;
        }
        for (CoverageEngine engine : (CoverageEngine[])CoverageEngine.EP_NAME.getExtensions()) {
            if (!engine.isApplicableTo(runConfiguration)) continue;
            return true;
        }
        return false;
    }

    public static CoverageEnabledConfiguration getOrCreate(RunConfigurationBase runConfiguration) {
        CoverageEnabledConfiguration configuration = (CoverageEnabledConfiguration)runConfiguration.getCopyableUserData(COVERAGE_KEY);
        if (configuration == null) {
            for (CoverageEngine engine : (CoverageEngine[])CoverageEngine.EP_NAME.getExtensions()) {
                if (!engine.isApplicableTo(runConfiguration)) continue;
                configuration = engine.createCoverageEnabledConfiguration(runConfiguration);
                break;
            }
            LOG.assertTrue(configuration != null, (Object)("Coverage enabled run configuration wasn't found for run configuration: " + runConfiguration.getName() + ", type = " + runConfiguration.getClass().getName()));
            runConfiguration.putCopyableUserData(COVERAGE_KEY, (Object)configuration);
        }
        return configuration;
    }

    @NonNls
    public String getCoverageFilePath() {
        if (this.myCoverageFilePath == null) {
            this.myCoverageFilePath = this.createCoverageFile();
        }
        return this.myCoverageFilePath;
    }

    public void readExternal(Element element) throws InvalidDataException {
        String coverageEnabledValueStr = element.getAttributeValue(COVERAGE_ENABLED_ATTRIBUTE_NAME);
        this.myIsCoverageEnabled = Boolean.valueOf(coverageEnabledValueStr);
        String collectLineInfoAttribute = element.getAttributeValue(TRACK_PER_TEST_COVERAGE_ATTRIBUTE_NAME);
        this.myTrackPerTestCoverage = collectLineInfoAttribute == null || Boolean.valueOf(collectLineInfoAttribute) != false;
        String sampling = element.getAttributeValue(SAMPLING_COVERAGE_ATTRIBUTE_NAME);
        this.mySampling = sampling != null && Boolean.valueOf(sampling) != false;
        String trackTestFolders = element.getAttributeValue(TRACK_TEST_FOLDERS);
        this.myTrackTestFolders = trackTestFolders != null && Boolean.valueOf(trackTestFolders) != false;
        String runnerId = element.getAttributeValue(COVERAGE_RUNNER);
        if (runnerId != null) {
            this.myRunnerId = runnerId;
            this.myCoverageRunner = null;
            for (CoverageRunner coverageRunner : (CoverageRunner[])Extensions.getExtensions(CoverageRunner.EP_NAME)) {
                if (!Comparing.strEqual((String)coverageRunner.getId(), (String)this.myRunnerId)) continue;
                this.myCoverageRunner = coverageRunner;
                break;
            }
        }
    }

    public void writeExternal(Element element) throws WriteExternalException {
        element.setAttribute(COVERAGE_ENABLED_ATTRIBUTE_NAME, String.valueOf(this.myIsCoverageEnabled));
        if (!this.myTrackPerTestCoverage) {
            element.setAttribute(TRACK_PER_TEST_COVERAGE_ATTRIBUTE_NAME, String.valueOf(this.myTrackPerTestCoverage));
        }
        if (this.mySampling) {
            element.setAttribute(SAMPLING_COVERAGE_ATTRIBUTE_NAME, String.valueOf(this.mySampling));
        }
        if (this.myTrackTestFolders) {
            element.setAttribute(TRACK_TEST_FOLDERS, String.valueOf(this.myTrackTestFolders));
        }
        if (this.myCoverageRunner != null) {
            element.setAttribute(COVERAGE_RUNNER, this.myCoverageRunner.getId());
        } else if (this.myRunnerId != null) {
            element.setAttribute(COVERAGE_RUNNER, this.myRunnerId);
        }
    }

    @NonNls
    protected String createCoverageFile() {
        if (this.myCoverageRunner == null) {
            return null;
        }
        String coverageRootPath = PathManager.getSystemPath() + File.separator + "coverage";
        String path = coverageRootPath + File.separator + this.myProject.getName() + this.coverageFileNameSeparator() + FileUtil.sanitizeFileName((String)this.myConfiguration.getName()) + ".coverage";
        new File(coverageRootPath).mkdirs();
        return path;
    }

    protected String coverageFileNameSeparator() {
        return "$";
    }
}

