/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.junit3;

import com.intellij.junit3.JUnit3IdeaTestRunner;
import com.intellij.junit3.TestAllInPackage2;
import java.io.BufferedReader;
import java.io.FileReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.Vector;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestResult;
import junit.framework.TestSuite;

public class TestRunnerUtil {
    private static final ResourceBundle ourBundle = ResourceBundle.getBundle("RuntimeBundle");
    static /* synthetic */ Class class$com$intellij$junit3$TestRunnerUtil;
    static /* synthetic */ Class class$java$lang$String;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Test getTestSuite(JUnit3IdeaTestRunner runner, String[] suiteClassNames) {
        Object test;
        if (suiteClassNames.length == 0) {
            return null;
        }
        Vector<Test> result = new Vector<Test>();
        for (int i = 0; i < suiteClassNames.length; ++i) {
            String suiteClassName = suiteClassNames[i];
            if (suiteClassName.charAt(0) == '@') {
                String[] classNames;
                String suiteName;
                try {
                    Vector<String> vector;
                    BufferedReader reader = new BufferedReader(new FileReader(suiteClassName.substring(1)));
                    try {
                        String line;
                        suiteName = reader.readLine();
                        reader.readLine();
                        vector = new Vector<String>();
                        while ((line = reader.readLine()) != null) {
                            vector.addElement(line);
                        }
                    }
                    finally {
                        reader.close();
                    }
                    classNames = new String[vector.size()];
                    for (int j = 0; j < classNames.length; ++j) {
                        classNames[j] = (String)vector.elementAt(j);
                    }
                }
                catch (Exception e) {
                    runner.runFailed(MessageFormat.format(ourBundle.getString("junit.runner.error"), e.toString()));
                    return null;
                }
                test = new TestAllInPackage2(runner, suiteName, classNames);
            } else {
                test = TestRunnerUtil.createClassOrMethodSuite(runner, suiteClassName);
                if (test == null) {
                    return null;
                }
            }
            result.addElement((Test)test);
        }
        if (result.size() == 1) {
            return (Test)result.elementAt(0);
        }
        TestSuite suite = new TestSuite();
        for (int i = 0; i < result.size(); ++i) {
            test = (Test)result.elementAt(i);
            suite.addTest(test);
        }
        return suite;
    }

    public static Test createClassOrMethodSuite(JUnit3IdeaTestRunner runner, String suiteClassName) {
        Class testClass;
        String methodName = null;
        int index = suiteClassName.indexOf(44);
        if (index != -1) {
            methodName = suiteClassName.substring(index + 1);
            suiteClassName = suiteClassName.substring(0, index);
        }
        if ((testClass = TestRunnerUtil.loadTestClass(runner, suiteClassName)) == null) {
            return null;
        }
        Test test = null;
        if (methodName == null) {
            if (test == null) {
                try {
                    Method suiteMethod = testClass.getMethod("suite", new Class[0]);
                    if (!Modifier.isStatic(suiteMethod.getModifiers())) {
                        String message = MessageFormat.format(ourBundle.getString("junit.suite.must.be.static"), testClass.getName());
                        System.err.println(message);
                        return null;
                    }
                    try {
                        test = (Test)suiteMethod.invoke(null, (Object[])new Class[0]);
                        if (test == null) {
                            return new FailedTestCase(testClass, "suite", MessageFormat.format(ourBundle.getString("junit.failed.to.invoke.suite"), "method " + suiteClassName + ".suite() evaluates to null"), null);
                        }
                        test = new SuiteMethodWrapper(test, suiteClassName);
                    }
                    catch (InvocationTargetException e) {
                        String message = MessageFormat.format(ourBundle.getString("junit.failed.to.invoke.suite"), testClass + " " + e.getTargetException().toString());
                        runner.clearStatus();
                        return new FailedTestCase(testClass, "suite", message, e);
                    }
                    catch (IllegalAccessException e) {
                        String message = MessageFormat.format(ourBundle.getString("junit.failed.to.invoke.suite"), testClass + " " + e.toString());
                        return new FailedTestCase(testClass, "suite", message, e);
                    }
                }
                catch (Throwable e) {
                    runner.clearStatus();
                    test = new TestSuite(testClass);
                }
            }
        } else {
            test = TestRunnerUtil.createMethodSuite(runner, testClass, methodName);
        }
        return test;
    }

    private static Class loadTestClass(JUnit3IdeaTestRunner runner, String suiteClassName) {
        try {
            return Class.forName(suiteClassName, false, (class$com$intellij$junit3$TestRunnerUtil == null ? (class$com$intellij$junit3$TestRunnerUtil = TestRunnerUtil.class$("com.intellij.junit3.TestRunnerUtil")) : class$com$intellij$junit3$TestRunnerUtil).getClassLoader());
        }
        catch (ClassNotFoundException e) {
            String clazz = e.getMessage();
            if (clazz == null) {
                clazz = suiteClassName;
            }
            runner.runFailed(MessageFormat.format(ourBundle.getString("junit.class.not.found"), clazz));
        }
        catch (Exception e) {
            runner.runFailed(MessageFormat.format(ourBundle.getString("junit.cannot.instantiate.tests"), e.toString()));
        }
        return null;
    }

    private static Test createMethodSuite(JUnit3IdeaTestRunner runner, Class testClass, String methodName) {
        runner.clearStatus();
        try {
            Constructor constructor = testClass.getConstructor(class$java$lang$String == null ? (class$java$lang$String = TestRunnerUtil.class$("java.lang.String")) : class$java$lang$String);
            return (Test)constructor.newInstance(methodName);
        }
        catch (NoSuchMethodException e) {
            try {
                Constructor constructor = testClass.getConstructor(new Class[0]);
                TestCase test = (TestCase)constructor.newInstance(new Object[0]);
                test.setName(methodName);
                return test;
            }
            catch (ClassCastException e1) {
                boolean methodExists;
                try {
                    testClass.getMethod(methodName, new Class[0]);
                    methodExists = true;
                }
                catch (NoSuchMethodException e2) {
                    methodExists = false;
                }
                if (!methodExists) {
                    String error = MessageFormat.format(ourBundle.getString("junit.method.not.found"), methodName);
                    String message = MessageFormat.format(ourBundle.getString("junit.cannot.instantiate.tests"), error);
                    return new FailedTestCase(testClass, methodName, message, null);
                }
                runner.runFailed(MessageFormat.format(ourBundle.getString("junit.class.not.derived"), testClass.getName()));
                return null;
            }
            catch (Exception e1) {
                String message = MessageFormat.format(ourBundle.getString("junit.cannot.instantiate.tests"), e1.toString());
                return new FailedTestCase(testClass, methodName, message, e1);
            }
        }
        catch (Throwable e) {
            String message = MessageFormat.format(ourBundle.getString("junit.cannot.instantiate.tests"), e.toString());
            return new FailedTestCase(testClass, methodName, message, e);
        }
    }

    public static String testsFoundInPackageMesage(int testCount, String name) {
        return MessageFormat.format(ourBundle.getString("tests.found.in.package"), new Integer(testCount), name);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class SuiteMethodWrapper
    implements Test {
        private final Test mySuite;
        private final String myClassName;

        public SuiteMethodWrapper(Test suite, String className) {
            this.mySuite = suite;
            this.myClassName = className;
        }

        public String getClassName() {
            return this.myClassName;
        }

        public int countTestCases() {
            return this.mySuite.countTestCases();
        }

        public void run(TestResult result) {
            this.mySuite.run(result);
        }

        public Test getSuite() {
            return this.mySuite;
        }
    }

    public static class FailedTestCase
    extends TestCase {
        private final String myMethodName;
        private final String myMessage;
        private final Throwable myThrowable;

        public FailedTestCase(Class testClass, String methodName, String message, Throwable e) {
            super(testClass.getName());
            this.myMethodName = methodName;
            this.myMessage = message;
            this.myThrowable = e;
        }

        public String getMethodName() {
            return this.myMethodName;
        }

        public String getMessage() {
            return this.myMessage;
        }

        protected void runTest() throws Throwable {
            try {
                throw new RuntimeException(this.myMessage, this.myThrowable);
            }
            catch (NoSuchMethodError e) {
                throw new RuntimeException(this.myMessage);
            }
        }
    }
}

