/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.messaging.remote.internal;

import org.gradle.messaging.dispatch.Dispatch;
import org.gradle.messaging.remote.internal.protocol.DiscoveryMessage;
import org.gradle.messaging.remote.internal.protocol.UnknownMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupMessageFilter
implements Dispatch<DiscoveryMessage> {
    private static final Logger LOGGER = LoggerFactory.getLogger(GroupMessageFilter.class);
    private final Dispatch<? super DiscoveryMessage> dispatch;
    private final String group;

    public GroupMessageFilter(String group, Dispatch<? super DiscoveryMessage> dispatch) {
        this.dispatch = dispatch;
        this.group = group;
    }

    @Override
    public void dispatch(DiscoveryMessage message) {
        if (message instanceof UnknownMessage) {
            LOGGER.debug("Discarding unknown message {}.", (Object)message);
            return;
        }
        if (!message.getGroup().equals(this.group)) {
            LOGGER.debug("Discarding message {} from unknown group {}.", (Object)message, (Object)message.getGroup());
            return;
        }
        this.dispatch.dispatch(message);
    }
}

