/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.messaging.serialize;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.gradle.messaging.serialize.Decoder;

public abstract class AbstractDecoder
implements Decoder {
    private DecoderStream stream;

    public InputStream getInputStream() {
        if (this.stream == null) {
            this.stream = new DecoderStream();
        }
        return this.stream;
    }

    public void readBytes(byte[] buffer) throws IOException {
        this.readBytes(buffer, 0, buffer.length);
    }

    public byte[] readBinary() throws EOFException, IOException {
        int size = this.readSmallInt();
        byte[] result = new byte[size];
        this.readBytes(result);
        return result;
    }

    public int readSmallInt() throws EOFException, IOException {
        return this.readInt();
    }

    public long readSmallLong() throws EOFException, IOException {
        return this.readLong();
    }

    public String readNullableString() throws EOFException, IOException {
        if (this.readBoolean()) {
            return this.readString();
        }
        return null;
    }

    public void skipBytes(long count) throws EOFException, IOException {
        long remaining;
        long skipped;
        for (remaining = count; remaining > 0L && (skipped = this.maybeSkip(remaining)) > 0L; remaining -= skipped) {
        }
        if (remaining > 0L) {
            throw new EOFException();
        }
    }

    protected abstract int maybeReadBytes(byte[] var1, int var2, int var3) throws IOException;

    protected abstract long maybeSkip(long var1) throws IOException;

    private class DecoderStream
    extends InputStream {
        byte[] buffer = new byte[1];

        private DecoderStream() {
        }

        public long skip(long n) throws IOException {
            return AbstractDecoder.this.maybeSkip(n);
        }

        public int read() throws IOException {
            int read = AbstractDecoder.this.maybeReadBytes(this.buffer, 0, 1);
            if (read <= 0) {
                return read;
            }
            return this.buffer[0] & 0xFF;
        }

        public int read(byte[] buffer) throws IOException {
            return AbstractDecoder.this.maybeReadBytes(buffer, 0, buffer.length);
        }

        public int read(byte[] buffer, int offset, int count) throws IOException {
            return AbstractDecoder.this.maybeReadBytes(buffer, offset, count);
        }
    }
}

